/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.graphs.viewer.controlm.wizard;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.utils.GraphsErrorLog;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import com.ibm.ad.graphs.viewer.controlm.model.ControlmJob;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlmJobCollector
extends BridgeResourcesCollectorAdapter<ControlmJob> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ControlmJobCollector.class);
    private static String NO_APPLICATION_LABEL = Messages.getString(ControlmJobCollector.class, (String)"controlm.no.application.label");
    private List<String> appToFilter = null;

    public ControlmJobCollector() {
    }

    public ControlmJobCollector(List<String> filterByApps) {
        this.appToFilter = filterByApps;
    }

    protected List<ControlmJob> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<ControlmJob> jobsList = new ArrayList<ControlmJob>();
        try {
            String[][] results = conn.execNonTransactionalStoredProc("EZViewer_ControlM_JobDetails", new Object[]{""});
            if (results != null && results.length > 0) {
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String jobApplication;
                    String[] row = stringArray[n2];
                    Integer jobGeneralId = Integer.valueOf(row[0]);
                    String jobName = row[1];
                    String string = jobApplication = row[2] != null && !row[2].isEmpty() ? row[2] : NO_APPLICATION_LABEL;
                    if (this.appToFilter == null || this.appToFilter.contains(jobApplication)) {
                        String jobFolderName = row[4];
                        String jobMemberName = row[5];
                        String dataSourceName = row[7];
                        String dataSourceTypeName = row[8];
                        ControlmJob controlmJob = new ControlmJob(jobGeneralId, jobName, jobApplication, jobFolderName, jobMemberName, dataSourceName, dataSourceTypeName);
                        controlmJob.setJobSubApplication(row[3]);
                        controlmJob.setJobDescription(row[6]);
                        if (row[9] != null) {
                            controlmJob.setJclJobId(Integer.valueOf(row[9]));
                            controlmJob.setJclJobName(row[10]);
                            if (row[11] != null) {
                                controlmJob.setJclStartRow(Integer.valueOf(row[11]));
                            }
                            if (row[12] != null) {
                                controlmJob.setJclStartCol(Integer.valueOf(row[12]));
                            }
                            if (row[13] != null) {
                                controlmJob.setJclEndRow(Integer.valueOf(row[13]));
                            }
                            if (row[14] != null) {
                                controlmJob.setJclEndCol(Integer.valueOf(row[14]));
                            }
                            controlmJob.setJclJobFilePath(row[15]);
                        }
                        jobsList.add(controlmJob);
                    }
                    ++n2;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("error while collecting available control-m jobs", (Throwable)e);
            GraphsErrorLog.err((String)Messages.getString(ControlmJobCollector.class, (String)"controlm.jobcollector.log.error.message"), (Throwable)e);
        }
        return jobsList;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return null;
    }
}

