/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.graphs.viewer.controlm.wizard;

import com.ez.graphs.ImpactMainPage;
import com.ez.graphs.internal.Messages;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.filters.AbstractProjectInputsFilter;
import com.ez.mainframe.gui.wizard.InputsWithSettingsPage;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.ControlmApplicationSg;
import com.ez.workspace.model.segments.ControlmJobSg;
import com.ibm.ad.graphs.viewer.controlm.model.ControlmGraphModel;
import com.ibm.ad.graphs.viewer.controlm.model.ControlmJob;
import com.ibm.ad.graphs.viewer.controlm.wizard.ControlmJobCollector;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlmGraphInputsFilter
extends AbstractProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ControlmGraphInputsFilter.class);
    private static final String SELECTED_CTRL_APPLICATIONS = "ctrlM app as inputs";
    private String projectName = null;
    private List<EZObjectType> inputs = null;
    private boolean inputIsPrj = false;

    public ControlmGraphInputsFilter(String projectName) {
        this(projectName, true);
    }

    private ControlmGraphInputsFilter(String projectName, boolean inpIsPrj) {
        this.projectName = projectName;
        this.inputIsPrj = inpIsPrj;
    }

    public ControlmGraphInputsFilter(String projectName, List<EZObjectType> inputs) {
        this(projectName, false);
        this.inputs = inputs;
    }

    protected PrepareReportWizard getWizard() {
        PrepareReportWizard wizard = new PrepareReportWizard();
        String wizardTitle = Messages.getString(ControlmGraphInputsFilter.class, (String)"controlm.wizzard.title.analysis.name");
        wizard.setWindowTitle(wizardTitle);
        wizard.setProject(this.projectName);
        if (this.inputIsPrj) {
            this.addJobsWizardPage(wizard, null);
        } else {
            this.prepareInputsForWizard(wizard);
            if (wizard.getList(SELECTED_CTRL_APPLICATIONS) != null) {
                List selApps = wizard.getList(SELECTED_CTRL_APPLICATIONS);
                this.addJobsWizardPage(wizard, selApps);
            } else {
                ImpactMainPage graphOptionsPage = new ImpactMainPage("programs page", true, false);
                graphOptionsPage.setTitle(Messages.getString(ControlmGraphInputsFilter.class, (String)"controlm.options.page.title"));
                graphOptionsPage.setDescription(Messages.getString(ControlmGraphInputsFilter.class, (String)"controlm.options.page.description"));
                graphOptionsPage.setDirectionGroupText(Messages.getString(ControlmGraphInputsFilter.class, (String)"controlm.wizzard.graph.direction.text"));
                wizard.addPage((IWizardPage)graphOptionsPage);
            }
        }
        return wizard;
    }

    private void addJobsWizardPage(PrepareReportWizard wizard, List<String> filterByApps) {
        InputsWithSettingsPage selectJobsPage = new InputsWithSettingsPage("programs page", true, false);
        selectJobsPage.setUseFilters(false);
        selectJobsPage.setTitle(Messages.getString(ControlmGraphInputsFilter.class, (String)"controlm.selectjobs.page.title"));
        selectJobsPage.setDescription(Messages.getString(ControlmGraphInputsFilter.class, (String)"controlm.selectjobs.page.description"));
        selectJobsPage.setLeftGroupLabel(Messages.getString(ControlmGraphInputsFilter.class, (String)"controlm.selectjobs.page.label.available"));
        selectJobsPage.setRightGroupLabel(Messages.getString(ControlmGraphInputsFilter.class, (String)"controlm.selectjobs.page.label.selected"));
        selectJobsPage.setDirectionGroupText(Messages.getString(ControlmGraphInputsFilter.class, (String)"controlm.wizzard.graph.direction.text"));
        selectJobsPage.setErrMsgNoResource(Messages.getString(ControlmGraphInputsFilter.class, (String)"controlm.selectjobs.page.error.message.nojobs"));
        ControlmJobCollector jobCollector = new ControlmJobCollector(filterByApps);
        selectJobsPage.setResourcesCollector((ResourcesCollector)jobCollector);
        wizard.addPage((IWizardPage)selectJobsPage);
    }

    private void prepareInputsForWizard(PrepareReportWizard wizard) {
        ArrayList<ControlmJob> selectedJobs = new ArrayList<ControlmJob>();
        ArrayList<String> selectedApps = new ArrayList<String>();
        for (EZObjectType objectType : this.inputs) {
            EZEntityID entityId = objectType.getEntID();
            ControlmJobSg controlmJobSg = (ControlmJobSg)entityId.getSegment(ControlmJobSg.class);
            if (controlmJobSg != null) {
                ControlmJob job = ControlmGraphModel.buildJobFromSegment(controlmJobSg);
                selectedJobs.add(job);
                continue;
            }
            ControlmApplicationSg controlmAppSg = (ControlmApplicationSg)entityId.getSegment(ControlmApplicationSg.class);
            selectedApps.add(controlmAppSg.getJobApplication());
        }
        if (!selectedApps.isEmpty()) {
            wizard.set(SELECTED_CTRL_APPLICATIONS, selectedApps);
        } else {
            wizard.set("selected resources", selectedJobs);
        }
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
    }
}

