/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.graphs.viewer.controlm.model;

import com.ez.cobol.callgraph.CallgraphNodeLegendInfo;
import com.ez.graphs.internal.Messages;
import com.ez.internal.analysis.config.inputs.ControlmJobObjectType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.LoadTSESVGImage;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.model.segments.ControlmApplicationSg;
import com.ez.workspace.model.segments.ControlmJobSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ibm.ad.graphs.viewer.controlm.model.ControlmCondition;
import com.ibm.ad.graphs.viewer.controlm.model.ControlmJob;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.complexity.TSENestingManager;
import images.LoadSVGImages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ControlmGraphModel
extends AbstractAnalysisGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static String JOB_UNKNOWN_LABEL = Messages.getString(ControlmGraphModel.class, (String)"controlm.job.node.unknown.label");
    private static String PROPERTIES_APPLICATION_LABEL = Messages.getString(ControlmGraphModel.class, (String)"controlm.properties.application.label");
    private static String PROPERTIES_FOLDER_LABEL = Messages.getString(ControlmGraphModel.class, (String)"controlm.properties.folder.label");
    private AbstractSharedAnalysis analysis = null;
    private Map<Integer, ControlmJob> jobsById = new HashMap<Integer, ControlmJob>();
    private Map<Integer, TSENode> jobNodesById = new HashMap<Integer, TSENode>();
    private Map<String, TSENode> appNodesByName = new HashMap<String, TSENode>();
    private Map<String, Map<String, TSENode>> folderNodesMapByApp = new HashMap<String, Map<String, TSENode>>();
    private Map<String, TSEEdge> edgesByKey = new HashMap<String, TSEEdge>();

    public ControlmGraphModel(AnalysisGraphManager graphManager, AbstractSharedAnalysis analysis) {
        this.graphManager = graphManager;
        this.analysis = analysis;
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
    }

    public void addControlmJob(ControlmJob job) {
        this.jobsById.put(job.getJobGeneralId(), job);
    }

    public ControlmJob getControlmJob(Integer jobId) {
        return this.jobsById.get(jobId);
    }

    private void initGraph() {
        this.clearData();
        this.graph = (TSEGraph)this.graphManager.addGraph();
        this.graphManager.getNodeBuilder().setResizability(3);
    }

    public List<TSEGraph> getGraphs() {
        TSEGraph mainGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
        ArrayList<TSEGraph> graphsList = new ArrayList<TSEGraph>();
        graphsList.add(mainGraph);
        TSENestingManager.buildAllNestedGraphList((TSDGraph)mainGraph, graphsList, (boolean)false);
        return graphsList;
    }

    public void loadGraph(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.setTaskName(Messages.getString(ControlmGraphModel.class, (String)"controlm.load.graph.progress.text"));
        this.initGraph();
        this.graphManager.startBatchProcessing(true);
        SubMonitor loopProgress = progress.newChild(90).setWorkRemaining(this.jobsById.values().size());
        for (ControlmJob controlmJob : this.jobsById.values()) {
            TSENode sourceJobNode = this.getOrCreateJobNode(controlmJob);
            Direction edgeDirection = Direction.FORWARD;
            this.handleConditions(controlmJob, sourceJobNode, edgeDirection);
            edgeDirection = Direction.BACKWARD;
            this.handleConditions(controlmJob, sourceJobNode, edgeDirection);
            loopProgress.worked(1);
        }
        loopProgress = progress.newChild(5).setWorkRemaining(this.appNodesByName.values().size());
        for (TSENode tSENode : this.appNodesByName.values()) {
            TSENestingManager.expand((TSDNode)tSENode);
            loopProgress.worked(1);
        }
        loopProgress = progress.newChild(5).setWorkRemaining(this.folderNodesMapByApp.values().size());
        for (Map map : this.folderNodesMapByApp.values()) {
            for (TSENode folderNode : map.values()) {
                TSENestingManager.expand((TSDNode)folderNode);
            }
            loopProgress.worked(1);
        }
        this.graphManager.endBatchProcessing();
    }

    private void handleConditions(ControlmJob sourceJob, TSENode sourceJobNode, Direction edgeDirection) {
        Map<Integer, Map<Integer, ControlmCondition>> conditionsByTargetJobId = null;
        conditionsByTargetJobId = Direction.FORWARD.equals((Object)edgeDirection) ? sourceJob.getOutMap() : sourceJob.getInMap();
        for (Map.Entry<Integer, Map<Integer, ControlmCondition>> mapEntry : conditionsByTargetJobId.entrySet()) {
            Integer targetJobId = mapEntry.getKey();
            Map<Integer, ControlmCondition> conditionsById = mapEntry.getValue();
            ControlmJob targetJob = null;
            TSENode targetJobNode = null;
            targetJob = targetJobId != null ? this.jobsById.get(targetJobId) : new ControlmJob(null, JOB_UNKNOWN_LABEL, sourceJob.getJobApplication(), sourceJob.getJobFolderName(), null, null, null);
            targetJobNode = this.getOrCreateJobNode(targetJob);
            String edgeKey = null;
            edgeKey = Direction.FORWARD.equals((Object)edgeDirection) ? sourceJob.getJobGeneralId() + "-" + targetJob.getJobGeneralId() : targetJob.getJobGeneralId() + "-" + sourceJob.getJobGeneralId();
            this.getOrCreateEdge(sourceJobNode, targetJobNode, conditionsById, edgeDirection, edgeKey);
        }
    }

    private TSENode getOrCreateJobNode(ControlmJob job) {
        TSENode jobNode;
        TSEGraph folderGraph;
        String folder;
        TSENode folderNode;
        Map<String, TSENode> folderNodesByName;
        TSEGraph appGraph;
        String application = job.getJobApplication();
        TSENode appNode = this.appNodesByName.get(application);
        if (appNode == null) {
            appNode = (TSENode)this.graph.addNode();
            appNode.setName((Object)application);
            this.appNodesByName.put(application, appNode);
            appNode.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(application, PROPERTIES_APPLICATION_LABEL));
            EZObjectType inputType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(5224), "EZ_OBJECT_TYPE_FOR_MAINFRAME_RESOURCE");
            ControlmApplicationSg resourceSg = new ControlmApplicationSg(application);
            EZEntityID entID = new EZEntityID();
            inputType.setEntID(entID);
            ProjectInfo projectInfo = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
            EZSourceProjectIDSg projectSg = new EZSourceProjectIDSg(projectInfo);
            entID.addSegment((EZSegment)projectSg);
            entID.addSegment((EZSegment)resourceSg);
            appNode.setAttribute("APPLICABLE_INPUT", (Object)inputType);
        }
        if ((appGraph = (TSEGraph)appNode.getChildGraph()) == null) {
            appGraph = (TSEGraph)this.graphManager.addGraph();
            appNode.setChildGraph((TSGraph)appGraph);
        }
        if ((folderNodesByName = this.folderNodesMapByApp.get(application)) == null) {
            folderNodesByName = new HashMap<String, TSENode>();
            this.folderNodesMapByApp.put(application, folderNodesByName);
        }
        if ((folderNode = folderNodesByName.get(folder = job.getJobFolderName())) == null) {
            folderNode = (TSENode)appGraph.addNode();
            folderNode.setName((Object)folder);
            folderNodesByName.put(folder, folderNode);
            folderNode.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(folder, PROPERTIES_FOLDER_LABEL));
        }
        if ((folderGraph = (TSEGraph)folderNode.getChildGraph()) == null) {
            folderGraph = (TSEGraph)this.graphManager.addGraph();
            folderNode.setChildGraph((TSGraph)folderGraph);
        }
        if ((jobNode = this.jobNodesById.get(job.getJobGeneralId())) == null) {
            jobNode = (TSENode)folderGraph.addNode();
            jobNode.setName((Object)job.getName());
            this.setJobNodeAttributes(job, jobNode);
            this.putEntryInGraphInventory(appNode, folderNode, jobNode);
            if (job.getJobGeneralId() != null) {
                this.jobNodesById.put(job.getJobGeneralId(), jobNode);
            }
        }
        return jobNode;
    }

    private TSEEdge getOrCreateEdge(TSENode sourceJobNode, TSENode targetJobNode, Map<Integer, ControlmCondition> conditionsById, Direction edgeDirection, String edgeKey) {
        TSEEdge edge = this.edgesByKey.get(edgeKey);
        if (edge == null) {
            edge = Direction.FORWARD.equals((Object)edgeDirection) ? (TSEEdge)this.graphManager.addEdge((TSNode)sourceJobNode, (TSNode)targetJobNode) : (TSEEdge)this.graphManager.addEdge((TSNode)targetJobNode, (TSNode)sourceJobNode);
            edge.setAttribute("edge properties key", conditionsById.values());
            edge.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)true);
            this.edgesByKey.put(edgeKey, edge);
        }
        return edge;
    }

    private void setJobNodeAttributes(ControlmJob job, TSENode jobNode) {
        this.setJobObjectType(job, jobNode);
        jobNode.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(job.getJobName(), ResultElementType.JCL_JOB.getDisplayName()));
        CallgraphNodeLegendInfo nodeTypeInfo = CallgraphNodeLegendInfo.JCL_JOB;
        jobNode.setAttribute("class_name", (Object)nodeTypeInfo.getNodeTypeClass());
        TSEColor textColor = TSEColor.white;
        this.setNodeUI(jobNode, nodeTypeInfo.getGraphImagePath(), nodeTypeInfo.getTSEColor(), textColor);
        this.nodeTypesSetForLegend.add(nodeTypeInfo);
    }

    private void setJobObjectType(ControlmJob job, TSENode jobNode) {
        ControlmJobObjectType objectType = null;
        EZEntityID entityId = new EZEntityID();
        ProjectInfo projectInfo = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        EZSourceProjectIDSg projectSg = new EZSourceProjectIDSg(projectInfo);
        entityId.addSegment((EZSegment)projectSg);
        if (job.getJclJobId() != null) {
            objectType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(22));
            boolean deleted = false;
            EZSourceJobIDSg jclJobSg = new EZSourceJobIDSg(job.getJclJobName(), job.getJclJobId().toString(), 22, job.getJobMemberName(), deleted);
            entityId.addSegment((EZSegment)jclJobSg);
            HashSet<TextSelectionInFile> set = new HashSet<TextSelectionInFile>();
            set.add(new TextSelectionInFile(job.getJclJobFilePath(), String.valueOf(22), new Integer[]{job.getJclStartRow(), job.getJclStartCol(), job.getJclEndRow(), job.getJclEndCol()}));
            jobNode.setAttribute("FILE", set);
            jobNode.setAttribute("GOTOSOURCE", (Object)Boolean.TRUE);
        } else {
            objectType = new ControlmJobObjectType();
        }
        ControlmJobSg controlmJobSg = ControlmGraphModel.buildSegmentFromJob(job);
        entityId.addSegment((EZSegment)controlmJobSg);
        objectType.setEntID(entityId);
        jobNode.setAttribute("APPLICABLE_INPUT", (Object)objectType);
    }

    private void setNodeUI(TSENode node, String svgImagePath, TSEColor fillColor, TSEColor textColor) {
        TSESVGImage svgimage = LoadTSESVGImage.loadImage(LoadSVGImages.class, (String)svgImagePath);
        node.setAttribute("uiImage", (Object)svgimage);
        node.setAttribute("Fill_Color", (Object)fillColor);
        node.setAttribute("Color", (Object)textColor);
        this.setNodeUI(node);
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
            TSEColor color = (TSEColor)node.getAttributeValue("Color");
            if (color != null) {
                node.setAttribute("Text_Color", (Object)color);
            }
        }
    }

    private void putEntryInGraphInventory(TSENode appNode, TSENode folderNode, TSENode jobNode) {
        HashSet<TSENode> jobs;
        HashMap<TSENode, HashSet<TSENode>> jobsByFolder;
        String root = "graph inventory hidden root";
        HashMap foldersByApp = (HashMap)this.outForGISV.get(root);
        if (foldersByApp == null) {
            foldersByApp = new HashMap();
            this.outForGISV.put(root, foldersByApp);
        }
        if ((jobsByFolder = (HashMap<TSENode, HashSet<TSENode>>)foldersByApp.get(appNode)) == null) {
            jobsByFolder = new HashMap<TSENode, HashSet<TSENode>>();
            foldersByApp.put(appNode, jobsByFolder);
        }
        if ((jobs = (HashSet<TSENode>)jobsByFolder.get(folderNode)) == null) {
            jobs = new HashSet<TSENode>();
            jobsByFolder.put(folderNode, jobs);
        }
        jobs.add(jobNode);
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType inputType = null;
        if (gNode != null && gNode.hasAttribute("APPLICABLE_INPUT")) {
            inputType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
        }
        return inputType;
    }

    public int getNumberOfResultNodes() {
        int count = 0;
        for (TSEGraph graph : this.getGraphs()) {
            count += graph.numberOfNodes();
        }
        return count;
    }

    private void clearData() {
        if (this.graph != null) {
            this.graph.clear();
            this.graph.dispose();
        }
        this.jobNodesById.clear();
        this.appNodesByName.clear();
        this.folderNodesMapByApp.clear();
        this.edgesByKey.clear();
        this.outForGISV.clear();
        this.edgeTypesSetForLegend.clear();
        this.nodeTypesSetForLegend.clear();
    }

    public void dispose() {
        this.clearData();
        this.jobNodesById = null;
        this.appNodesByName = null;
        this.folderNodesMapByApp = null;
        this.edgesByKey = null;
        super.dispose();
    }

    public void updateDrawing() {
        for (TSEGraph graph : this.getGraphs()) {
            List nodes = graph.nodes();
            for (TSENode node : nodes) {
                this.setNodeUI(node);
            }
        }
    }

    public static ControlmJobSg buildSegmentFromJob(ControlmJob job) {
        ControlmJobSg controlmJobSg = new ControlmJobSg(job.getJobGeneralId(), job.getJobName(), job.getJobApplication(), job.getJobFolderName(), job.getJobMemberName(), job.getDataSourceName(), job.getDataSourceTypeName());
        controlmJobSg.setJobSubApplication(job.getJobSubApplication());
        controlmJobSg.setJobDescription(job.getJobDescription());
        if (job.getJclJobId() != null) {
            controlmJobSg.setJclJobId(job.getJclJobId());
            controlmJobSg.setJclJobName(job.getJclJobName());
            controlmJobSg.setJclStartRow(job.getJclStartRow());
            controlmJobSg.setJclStartCol(job.getJclStartCol());
            controlmJobSg.setJclEndRow(job.getJclEndRow());
            controlmJobSg.setJclEndCol(job.getJclEndCol());
            controlmJobSg.setJclJobFilePath(job.getJclJobFilePath());
        }
        return controlmJobSg;
    }

    public static ControlmJob buildJobFromSegment(ControlmJobSg segment) {
        ControlmJob controlmJobSg = new ControlmJob(segment.getJobGeneralId(), segment.getJobName(), segment.getJobApplication(), segment.getJobFolderName(), segment.getJobMemberName(), segment.getDataSourceName(), segment.getDataSourceTypeName());
        controlmJobSg.setJobSubApplication(segment.getJobSubApplication());
        controlmJobSg.setJobDescription(segment.getJobDescription());
        if (segment.getJclJobId() != null) {
            controlmJobSg.setJclJobId(segment.getJclJobId());
            controlmJobSg.setJclJobName(segment.getJclJobName());
            controlmJobSg.setJclStartRow(segment.getJclStartRow());
            controlmJobSg.setJclStartCol(segment.getJclStartCol());
            controlmJobSg.setJclEndRow(segment.getJclEndRow());
            controlmJobSg.setJclEndCol(segment.getJclEndCol());
            controlmJobSg.setJclJobFilePath(segment.getJclJobFilePath());
        }
        return controlmJobSg;
    }
}

