/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.graphs.viewer.controlm;

import com.ez.cobol.callgraph.utils.Utils;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.Activator;
import com.ez.graphs.viewer.utils.GraphsErrorLog;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ibm.ad.graphs.viewer.controlm.model.ControlmCondition;
import com.ibm.ad.graphs.viewer.controlm.model.ControlmGraphModel;
import com.ibm.ad.graphs.viewer.controlm.model.ControlmJob;
import com.ibm.ad.graphs.viewer.controlm.ui.ControlmContentProvider;
import com.ibm.ad.graphs.viewer.controlm.ui.ControlmMouseActionsHook;
import com.ibm.ad.graphs.viewer.controlm.wizard.ControlmGraphInputsFilter;
import com.ibm.ad.graphs.viewer.controlm.wizard.ControlmJobCollector;
import com.tomsawyer.canvas.TSViewportCanvas;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.interactive.TSInteractivePreferenceTailor;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.command.editing.TSEGlobalLayoutCommand;
import com.tomsawyer.interactive.command.editing.TSELayoutCommand;
import com.tomsawyer.interactive.tool.TSToolInterface;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.TSServiceInputDataInterface;
import com.tomsawyer.service.layout.TSHierarchicalLayoutInputTailor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlmGraphAnalysisJob
extends GraphAnalysisJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ControlmGraphAnalysisJob.class);
    private Integer DIRECTION_FORWARD = new Integer(1);
    private Integer DIRECTION_BACKWARD = new Integer(2);
    private static final int MAXNAMES = 2;
    public static final String ALL_CTRLM_JOBS = "all ctrlm jobs form the project";
    private ControlmMouseActionsHook mouseActionsHook = null;

    public ControlmGraphAnalysisJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new ControlmMouseActionsHook(id);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphModel = new ControlmGraphModel(new AnalysisGraphManager(), this.analysis);
        this.graphInfo = new ControlmGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        if (this.graphInfo.getContentProviders() == null) {
            ControlmContentProvider icp = new ControlmContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        this.contributeIconEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.setTaskName(Messages.getString(ControlmGraphAnalysisJob.class, (String)"controlm.collect.data.progress.text"));
        ProjectInfo projectInfo = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        final String projectName = projectInfo.getName();
        try {
            L.debug("will open project {}", (Object)projectName);
            IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            IMFProjectHandler ph = service.getProjectHandler(projectName, null);
            if (!progress.isCanceled()) {
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor monitor) {
                        boolean allAsInputs;
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        long startTime = -1L;
                        long duration = -1L;
                        HashMap<Integer, ControlmJob> allJobsMap = new HashMap<Integer, ControlmJob>();
                        List availableJobs = new ArrayList();
                        try {
                            ControlmJobCollector jobCollector = new ControlmJobCollector();
                            availableJobs = jobCollector.collect(false, null, projectName, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Exception e) {
                            L.error("error while preloading available control-m jobs", (Throwable)e);
                            GraphsErrorLog.err((String)Messages.getString(ControlmGraphInputsFilter.class, (String)"controlm.jobcollector.log.error.message"), (Throwable)e);
                        }
                        ControlmGraphAnalysisJob.this.analysis.addContextValue("available resources", availableJobs);
                        for (ControlmJob job : availableJobs) {
                            allJobsMap.put(job.getJobGeneralId(), job);
                        }
                        ArrayList<Integer> values = new ArrayList<Integer>();
                        List selectedJobs = ControlmGraphAnalysisJob.this.analysis.getContextListValue("selected resources");
                        if (selectedJobs.size() != availableJobs.size()) {
                            for (ControlmJob job : selectedJobs) {
                                values.add(job.getJobGeneralId());
                            }
                        }
                        Direction direction = (Direction)ControlmGraphAnalysisJob.this.analysis.getContextValue("graph direction: forward or backward or both");
                        String[][] forwardResults = null;
                        String[][] backwardResults = null;
                        boolean bl = allAsInputs = values.isEmpty();
                        if (allAsInputs) {
                            startTime = System.currentTimeMillis();
                            forwardResults = conn.execNonTransactionalStoredProc("EZViewer_ControlM_JobRelationDetails", new Object[]{ControlmGraphAnalysisJob.this.DIRECTION_FORWARD});
                            duration = System.currentTimeMillis() - startTime;
                            L.debug("full results sp duration: {}", (Object)duration);
                        } else {
                            List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[values.size()]);
                            Collections.fill(types, EZSourceDataType.Integer);
                            if (Direction.doForward((Direction)direction)) {
                                startTime = System.currentTimeMillis();
                                forwardResults = conn.execNonTransactionalStoredProc("EZViewer_ControlM_JobRelationDetails", new Object[]{ControlmGraphAnalysisJob.this.DIRECTION_FORWARD}, types, values);
                                duration = System.currentTimeMillis() - startTime;
                                L.debug("fwd results sp duration: {}", (Object)duration);
                            }
                            if (Direction.doBackward((Direction)direction)) {
                                startTime = System.currentTimeMillis();
                                backwardResults = conn.execNonTransactionalStoredProc("EZViewer_ControlM_JobRelationDetails", new Object[]{ControlmGraphAnalysisJob.this.DIRECTION_BACKWARD}, types, values);
                                duration = System.currentTimeMillis() - startTime;
                                L.debug("bwd results sp duration: {}", (Object)duration);
                            }
                        }
                        progress.worked(90);
                        startTime = System.currentTimeMillis();
                        if (forwardResults != null && forwardResults.length > 0) {
                            ControlmGraphAnalysisJob.this.processJobRelationsResults(allJobsMap, forwardResults);
                        } else if (Direction.doForward((Direction)direction)) {
                            L.debug("no or empty forward results for control-m graph");
                        }
                        if (backwardResults != null && backwardResults.length > 0) {
                            ControlmGraphAnalysisJob.this.processJobRelationsResults(allJobsMap, backwardResults);
                        } else if (!allAsInputs && Direction.doBackward((Direction)direction)) {
                            L.debug("no or empty backward results for control-m graph");
                        }
                        progress.worked(10);
                        duration = System.currentTimeMillis() - startTime;
                        L.debug("process results duration: {}", (Object)duration);
                    }
                }, LockType.Shared, (IProgressMonitor)progress.newChild(100));
            }
        }
        catch (Exception e) {
            L.error("error while collecting data for control-m graph analysis", (Throwable)e);
            GraphsErrorLog.err((String)Messages.getString(ControlmGraphAnalysisJob.class, (String)"controlm.collect.data.error.message"), (Throwable)e);
        }
    }

    private void processJobRelationsResults(Map<Integer, ControlmJob> allJobsMap, String[][] results) {
        if (results != null) {
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                ControlmJob toJob;
                String toJobName;
                String fromJobName;
                String[] row = stringArray[n2];
                Integer fromJobId = row[0] != null && !row[0].isEmpty() ? Integer.valueOf(row[0]) : null;
                Integer toJobId = row[1] != null && !row[1].isEmpty() ? Integer.valueOf(row[1]) : null;
                Integer conditionId = row[2] != null && !row[2].isEmpty() ? Integer.valueOf(row[2]) : null;
                String conditionName = row[3];
                String conditionAndOr = row[4];
                String conditionODate = row[5] != null ? row[5] : "";
                ControlmJob fromJob = allJobsMap.get(fromJobId);
                String string = fromJobName = fromJob != null ? fromJob.getJobName() : null;
                if (fromJobId != null && fromJob == null) {
                    L.warn("Unexpected 'from' JobGeneralId in a relationship: JobFromGeneralId: {} JobToGeneralId: {} ConditionGeneralId: {} ContidionName: {}", new Object[]{fromJobId, toJobId, conditionId, conditionName});
                }
                String string2 = toJobName = (toJob = allJobsMap.get(toJobId)) != null ? toJob.getJobName() : null;
                if (toJobId != null && toJob == null) {
                    L.warn("Unexpected 'to' JobGeneralId in relationship: JobFromGeneralId: {} JobToGeneralId: {} ConditionGeneralId: {} ContidionName: {}", new Object[]{toJobId, toJobId, conditionId, conditionName});
                }
                if (fromJob != null) {
                    if (((ControlmGraphModel)this.graphModel).getControlmJob(fromJobId) == null) {
                        ((ControlmGraphModel)this.graphModel).addControlmJob(fromJob);
                    }
                    if (toJob == null) {
                        if (conditionId == null) {
                            L.debug("not connected job: JobFromGeneralId: {} (JobFromName: {})", (Object)fromJobId, (Object)fromJobName);
                        } else {
                            L.debug("orphan OUT condition: JobFromGeneralId: {} (JobFromName: {}) ConditionGeneralId: {} ContidionName: {}", new Object[]{fromJobId, fromJobName, conditionId, conditionName});
                        }
                    }
                }
                if (toJob != null) {
                    if (((ControlmGraphModel)this.graphModel).getControlmJob(toJobId) == null) {
                        ((ControlmGraphModel)this.graphModel).addControlmJob(toJob);
                    }
                    if (fromJob == null) {
                        if (conditionId == null) {
                            L.debug("not connected job: JobToGeneralId: {} (JobToName: {})", (Object)toJobId, (Object)toJobName);
                        } else {
                            L.debug("orphan IN condition: JobToGeneralId: {} JobToName: {} ConditionGeneralId: {} ContidionName: {}", new Object[]{toJobId, toJobName, conditionId, conditionName});
                        }
                    }
                }
                ControlmCondition condition = null;
                if (conditionId != null) {
                    condition = new ControlmCondition(conditionId, conditionName, conditionAndOr, conditionODate);
                    if (fromJob != null) {
                        fromJob.addOutCondition(toJobId, condition);
                    }
                    if (toJob != null) {
                        toJob.addInCondition(fromJobId, condition);
                    }
                }
                ++n2;
            }
        }
    }

    protected TSCommand doLayout(int type, TSEGraph graph) {
        TSCommand layoutCommand = null;
        switch (type) {
            case 1: {
                L.debug("custom hierarchical layout");
                layoutCommand = this.createHierarchicalLayoutCommand(graph);
                break;
            }
            default: {
                layoutCommand = super.doLayout(type, graph);
            }
        }
        return layoutCommand;
    }

    protected TSELayoutCommand createHierarchicalLayoutCommand(TSEGraph graph) {
        TSServiceInputData inputData = ((AnalysisGraphManager)this.graphManager).inputData;
        TSInteractivePreferenceTailor layoutPreferenceTailor = new TSInteractivePreferenceTailor(this.canvas.getPreferenceData());
        layoutPreferenceTailor.setThreadedLayout(true);
        layoutPreferenceTailor.setShowLayoutProgress(false);
        TSHierarchicalLayoutInputTailor layoutInputTailor = new TSHierarchicalLayoutInputTailor((TSServiceInputDataInterface)inputData, (TSDGraph)graph);
        layoutInputTailor.setAsCurrentLayoutStyle();
        layoutInputTailor.setLevelAlignment(0);
        layoutInputTailor.setKeepNodeSizes(true);
        layoutInputTailor.setSlopeEndRouting(true);
        layoutInputTailor.setVariableLevelSpacing(true);
        layoutInputTailor.setBackwardEdgeMode(0);
        TSEGlobalLayoutCommand layoutCommand = new TSEGlobalLayoutCommand((TSViewportCanvas)this.canvas, (TSServiceInputDataInterface)inputData);
        return layoutCommand;
    }

    private void addEntriesToLegend(LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        this.addNodeTypesToLegend(legend, uiStyle);
    }

    private void addNodeTypesToLegend(LegendPanel legend, int uiStyle) {
        Set nodeTypesSetForLegend = this.graphModel.getNodeTypesForLegend();
        ArrayList nodeTypesList = new ArrayList(nodeTypesSetForLegend);
        Collections.sort(nodeTypesList, new Comparator<IGraphNodeLegendInfo>(){

            @Override
            public int compare(IGraphNodeLegendInfo nodeType1, IGraphNodeLegendInfo nodeType2) {
                return nodeType1.getLegendLabel().compareTo(nodeType2.getLegendLabel());
            }
        });
        for (IGraphNodeLegendInfo nodeLegendInfo : nodeTypesList) {
            String imagePath = null;
            if (uiStyle == 2) {
                imagePath = nodeLegendInfo.getLegendImagePath();
            } else if (uiStyle == 0) {
                imagePath = nodeLegendInfo.getColorboxImagePath();
            }
            legend.placeLegendEntry(imagePath, nodeLegendInfo.getLegendLabel());
        }
    }

    class ControlmGraphInfo
    extends GraphInfoAdapter {
        private String tabName;

        public ControlmGraphInfo(EZEntityID id) {
            super(id);
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor((String)"icons/controlm.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            return this.getText(true);
        }

        public String getText(boolean truncate) {
            ProjectInfo projectInfo = (ProjectInfo)ControlmGraphAnalysisJob.this.analysis.getContextValue("PROJECT_INFO");
            String projectName = projectInfo.getName();
            List selectedJobs = ControlmGraphAnalysisJob.this.analysis.getContextListValue("selected resources");
            StringBuilder sBuilder = new StringBuilder();
            int remainingCount = 0;
            if (selectedJobs != null && !selectedJobs.isEmpty()) {
                int idx = 0;
                int selectedCount = selectedJobs.size();
                for (ControlmJob job : selectedJobs) {
                    if (idx >= 2) {
                        remainingCount = selectedCount - idx;
                        break;
                    }
                    sBuilder.append(job.getListableName());
                    if (++idx >= selectedCount) continue;
                    sBuilder.append(", ");
                }
            }
            this.tabName = remainingCount > 0 ? Messages.getString(ControlmGraphAnalysisJob.class, (String)"controlm.tab.title.truncated", (Object[])new String[]{sBuilder.toString(), String.valueOf(remainingCount), projectName}) : Messages.getString(ControlmGraphAnalysisJob.class, (String)"controlm.tab.title", (Object[])new String[]{sBuilder.toString(), projectName});
            return this.tabName;
        }

        public String getTooltip() {
            Direction direction = (Direction)ControlmGraphAnalysisJob.this.analysis.getContextValue("graph direction: forward or backward or both");
            StringBuilder sBuilder = new StringBuilder(this.tabName);
            sBuilder.append("; ");
            sBuilder.append(direction.toString());
            return sBuilder.toString();
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    ControlmGraphAnalysisJob.this.legend = new LegendPanel((Composite)sc, 0);
                    Utils.setImageProvider((LegendPanel)ControlmGraphAnalysisJob.this.legend);
                    int uiStyle = ControlmGraphAnalysisJob.this.graphModel.getUIStyle();
                    ControlmGraphAnalysisJob.this.addEntriesToLegend(ControlmGraphAnalysisJob.this.legend, uiStyle, ControlmGraphAnalysisJob.this.gfi);
                    sc.setContent((Control)ControlmGraphAnalysisJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    ControlmGraphAnalysisJob.this.legend.pack();
                    sc.setMinSize(ControlmGraphAnalysisJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((ControlmGraphAnalysisJob)((ControlmGraphInfo)ControlmGraphInfo.this).ControlmGraphAnalysisJob.this).legend.getSize().x;
                    int x = ((ControlmGraphAnalysisJob)((ControlmGraphInfo)ControlmGraphInfo.this).ControlmGraphAnalysisJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return true;
        }

        public void dispose() {
            ControlmGraphAnalysisJob.this.gfi = null;
            ControlmGraphAnalysisJob.this.legend = null;
            super.dispose();
        }
    }
}

