/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.graphs.viewer.controlm;

import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ibm.ad.graphs.viewer.controlm.ControlmGraphAnalysisJob;
import com.ibm.ad.graphs.viewer.controlm.wizard.ControlmGraphInputsFilter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlmGraphAnalysis
extends MainframeGraphAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ControlmGraphAnalysis.class);
    public static final String CONTROLM_JOB_DETAILS_SP_NAME = "EZViewer_ControlM_JobDetails";
    public static final String CONTROLM_JOB_RELATION_DETAILS_SP_NAME = "EZViewer_ControlM_JobRelationDetails";
    private ControlmGraphAnalysisJob job = null;

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.CONTROLM_GRAPH_ANALYSIS;
    }

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (ControlmGraphAnalysisJob)wk.getJob(id, ControlmGraphAnalysisJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    public void setInputs(List inputs) {
        this.addContextValue("input_list", inputs);
    }

    protected InputsFilter getInputsFilter() {
        ControlmGraphInputsFilter inputsFilter = null;
        ProjectInfo projectInfo = null;
        List inputs = this.getContextListValue("input_list");
        EZObjectType inputObjectType = (EZObjectType)inputs.get(0);
        if (inputs.size() == 1 && inputObjectType instanceof EZSourceProjectInputType) {
            L.debug("controlm graph analysis started on a project");
            projectInfo = (ProjectInfo)((EZSourceProjectInputType)inputObjectType).getProperty("PROJECT_INFO");
            inputsFilter = new ControlmGraphInputsFilter(projectInfo.getName());
        } else {
            L.debug("controlm graph analysis started on controlm jobs or applications");
            EZEntityID entityId = inputObjectType.getEntID();
            projectInfo = ((EZSourceProjectIDSg)entityId.getSegment(EZSourceProjectIDSg.class)).getProjectInfo();
            inputsFilter = new ControlmGraphInputsFilter(projectInfo.getName(), inputs);
        }
        this.addContextValue("PROJECT_INFO", projectInfo);
        this.addContextValue("input_project_names", projectInfo.getName());
        return inputsFilter;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractAnalysis)) {
            return false;
        }
        AbstractAnalysis a2 = (AbstractAnalysis)obj;
        boolean result = this.type.equals((Object)a2.getType());
        if (result) {
            ProjectInfo projectInfo1 = (ProjectInfo)this.getContextValue("PROJECT_INFO");
            ProjectInfo projectInfo2 = (ProjectInfo)a2.getContextValue("PROJECT_INFO");
            result = projectInfo1.equals((Object)projectInfo2);
        }
        if (result) {
            Direction direction1 = (Direction)this.getContextValue("graph direction: forward or backward or both");
            Direction direction2 = (Direction)a2.getContextValue("graph direction: forward or backward or both");
            result = direction1.equals((Object)direction2);
        }
        if (result) {
            List selectedJobs1 = this.getContextListValue("selected resources");
            List selectedJobs2 = a2.getContextListValue("selected resources");
            result = selectedJobs1.equals(selectedJobs2);
        }
        return result;
    }
}

