/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.carma.request.model;

import com.ibm.carma.model.CARMAResource;
import com.ibm.carma.request.CARMARequestUtil;
import com.ibm.carma.request.model.CARMARepositoryConnection;
import com.ibm.carma.request.model.CARMARepositoryInstance;
import com.ibm.carma.request.model.CARMAResourceActivityListener;
import com.ibm.carma.request.model.CARMAResourceEvent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;

public class CARMARepositoryResource {
    private List<CARMAResourceActivityListener> listenerList;
    private CARMARepositoryInstance repositoryInstance;
    private CARMAResource resource;
    private String filterString;
    boolean readOnly = true;

    public CARMARepositoryResource() {
        this.repositoryInstance = null;
        this.resource = null;
        this.filterString = null;
        this.listenerList = null;
    }

    public CARMARepositoryResource(CARMARepositoryInstance repositoryInstance, CARMAResource resource) {
        this.repositoryInstance = repositoryInstance;
        this.resource = resource;
        this.filterString = null;
        this.listenerList = null;
    }

    public CARMARepositoryResource(CARMARepositoryInstance repositoryInstance, CARMAResource resource, String filterString, boolean readOnly) {
        this.repositoryInstance = repositoryInstance;
        this.resource = resource;
        this.filterString = filterString;
        this.readOnly = readOnly;
        this.listenerList = null;
    }

    public CARMARepositoryInstance getRepositoryInstance() {
        return this.repositoryInstance;
    }

    public void setRepositoryInstance(CARMARepositoryInstance repositoryInstance) {
        this.repositoryInstance = repositoryInstance;
    }

    public CARMAResource getResource() {
        return this.resource;
    }

    public void setResource(CARMAResource resource) {
        this.resource = resource;
    }

    public CARMARepositoryConnection getCarmaConnection() {
        CARMARepositoryConnection connection = null;
        if (this.repositoryInstance != null) {
            connection = this.repositoryInstance.getCarmaConnection();
        }
        return connection;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getMemberId() {
        String memberId = null;
        if (this.resource != null) {
            memberId = this.resource.getMemberId();
        }
        return memberId;
    }

    public String getName() {
        String name = "";
        if (this.resource != null) {
            name = this.resource.getName();
        }
        return name;
    }

    public void extractContents() {
        this.extractContents(true);
    }

    public void extractContents(boolean readOnly) {
        this.readOnly = readOnly;
        CARMARequestUtil.extractCARMAResourceContents(this, readOnly);
    }

    public void openInEditor() {
        CARMARequestUtil.openCARMAResourceInEditor(this, this.readOnly);
    }

    public void addCARMAResourceActivityListener(CARMAResourceActivityListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new ArrayList<CARMAResourceActivityListener>();
        }
        this.listenerList.add(listener);
    }

    public void removeCARMAResourceActivityListener(CARMAResourceActivityListener listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(listener);
        }
    }

    public void notifyResourceContentsUpdated(IFile contents) {
        if (this.listenerList != null) {
            for (CARMAResourceActivityListener listener : this.listenerList) {
                CARMAResourceEvent event = new CARMAResourceEvent(this, contents);
                listener.resourceContentsUpdated(event);
            }
        }
    }

    public void removeFilterView() {
        if (this.filterString != null) {
            CARMARequestUtil.removeFilterView(this, this.filterString);
            this.filterString = null;
        }
    }
}

