/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.carma.request.model;

import com.ibm.carma.model.RepositoryInstance;
import com.ibm.carma.model.RepositoryManager;
import com.ibm.carma.request.CARMAConnectionNotConnectedException;
import com.ibm.carma.request.CARMANotSynchronizedException;
import com.ibm.carma.request.CARMARequestUtil;
import com.ibm.carma.request.CARMAUnsupportedOperationException;
import com.ibm.carma.request.model.CARMARepositoryConnection;
import com.ibm.carma.request.model.CARMARepositoryManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;

public class CARMARepositoryInstance {
    private CARMARepositoryManager carmaRepositoryManager;
    private RepositoryInstance carmaRepositoryInstance;
    private String environmentName;
    private String systemName;
    private String stageName;
    private String stageId;

    public CARMARepositoryInstance() {
        this.carmaRepositoryInstance = null;
        this.carmaRepositoryManager = null;
    }

    public CARMARepositoryInstance(CARMARepositoryManager carmaRepositoryManager, RepositoryInstance carmaRepositoryInstance) {
        this.carmaRepositoryManager = carmaRepositoryManager;
        this.carmaRepositoryInstance = carmaRepositoryInstance;
    }

    public CARMARepositoryInstance(CARMARepositoryManager carmaRepositoryManager, String environmentName, String systemName, String stageName, String stageId) {
        this.carmaRepositoryManager = carmaRepositoryManager;
        this.carmaRepositoryInstance = null;
        this.environmentName = environmentName;
        this.systemName = systemName;
        this.stageName = stageName;
        this.stageId = stageId;
    }

    public RepositoryInstance getCarmaRepositoryInstance() throws OperationCanceledException, CARMAUnsupportedOperationException, CARMAConnectionNotConnectedException, CARMANotSynchronizedException, CoreException {
        RepositoryManager manager;
        if (this.carmaRepositoryInstance == null && this.carmaRepositoryManager != null && (manager = this.carmaRepositoryManager.getCarmaRepositoryManager()) != null) {
            String repositoryInstanceID = CARMARequestUtil.getRepositoryInstanceID(this.environmentName, this.systemName, this.stageName, this.stageId);
            this.carmaRepositoryInstance = CARMARequestUtil.findRepositoryInstance(manager, repositoryInstanceID);
        }
        return this.carmaRepositoryInstance;
    }

    public void setCarmaRepositoryInstance(RepositoryInstance carmaRepositoryInstance) {
        this.carmaRepositoryInstance = carmaRepositoryInstance;
    }

    public CARMARepositoryManager getCarmaRepositoryManager() {
        return this.carmaRepositoryManager;
    }

    public void setCarmaRepositoryManager(CARMARepositoryManager carmaRepositoryManager) {
        this.carmaRepositoryManager = carmaRepositoryManager;
        this.carmaRepositoryInstance = null;
    }

    public CARMARepositoryConnection getCarmaConnection() {
        CARMARepositoryConnection connection = null;
        if (this.carmaRepositoryInstance != null) {
            connection = this.carmaRepositoryManager.getCarmaConnection();
        }
        return connection;
    }

    public String getName() {
        String name = "";
        if (this.carmaRepositoryInstance != null) {
            name = this.carmaRepositoryInstance.getName();
        }
        return name;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getStageName() {
        return this.stageName;
    }

    public void setStageName(String stageName) {
        this.stageName = stageName;
    }

    public String getStageId() {
        return this.stageId;
    }

    public void setStageId(String stageId) {
        this.stageId = stageId;
    }
}

