/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.carma.request.model;

import com.ibm.carma.model.CARMA;
import com.ibm.carma.model.RepositoryManager;
import com.ibm.carma.request.CARMAConnectionNotConnectedException;
import com.ibm.carma.request.model.CARMARepositoryManager;
import com.ibm.carma.transport.NotSynchronizedException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CARMARepositoryConnection {
    private static final Logger L = LoggerFactory.getLogger(CARMARepositoryConnection.class);
    private CARMA carmaConnection;

    public CARMARepositoryConnection() {
        this.carmaConnection = null;
    }

    public CARMARepositoryConnection(CARMA carmaConnection) {
        this.carmaConnection = carmaConnection;
    }

    public CARMA getCarmaConnection() {
        return this.carmaConnection;
    }

    public void setCarmaConnection(CARMA carmaConnection) {
        this.carmaConnection = carmaConnection;
    }

    public List<CARMARepositoryManager> getRepositoryManagers() {
        List<CARMARepositoryManager> repositoryManagers = this.getRepositoryManagers(null);
        return repositoryManagers;
    }

    public List<CARMARepositoryManager> getRepositoryManagers(String carmaRamId) {
        ArrayList<CARMARepositoryManager> repositoryManagers = new ArrayList<CARMARepositoryManager>();
        if (this.carmaConnection != null) {
            try {
                EList repoMgrs = this.carmaConnection.getRepositoryManagers();
                if (repoMgrs != null) {
                    for (RepositoryManager mgr : repoMgrs) {
                        if (carmaRamId != null && !mgr.getUniqueId().equals(carmaRamId)) continue;
                        CARMARepositoryManager currentRepositoryManager = new CARMARepositoryManager(this, mgr);
                        repositoryManagers.add(currentRepositoryManager);
                    }
                }
            }
            catch (NotSynchronizedException e) {
                L.error("Error: ", (Throwable)e);
            }
        }
        return repositoryManagers;
    }

    public String getIdentifier() {
        String identifier = "";
        if (this.carmaConnection != null) {
            identifier = this.carmaConnection.getIdentifier();
        }
        return identifier;
    }

    public String getRemoteCodepage() {
        String codePage = "";
        if (this.carmaConnection != null) {
            codePage = this.carmaConnection.getRemoteCodepage();
        }
        return codePage;
    }

    public boolean isConnected() {
        boolean connected = false;
        if (this.carmaConnection != null) {
            connected = this.carmaConnection.isConnected();
        }
        return connected;
    }

    public void connect(IProgressMonitor monitor) throws CARMAConnectionNotConnectedException {
        if (this.carmaConnection != null) {
            try {
                this.carmaConnection.connect(monitor);
            }
            catch (CoreException e) {
                throw new CARMAConnectionNotConnectedException(e);
            }
        }
    }
}

