/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.carma.request.job;

import com.ibm.carma.model.CARMAMember;
import com.ibm.carma.request.CARMARequestUtil;
import com.ibm.carma.request.job.CARMAExtractMemberJob;
import com.ibm.carma.request.model.CARMARepositoryResource;
import com.ibm.carma.ui.CarmaUIPlugin;
import com.ibm.carma.ui.job.OpenMemberJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public class CARMAOpenMemberJob
extends CARMAExtractMemberJob {
    private CARMAMember member;

    public CARMAOpenMemberJob(String name, CARMAMember member, IWorkbenchPage page) {
        super(name, member, page);
        this.member = member;
    }

    public CARMAOpenMemberJob(String name, CARMAMember member, IWorkbenchPage page, boolean forceReadOnly) {
        super(name, member, page, forceReadOnly);
        this.member = member;
    }

    public CARMAOpenMemberJob(String name, CARMARepositoryResource resource, IWorkbenchPage page, boolean forceReadOnly) {
        super(name, resource, page, forceReadOnly);
        this.member = (CARMAMember)resource.getResource();
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        String filterString;
        IStatus status = super.run(monitor);
        if (status == Status.OK_STATUS) {
            monitor.beginTask(CarmaUIPlugin.getResourceString((String)"openJob_taskName", (Object[])new Object[]{this.member.getName()}), 100);
            try {
                final OpenMemberJob.EditorOpener opener = this.createEditorOpener(this.input);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)opener);
                    }
                });
                status = opener.status;
            }
            finally {
                monitor.done();
            }
        }
        if (this.resource != null && (filterString = this.resource.getFilterString()) != null) {
            CARMARequestUtil.removeFilterView(this.resource, filterString);
            this.resource.setFilterString(null);
        }
        return status;
    }
}

