/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.carma.request.job;

import com.ibm.carma.model.CARMAMember;
import com.ibm.carma.request.CARMARequestMessages;
import com.ibm.carma.request.CARMARequestUtil;
import com.ibm.carma.request.job.CARMARequestRemoteEditEnabler;
import com.ibm.carma.request.model.CARMARepositoryResource;
import com.ibm.carma.ui.job.OpenMemberJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.ui.IWorkbenchPage;

public class CARMAExtractMemberJob
extends OpenMemberJob {
    protected CARMAMember member;
    protected CARMARepositoryResource resource = null;
    protected IFile input = null;

    public CARMAExtractMemberJob(String name, CARMAMember member, IWorkbenchPage page) {
        super(name, member, page);
        this.member = member;
    }

    public CARMAExtractMemberJob(String name, CARMAMember member, IWorkbenchPage page, boolean forceReadOnly) {
        super(name, member, page, forceReadOnly);
        this.member = member;
    }

    public CARMAExtractMemberJob(String name, CARMARepositoryResource resource, IWorkbenchPage page, boolean forceReadOnly) {
        super(name, (CARMAMember)resource.getResource(), page, forceReadOnly);
        this.member = (CARMAMember)resource.getResource();
        this.resource = resource;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(CARMARequestMessages.downloadJob_taskName) + " " + this.member.getName(), 100);
        try {
            CARMARequestRemoteEditEnabler enabler = new CARMARequestRemoteEditEnabler(this.member);
            enabler.forceReadOnly(this.forceReadOnly);
            try {
                this.input = enabler.getIFile((IProgressMonitor)new SubProgressMonitor(monitor, 75), true);
            }
            catch (CoreException ce) {
                String filterString = this.resource.getFilterString();
                if (filterString != null) {
                    CARMARequestUtil.removeFilterView(this.resource, filterString);
                    this.resource.setFilterString(null);
                }
                IStatus iStatus = ce.getStatus();
                if (this.resource != null) {
                    this.resource.notifyResourceContentsUpdated(this.input);
                }
                monitor.done();
                return iStatus;
            }
            SystemIFileProperties properties = new SystemIFileProperties((IResource)this.input);
            if (this.member.isBinary()) {
                properties.setLocalEncoding(this.member.getCARMA().getRemoteCodepage());
                properties.setEncoding(this.member.getCARMA().getRemoteCodepage());
            } else {
                properties.setLocalEncoding(this.member.getLocalCodepage());
                properties.setEncoding(this.member.getRemoteCodepage());
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            if (this.resource != null) {
                this.resource.notifyResourceContentsUpdated(this.input);
            }
            monitor.done();
        }
    }
}

