/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.carma.request.job;

import com.ibm.carma.DisabledCARMAOperationException;
import com.ibm.carma.IllegalCustomParameterException;
import com.ibm.carma.UnsupportedCARMAOperationException;
import com.ibm.carma.model.Action;
import com.ibm.carma.model.CARMAContent;
import com.ibm.carma.model.CARMAMember;
import com.ibm.carma.model.CARMAReturn;
import com.ibm.carma.model.CustomActionAccepter;
import com.ibm.carma.model.CustomParameter;
import com.ibm.carma.model.FileReturn;
import com.ibm.carma.model.Parameter;
import com.ibm.carma.model.RepositoryManager;
import com.ibm.carma.model.ReturnValue;
import com.ibm.carma.request.CARMARequestMessages;
import com.ibm.carma.transport.NotConnectedException;
import com.ibm.carma.transport.NotSynchronizedException;
import com.ibm.carma.ui.CarmaUIPlugin;
import com.ibm.carma.ui.action.custom.CustomActionUtil;
import com.ibm.carma.ui.dialog.NotSynchronizedDialog;
import com.ibm.carma.ui.internal.action.custom.CustomActionProcessorException;
import com.ibm.carma.ui.job.DownloadRemoteJob;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CARMADownloadRemoteJob
extends DownloadRemoteJob {
    private int totalTicksPerTask = 100;
    protected boolean forceReadOnly = true;

    public CARMADownloadRemoteJob(String name, IFile file, CARMAMember member, boolean keepHistory) {
        super(name, file, member, keepHistory);
    }

    protected Object[] getBlankParameters(CARMAMember member, Action action) {
        EList params = action.getParameters();
        Object[] result = new Object[params.size()];
        int i = 0;
        while (i < result.length) {
            Parameter parm = (Parameter)params.get(i);
            if (parm instanceof CustomParameter && ((CustomParameter)parm).isConstant()) {
                result[i] = ((CustomParameter)parm).getDefaultValue();
            } else {
                result[i] = "";
                if (parm.getParameterId().equals("084")) {
                    result[i] = "N";
                }
            }
            ++i;
        }
        return result;
    }

    protected Object[] getCustomParameters(CARMAMember member) throws OperationCanceledException, CoreException, NotSynchronizedException {
        Object[] customParameters = null;
        Action action = member.findActionFor(CARMADownloadRemoteJob.getActionId());
        if (action != null) {
            customParameters = this.getBlankParameters(member, action);
        }
        return customParameters;
    }

    /*
     * Unable to fully structure code
     */
    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(CARMARequestMessages.downloadJob_taskName, this.files.length * this.totalTicksPerTask);
        map = new HashMap<CARMAMember, FileReturn>();
        ticksLeft = 0;
        done = true;
        cMember = null;
        i = 0;
        while (i < this.files.length) {
            block18: {
                if (done) {
                    ticksLeft += this.totalTicksPerTask;
                    done = false;
                }
                monitor.subTask(this.files[i].getName());
                currentFile = this.files[i];
                try {
                    ticksLeft = 5 * ticksLeft / 8;
                    cMember = this.findCARMAMember(currentFile);
                    if (cMember == null) {
                        return new Status(4, "com.ibm.carma.ui", -1, CarmaUIPlugin.getResourceString((String)"resourceAdapter_notFound", (Object[])new Object[]{currentFile.getName()}), null);
                    }
                    parmMap = null;
                    rm = cMember.getRepositoryManager();
                    parms = this.getCustomParameters(cMember);
                    if (parms != null && parms.length > 0) {
                        parmMap = this.processCustomActionArray((CustomActionAccepter)cMember, (IProgressMonitor)new SubProgressMonitor(monitor, 3 * ticksLeft / 5), CARMADownloadRemoteJob.getActionId(), parms);
                    }
                    CustomActionUtil.preProcessAction((RepositoryManager)rm, (CustomActionAccepter)cMember, parmMap, (String)CARMADownloadRemoteJob.getActionId(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    returnContents = cMember.getMemberContents((IProgressMonitor)new SubProgressMonitor(monitor, 3 * ticksLeft / 5), parms);
                    ticksLeft = 2 * ticksLeft / 5;
                    status = this.setFileContents((IProgressMonitor)new SubProgressMonitor(monitor, 3 * ticksLeft / 2), currentFile, (InputStream)returnContents, cMember);
                    if (!status.isOK()) {
                        return status;
                    }
                    if (returnContents != null && returnContents.getReturnValues() != null && !returnContents.getReturnValues().isEmpty()) {
                        map.put(cMember, returnContents);
                    }
                    carmaReturn = null;
                    if (!map.isEmpty()) {
                        carmaReturn = map.values().toArray(new CARMAReturn[map.entrySet().size()])[0];
                    }
                    CustomActionUtil.postProcessAction((RepositoryManager)rm, (CustomActionAccepter)cMember, parmMap, (String)CARMADownloadRemoteJob.getActionId(), (CARMAReturn)carmaReturn, (IProgressMonitor)new SubProgressMonitor(monitor, 3 * ticksLeft / 5));
                    done = true;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                catch (NotConnectedException v0) {
                    if (!this.ensureConnected(cMember.getRepository().getRepositoryManager(), (IProgressMonitor)new SubProgressMonitor(monitor, ticksLeft /= 2))) {
                        return Status.CANCEL_STATUS;
                    }
                    --i;
                    break block18;
                }
                catch (UnsupportedCARMAOperationException e) {
                    this.handleUnsupportedCARMAOperationException(e, (CustomActionAccepter)cMember, CARMADownloadRemoteJob.getActionId());
                    return Status.OK_STATUS;
                }
                catch (NotSynchronizedException v1) {
                    resources = new Vector<IResource>();
                    j = i;
                    ** while (j < this.files.length)
                }
lbl-1000:
                // 1 sources

                {
                    obj = this.files[j];
                    if (obj instanceof IResource) {
                        resources.add((IResource)obj);
                    }
                    ++j;
                    continue;
                }
lbl59:
                // 1 sources

                nseStatus = new IStatus[]{Status.OK_STATUS};
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (NotSynchronizedDialog.openNotSynchronizedDialog((Shell)Display.getDefault().getActiveShell(), (Collection)resources) == 1) {
                            nseStatus[0] = Status.CANCEL_STATUS;
                        }
                    }
                });
                if (!nseStatus[0].isOK()) {
                    return Status.CANCEL_STATUS;
                }
                --i;
                break block18;
                catch (CustomActionProcessorException cae) {
                    status = new Status(4, "com.ibm.carma.ui", -1, null, (Throwable)cae);
                    return status;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
            }
            ++i;
        }
        this.displayCustomReturns((CARMAContent)cMember, (Map<? extends CARMAContent, ? extends CARMAReturn>)map);
        monitor.done();
        return Status.OK_STATUS;
    }

    public void displayCustomReturns(CARMAContent resource, Map<? extends CARMAContent, ? extends CARMAReturn> map) {
        if (map.size() > 0) {
            CARMAReturn ret = map.get(resource);
            ReturnValue returnCodeRV = null;
            int returnCode = 0;
            if (ret != null) {
                Object value;
                for (Object obj : ret.getReturnValues().keySet()) {
                    ReturnValue rv;
                    if (!(obj instanceof ReturnValue) || !"003".equals((rv = (ReturnValue)obj).getParameterId())) continue;
                    returnCodeRV = rv;
                }
                if (returnCodeRV != null && (value = ret.getReturnValues().get(returnCodeRV)) instanceof Integer) {
                    returnCode = (Integer)value;
                }
            }
            if (returnCode > 0) {
                Action action = CARMADownloadRemoteJob.getActionFromReturns((CARMAReturn)map.get(resource));
                this.displayCustomReturns(action.getActionId(), map);
            }
        }
    }

    public Map<String, ?> processCustomActionArray(CustomActionAccepter member, IProgressMonitor pm, String actionId, Object[] parameters) throws DisabledCARMAOperationException {
        pm.beginTask(CARMARequestMessages.task_parameters_process, 100);
        try {
            Action action = member.findActionFor(actionId);
            if (action != null) {
                if (action.isDisabled()) {
                    throw new DisabledCARMAOperationException(CARMARequestMessages.bind((String)CARMARequestMessages.error_acceptor_action_disabled, (Object[])new String[]{action.getName(), action.getActionId()}));
                }
                pm.worked(10);
                EList actionParams = action.getParameters();
                if (actionParams.size() == 0) {
                    if (parameters != null && parameters.length > 0) {
                        throw new IllegalArgumentException(CARMARequestMessages.bind((String)CARMARequestMessages.error_acceptor_parameters_extra, (Object[])new String[]{action.getName(), new Integer(parameters.length).toString()}));
                    }
                    HashMap hashMap = new HashMap();
                    return hashMap;
                }
                if (parameters == null) {
                    throw new IllegalArgumentException(CARMARequestMessages.bind((String)CARMARequestMessages.error_acceptor_parameters_required, (Object[])new String[]{"0", action.getName()}));
                }
                if (parameters.length != actionParams.size()) {
                    throw new IllegalArgumentException(CARMARequestMessages.bind((String)CARMARequestMessages.error_acceptor_parameters_count, (Object[])new Object[]{0, action.getName(), action.getActionId(), actionParams.size(), parameters.length}));
                }
                pm.worked(10);
                HashMap<String, Object> processed = new HashMap<String, Object>(actionParams.size());
                Iterator iter = actionParams.iterator();
                int i = 0;
                int tick = actionParams.size() > 0 ? 80 / actionParams.size() : 0;
                while (iter.hasNext()) {
                    Object value;
                    CustomParameter param = (CustomParameter)iter.next();
                    if ((value = parameters[i++]) == null) {
                        throw new IllegalCustomParameterException(param, CARMARequestMessages.error_acceptor_parameters_value_null);
                    }
                    if (param.isConstant() && !param.getDefaultValue().equals(value)) {
                        throw new IllegalCustomParameterException(param, CARMARequestMessages.bind((String)CARMARequestMessages.error_acceptor_parameters_value_constant, (Object[])new Object[]{value}));
                    }
                    if (!param.getType().checkVariableValue(value)) {
                        throw new IllegalCustomParameterException(param, CARMARequestMessages.bind((String)CARMARequestMessages.error_acceptor_parameters_value_conversion, (Object[])new Object[]{value, param.getType()}));
                    }
                    if (!param.getType().checkVariableLength(value, param.getLength())) {
                        throw new IllegalCustomParameterException(param, CARMARequestMessages.bind((String)CARMARequestMessages.error_acceptor_parameters_value_maximum, (Object[])new Object[]{value, new Integer(value.toString().length()).toString(), new Integer(param.getLength()).toString()}));
                    }
                    processed.put(param.getParameterId(), value);
                    pm.worked(tick);
                }
                HashMap<String, Object> hashMap = processed;
                return hashMap;
            }
        }
        catch (NotSynchronizedException notSynchronizedException) {
            throw new IllegalStateException(CARMARequestMessages.error_parameter_action_nse);
        }
        finally {
            pm.done();
        }
        return null;
    }
}

