/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.carma.request;

import com.ibm.carma.UnsupportedCARMAOperationException;
import com.ibm.carma.model.CARMA;
import com.ibm.carma.model.CARMAMember;
import com.ibm.carma.model.CARMAMemberVersion;
import com.ibm.carma.model.CARMAResource;
import com.ibm.carma.model.CustomActionAccepter;
import com.ibm.carma.model.Filterable;
import com.ibm.carma.model.RepositoryInstance;
import com.ibm.carma.model.RepositoryManager;
import com.ibm.carma.request.CARMAConnectionNotConnectedException;
import com.ibm.carma.request.CARMANotSynchronizedException;
import com.ibm.carma.request.CARMARequestException;
import com.ibm.carma.request.CARMARequestMessages;
import com.ibm.carma.request.CARMAUnsupportedOperationException;
import com.ibm.carma.request.job.CARMAExtractMemberJob;
import com.ibm.carma.request.job.CARMAGetVersionHistoryJob;
import com.ibm.carma.request.job.CARMAOpenMemberJob;
import com.ibm.carma.request.model.CARMARepositoryConnection;
import com.ibm.carma.request.model.CARMARepositoryInstance;
import com.ibm.carma.request.model.CARMARepositoryManager;
import com.ibm.carma.request.model.CARMARepositoryResource;
import com.ibm.carma.transport.NotConnectedException;
import com.ibm.carma.transport.NotSynchronizedException;
import com.ibm.carma.ui.CarmaRegistry;
import com.ibm.carma.ui.CarmaUIPlugin;
import com.ibm.carma.ui.action.custom.CustomActionUtil;
import com.ibm.carma.ui.job.RefreshJob;
import com.ibm.carma.ui.view.CarmaViewUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;

public class CARMARequestUtil {
    public static final String KEY_ENV = "ENV";
    public static final String KEY_SYS = "SYS";
    public static final String KEY_STGID = "STGID";
    public static final String KEY_SUBSYS = "SUBSYS";
    public static final String KEY_ELEM = "ELEM";
    public static final String KEY_TYPE = "TYPE";
    public static final String KEY_VERSION = "VERSION";
    public static final String KEY_LEVEL = "LEVEL";
    public static final String[] KEYS = new String[]{"ENV", "SYS", "STGID", "SUBSYS", "ELEM", "TYPE", "VERSION", "LEVEL"};
    public static final int LENGTH_ENV = 8;
    public static final int LENGTH_SYS = 8;
    public static final int LENGTH_STGNAME = 8;
    public static final int LENGTH_STGID = 1;
    public static final int LENGTH_SUBSYS = 8;
    public static final int LENGTH_ELEM = 10;
    public static final int LENGTH_TYPE = 8;
    public static final int LENGTH_VERSION = 2;
    public static final int LENGTH_LEVEL = 2;
    public static final String PAIR_DELIMITER = ",";
    public static final String KEYVAL_DELIMITER = ":";
    public static final String ENDEVOR_RETURN_CODE_RETURNVALUE_ID = "000";
    public static final String ENDEVOR_REASON_CODE_RETURNVALUE_ID = "001";
    public static final String ENDEVOR_ERROR_MESSAGE_RETURNVALUE_ID = "002";
    public static final String RETURN_CODE_RETURNVALUE_ID = "003";
    public static final String REASON_CODE_RETURNVALUE_ID = "004";
    public static final int DEFAULT_TICKS_PER_TASK = 1000;
    private static HashMap<String, Character> typeChars = new HashMap();

    public static List<CARMARepositoryConnection> getCarmaConnections() {
        CARMA[] carmas;
        ArrayList<CARMARepositoryConnection> connectionsList = new ArrayList<CARMARepositoryConnection>();
        CarmaRegistry registry = CarmaRegistry.getRegistry();
        CARMA[] cARMAArray = carmas = registry.getCarmas();
        int n = carmas.length;
        int n2 = 0;
        while (n2 < n) {
            CARMA carma = cARMAArray[n2];
            CARMARepositoryConnection carmaConnection = new CARMARepositoryConnection(carma);
            connectionsList.add(carmaConnection);
            ++n2;
        }
        return connectionsList;
    }

    public static CARMARepositoryConnection getCARMAConnection(String connectionName) {
        CARMARepositoryConnection carmaConnection = null;
        List<CARMARepositoryConnection> carmas = CARMARequestUtil.getCarmaConnections();
        Iterator<CARMARepositoryConnection> connectionIterator = carmas.iterator();
        while (carmaConnection == null & connectionIterator.hasNext()) {
            CARMARepositoryConnection carma = connectionIterator.next();
            if (!connectionName.equals(carma.getIdentifier())) continue;
            carmaConnection = carma;
        }
        return carmaConnection;
    }

    public static boolean hasEndevorSCMRam(CARMARepositoryConnection carmaConnection) {
        List<CARMARepositoryManager> repositoryManagers;
        boolean hasEndevor = false;
        if (carmaConnection != null && (repositoryManagers = carmaConnection.getRepositoryManagers("COM.IBM.CARMA.ENDEVORRAM")) != null && !repositoryManagers.isEmpty()) {
            hasEndevor = true;
        }
        return hasEndevor;
    }

    public static String getEnvironment(CARMARepositoryResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getEnvironment(resource.getMemberId());
        }
        return value;
    }

    public static String getSystem(CARMARepositoryResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getSystem(resource.getMemberId());
        }
        return value;
    }

    public static String getSubSystem(CARMARepositoryResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getSubSystem(resource.getMemberId());
        }
        return value;
    }

    public static boolean isType(CARMARepositoryResource resource) {
        boolean isTypeMemberId = false;
        if (resource != null) {
            isTypeMemberId = CARMARequestUtil.isType(resource.getMemberId(), CARMARequestUtil.getTypeIdentifyingChar(resource.getCarmaConnection()));
        }
        return isTypeMemberId;
    }

    public static String getType(CARMARepositoryResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getType(resource.getMemberId(), CARMARequestUtil.getTypeIdentifyingChar(resource.getCarmaConnection()));
        }
        return value;
    }

    public static String getStageName(CARMARepositoryResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getStageName(resource.getMemberId());
        }
        return value;
    }

    public static String getStageId(CARMARepositoryResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getStageId(resource.getMemberId());
        }
        return value;
    }

    public static String getElementName(CARMARepositoryResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getElementName(resource.getMemberId());
        }
        return value;
    }

    public static String getEnvironment(CARMAResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getEnvironment(resource.getMemberId());
        }
        return value;
    }

    public static String getSystem(CARMAResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getSystem(resource.getMemberId());
        }
        return value;
    }

    public static String getSubSystem(CARMAResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getSubSystem(resource.getMemberId());
        }
        return value;
    }

    public static boolean isType(CARMAResource resource) {
        boolean isTypeContainer = false;
        if (resource != null) {
            isTypeContainer = CARMARequestUtil.isType(resource.getMemberId(), CARMARequestUtil.getTypeIdentifyingChar(resource.getCARMA()));
        }
        return isTypeContainer;
    }

    public static String getType(CARMAResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getType(resource.getMemberId(), CARMARequestUtil.getTypeIdentifyingChar(resource.getCARMA()));
        }
        return value;
    }

    public static String getStageName(CARMAResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getStageName(resource.getMemberId());
        }
        return value;
    }

    public static String getStageId(CARMAResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getStageId(resource.getMemberId());
        }
        return value;
    }

    public static String getElementName(CARMAResource resource) {
        String value = null;
        if (resource != null) {
            value = CARMARequestUtil.getElementName(resource.getMemberId());
        }
        return value;
    }

    public static String getEnvironment(String memberId) {
        String value = null;
        if (memberId != null && memberId.length() > 0) {
            value = memberId.substring(0, memberId.length() >= 8 ? 8 : memberId.length());
        }
        return value == null ? null : value.trim();
    }

    public static String getSystem(String memberId) {
        String value = null;
        if (memberId.length() > 9) {
            value = memberId.substring(9, memberId.length() >= 17 ? 17 : memberId.length());
        }
        return value == null ? null : value.trim();
    }

    public static String getSubSystem(String memberId) {
        String value = null;
        if (memberId.length() > 26 && memberId.charAt(8) != ' ') {
            value = memberId.substring(26, memberId.length() >= 34 ? 34 : memberId.length());
        }
        return value == null ? null : value.trim();
    }

    public static boolean isType(String memberId, char typeIdentifier) {
        boolean isTypeMemberId = false;
        if (memberId.length() > 52 && memberId.charAt(8) == typeIdentifier) {
            isTypeMemberId = true;
        }
        return isTypeMemberId;
    }

    public static String getType(String memberId, char typeIdentifier) {
        String value = null;
        if (memberId.length() > 52 && (memberId.charAt(8) == '_' || memberId.charAt(8) == typeIdentifier)) {
            value = memberId.substring(52, memberId.length() >= 60 ? 60 : memberId.length());
        }
        return value == null ? null : value.trim();
    }

    public static String getStageName(String memberId) {
        String value = null;
        if (memberId.length() > 17) {
            value = memberId.substring(17, memberId.length() >= 25 ? 25 : memberId.length());
        }
        return value == null ? null : value.trim();
    }

    public static String getStageId(String memberId) {
        String value = null;
        if (memberId.length() > 25) {
            value = memberId.substring(25, 26);
        }
        return value;
    }

    public static String getElementName(String memberId) {
        String value = null;
        if (memberId.length() > 34 && memberId.charAt(8) == '_') {
            value = memberId.substring(34, memberId.length() >= 44 ? 44 : memberId.length());
        }
        return value == null ? null : value.trim();
    }

    public static String getElementVersion(String memberId) {
        String value = null;
        if (memberId.length() > 71 && memberId.charAt(8) == '_' && memberId.length() > 71) {
            value = memberId.substring(71, memberId.length() >= 73 ? 73 : memberId.length());
        }
        return value == null ? null : value.trim();
    }

    public static String getElementLevel(String memberId) {
        String value = null;
        if (memberId.length() > 73 && memberId.charAt(8) == '_' && memberId.length() > 73) {
            value = memberId.substring(73, memberId.length() >= 75 ? 75 : memberId.length());
        }
        return value == null ? null : value.trim();
    }

    public static char getTypeIdentifyingChar(CARMA carma) {
        String remoteCodepage = carma.getRemoteCodepage();
        Character retChar = typeChars.get(remoteCodepage);
        if (retChar == null) {
            retChar = Character.valueOf('#');
            String converted = null;
            try {
                converted = new String(new byte[]{123}, "IBM" + remoteCodepage);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    converted = new String(new byte[]{123}, remoteCodepage);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {}
            }
            if (converted != null && converted.length() == 1) {
                typeChars.put(remoteCodepage, Character.valueOf(converted.charAt(0)));
                retChar = Character.valueOf(converted.charAt(0));
            }
        }
        return retChar.charValue();
    }

    public static char getTypeIdentifyingChar(CARMARepositoryConnection carmaConnection) {
        String remoteCodepage = carmaConnection.getRemoteCodepage();
        Character retChar = typeChars.get(remoteCodepage);
        if (retChar == null) {
            retChar = Character.valueOf('#');
            String converted = null;
            try {
                converted = new String(new byte[]{123}, "IBM" + remoteCodepage);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    converted = new String(new byte[]{123}, remoteCodepage);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {}
            }
            if (converted != null && converted.length() == 1) {
                typeChars.put(remoteCodepage, Character.valueOf(converted.charAt(0)));
                retChar = Character.valueOf(converted.charAt(0));
            }
        }
        return retChar.charValue();
    }

    public static String getMemberID(String environmentName, String systemName, String subSystemName, String stageName, String stageId, String typeName, String elementName) {
        StringBuffer buf = new StringBuffer();
        CARMARequestUtil.appendField(buf, environmentName, 8);
        CARMARequestUtil.appendField(buf, "_", 1);
        CARMARequestUtil.appendField(buf, systemName, 8);
        CARMARequestUtil.appendField(buf, stageName, 8);
        CARMARequestUtil.appendField(buf, stageId, 1);
        CARMARequestUtil.appendField(buf, subSystemName, 8);
        CARMARequestUtil.appendField(buf, elementName, 10);
        CARMARequestUtil.appendField(buf, "", 8);
        CARMARequestUtil.appendField(buf, typeName, 8);
        return buf.toString().trim();
    }

    public static String getMemberID(String environmentName, String systemName, String subSystemName, String stageName, String stageId, String typeName, String elementName, String elementVersion, String elementLevel) {
        StringBuffer buf = new StringBuffer();
        CARMARequestUtil.appendField(buf, environmentName, 8);
        CARMARequestUtil.appendField(buf, "_", 1);
        CARMARequestUtil.appendField(buf, systemName, 8);
        CARMARequestUtil.appendField(buf, stageName, 8);
        CARMARequestUtil.appendField(buf, stageId, 1);
        CARMARequestUtil.appendField(buf, subSystemName, 8);
        CARMARequestUtil.appendField(buf, elementName, 10);
        CARMARequestUtil.appendField(buf, "", 8);
        CARMARequestUtil.appendField(buf, typeName, 8);
        CARMARequestUtil.appendField(buf, "", 10);
        CARMARequestUtil.appendField(buf, "", 1);
        CARMARequestUtil.appendField(buf, elementVersion, 2);
        CARMARequestUtil.appendField(buf, elementLevel, 2);
        return buf.toString().trim();
    }

    public static String getTypeMemberID(CARMARepositoryConnection carmaConnection, String environmentName, String systemName, String subSystemName, String stageName, String stageId, String typeName) {
        StringBuffer buf = new StringBuffer();
        CARMARequestUtil.appendField(buf, environmentName, 8);
        buf.append(CARMARequestUtil.getTypeIdentifyingChar(carmaConnection));
        CARMARequestUtil.appendField(buf, systemName, 8);
        CARMARequestUtil.appendField(buf, stageName, 8);
        CARMARequestUtil.appendField(buf, stageId, 1);
        CARMARequestUtil.appendField(buf, subSystemName, 8);
        CARMARequestUtil.appendField(buf, "*", 10);
        CARMARequestUtil.appendField(buf, "", 8);
        CARMARequestUtil.appendField(buf, typeName, 8);
        return buf.toString().trim();
    }

    public static String getRepositoryInstanceID(String environmentName, String systemName, String stageName, String stageId) {
        StringBuffer buf = new StringBuffer();
        CARMARequestUtil.appendField(buf, environmentName, 8);
        CARMARequestUtil.appendField(buf, " ", 1);
        CARMARequestUtil.appendField(buf, systemName, 8);
        CARMARequestUtil.appendField(buf, stageName, 8);
        CARMARequestUtil.appendField(buf, stageId, 1);
        CARMARequestUtil.appendField(buf, "*", 8);
        CARMARequestUtil.appendField(buf, "*", 10);
        CARMARequestUtil.appendField(buf, "*", 1);
        return buf.toString();
    }

    private static void appendField(StringBuffer buf, String argument, int bytes) {
        buf.append(argument);
        int i = bytes;
        while (i > argument.length()) {
            buf.append(' ');
            --i;
        }
    }

    public static String getFilterString(String environmentName, String systemName, String subSystemName, String stageId, String typeName, String elementName) {
        StringBuffer filter = new StringBuffer();
        if (environmentName != null && environmentName.trim().length() > 0 && !environmentName.equals("*")) {
            filter.append(KEY_ENV);
            filter.append(KEYVAL_DELIMITER);
            filter.append(environmentName.trim());
        }
        if (systemName != null && systemName.trim().length() > 0 && !systemName.equals("*")) {
            if (filter.length() > 0) {
                filter.append(PAIR_DELIMITER);
            }
            filter.append(KEY_SYS);
            filter.append(KEYVAL_DELIMITER);
            filter.append(systemName.trim());
        }
        if (subSystemName != null && subSystemName.trim().length() > 0 && !subSystemName.equals("*")) {
            if (filter.length() > 0) {
                filter.append(PAIR_DELIMITER);
            }
            filter.append(KEY_SUBSYS);
            filter.append(KEYVAL_DELIMITER);
            filter.append(subSystemName.trim());
        }
        if (stageId != null && stageId.trim().length() > 0 && !stageId.equals("*")) {
            if (filter.length() > 0) {
                filter.append(PAIR_DELIMITER);
            }
            filter.append(KEY_STGID);
            filter.append(KEYVAL_DELIMITER);
            filter.append(stageId.trim());
        }
        if (typeName != null && typeName.trim().length() > 0 && !typeName.equals("*")) {
            if (filter.length() > 0) {
                filter.append(PAIR_DELIMITER);
            }
            filter.append(KEY_TYPE);
            filter.append(KEYVAL_DELIMITER);
            filter.append(typeName.trim());
        }
        if (elementName != null && elementName.trim().length() > 0 && !elementName.equals("*")) {
            if (filter.length() > 0) {
                filter.append(PAIR_DELIMITER);
            }
            filter.append(KEY_ELEM);
            filter.append(KEYVAL_DELIMITER);
            filter.append(elementName.trim());
        }
        return filter.toString();
    }

    public static void addFilterView(Filterable filterable, String filter) throws InterruptedException {
        CarmaViewUtils.addView((Filterable)filterable, (String)filter);
        RefreshJob job = new RefreshJob("", new Object[]{filterable}, filter);
        job.schedule();
        job.join();
    }

    public static void removeFilterView(Filterable filterable, String filter) {
        if (filterable != null) {
            filterable.removeFilter(filter);
        }
    }

    public static void removeFilterView(CARMARepositoryResource resource, String filter) {
        RepositoryManager carmaRepositoryManager;
        CARMARepositoryManager manager;
        CARMARepositoryInstance repositoryInstance;
        if (resource != null && filter != null && (repositoryInstance = resource.getRepositoryInstance()) != null && (manager = repositoryInstance.getCarmaRepositoryManager()) != null && (carmaRepositoryManager = manager.getCarmaRepositoryManager()) != null) {
            CARMARequestUtil.removeFilterView((Filterable)carmaRepositoryManager, filter);
        }
    }

    public static CARMAMember memberSearchHelper(CARMAMember cResource, String repositoryID, String subSystem, String type, String element, IProgressMonitor monitor) throws InterruptedException, IllegalStateException, CoreException, CARMARequestException {
        return CARMARequestUtil.memberSearchHelper(cResource.getRepositoryManager(), repositoryID, subSystem, type, element, monitor);
    }

    /*
     * Exception decompiling
     */
    public static CARMAMember memberSearchHelper(RepositoryManager repositoryManager, String repositoryID, String subSystem, String type, String element, IProgressMonitor monitor) throws InterruptedException, CoreException, CARMANotSynchronizedException, CARMAConnectionNotConnectedException, CARMAUnsupportedOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static RepositoryInstance findRepositoryInstance(RepositoryManager repositoryManager, String repositoryID) throws CoreException, OperationCanceledException, CARMAUnsupportedOperationException, CARMAConnectionNotConnectedException, CARMANotSynchronizedException {
        RepositoryInstance instance;
        block7: {
            instance = null;
            try {
                if (repositoryManager == null || repositoryID == null) break block7;
                String environmentName = CARMARequestUtil.getEnvironment(repositoryID);
                String systemName = CARMARequestUtil.getSystem(repositoryID);
                String stageId = CARMARequestUtil.getStageId(repositoryID);
                if (!repositoryManager.isConnected()) {
                    CARMA carmaConnection = repositoryManager.getCARMA();
                    if (!carmaConnection.isConnected()) {
                        carmaConnection.connect((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)new NullProgressMonitor(), 0));
                    }
                    repositoryManager.refresh((IProgressMonitor)new NullProgressMonitor(), 0, false, new Object[0]);
                    repositoryManager.connect((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)new NullProgressMonitor(), 0), CustomActionUtil.getCustomParameters((CustomActionAccepter)repositoryManager, (String)"carma.ram.connect"));
                }
                EList repositoryInstances = repositoryManager.getRepositoryInstances();
                for (Object riO : repositoryInstances) {
                    if (!(riO instanceof RepositoryInstance)) continue;
                    String currentRepositoryID = ((RepositoryInstance)riO).getMemberId();
                    String currentEnvironmentName = CARMARequestUtil.getEnvironment(currentRepositoryID);
                    String currentSystemName = CARMARequestUtil.getSystem(currentRepositoryID);
                    String currentStageId = CARMARequestUtil.getStageId(currentRepositoryID);
                    if (!environmentName.equals(currentEnvironmentName) || !systemName.equals(currentSystemName) || !stageId.equals(currentStageId)) continue;
                    instance = (RepositoryInstance)riO;
                    break;
                }
            }
            catch (UnsupportedCARMAOperationException e) {
                throw new CARMAUnsupportedOperationException(e);
            }
            catch (NotConnectedException e) {
                throw new CARMAConnectionNotConnectedException(e);
            }
            catch (NotSynchronizedException e) {
                throw new CARMANotSynchronizedException(e);
            }
        }
        return instance;
    }

    public static boolean isEmptyValue(String value) {
        boolean emptyValue = false;
        if (value == null || value.trim().length() == 0 || value.contains("*")) {
            emptyValue = true;
        }
        return emptyValue;
    }

    public static boolean areValidElementParameters(String environmentName, String systemName, String subSystemName, String stageName, String stageId, String typeName, String elementName) {
        boolean valid = true;
        if (CARMARequestUtil.isEmptyValue(environmentName) || CARMARequestUtil.isEmptyValue(systemName) || CARMARequestUtil.isEmptyValue(subSystemName) || CARMARequestUtil.isEmptyValue(stageName) && CARMARequestUtil.isEmptyValue(stageId) || CARMARequestUtil.isEmptyValue(typeName) || CARMARequestUtil.isEmptyValue(elementName)) {
            valid = false;
        }
        return valid;
    }

    public static List<CARMAResource> locateCARMAResourcesUsingFilter(CARMARepositoryManager carmaRepositoryManager, String filterString, String environmentName, String systemName, String subSystemName, String stageName, String stageId, String typeName, String elementName) throws InterruptedException, CoreException, OperationCanceledException, CARMANotSynchronizedException, CARMAConnectionNotConnectedException, CARMAUnsupportedOperationException {
        ArrayList<CARMAResource> resourceList = new ArrayList<CARMAResource>();
        EList filters = null;
        if (carmaRepositoryManager != null && CARMARequestUtil.areValidElementParameters(environmentName, systemName, subSystemName, stageName, stageId, typeName, elementName)) {
            try {
                CARMAMember member;
                Object resource;
                RepositoryManager repositoryManager = carmaRepositoryManager.getCarmaRepositoryManager();
                CARMARequestUtil.addFilterView((Filterable)repositoryManager, filterString);
                if (!repositoryManager.isConnected()) {
                    CARMA carmaConnection = repositoryManager.getCARMA();
                    if (!carmaConnection.isConnected()) {
                        carmaConnection.connect((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)new NullProgressMonitor(), 0));
                    }
                    repositoryManager.connect((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)new NullProgressMonitor(), 0), CustomActionUtil.getCustomParameters((CustomActionAccepter)repositoryManager, (String)"carma.ram.connect"));
                }
                if (!repositoryManager.isFilterReady(filterString)) {
                    repositoryManager.refresh((IProgressMonitor)new NullProgressMonitor(), filterString, 0, false, new Object[0]);
                }
                if ((filters = repositoryManager.resolveFilter(filterString)) != null && filters.size() > 0 && (resource = filters.get(0)) instanceof RepositoryInstance && (member = CARMARequestUtil.memberSearchHelper(((RepositoryInstance)resource).getRepositoryManager(), ((RepositoryInstance)resource).getMemberId(), subSystemName, typeName, elementName, (IProgressMonitor)new NullProgressMonitor())) != null) {
                    resourceList.add((CARMAResource)member);
                }
            }
            catch (NotSynchronizedException e) {
                throw new CARMANotSynchronizedException(e);
            }
            catch (NotConnectedException e) {
                throw new CARMAConnectionNotConnectedException(e);
            }
            catch (UnsupportedCARMAOperationException e) {
                throw new CARMAUnsupportedOperationException(e);
            }
        }
        return resourceList;
    }

    public static CARMARepositoryResource createCARMAMemberInstance(CARMARepositoryResource existingResource, String newMemberId, String newName) throws InterruptedException, CARMANotSynchronizedException {
        CARMAMember existingMember;
        CARMARepositoryResource carmaResource = null;
        if (existingResource != null && newMemberId != null && (existingMember = (CARMAMember)existingResource.getResource()) != null) {
            String environmentName = CARMARequestUtil.getEnvironment(newMemberId);
            String systemName = CARMARequestUtil.getSystem(newMemberId);
            String subSystemName = CARMARequestUtil.getSubSystem(newMemberId);
            String stageId = CARMARequestUtil.getStageId(newMemberId);
            String typeName = CARMARequestUtil.getType(newMemberId, CARMARequestUtil.getTypeIdentifyingChar(existingResource.getCarmaConnection()));
            String elementName = CARMARequestUtil.getElementName(newMemberId);
            String version = CARMARequestUtil.getElementVersion(newMemberId);
            String level = CARMARequestUtil.getElementLevel(newMemberId);
            String currentVersion = null;
            String currentLevel = null;
            String memberVersionMemberId = null;
            if (version != null && version.trim().length() > 0) {
                CARMAGetVersionHistoryJob job = new CARMAGetVersionHistoryJob(CARMARequestMessages.refreshHistoryJob_jobName, new CARMAMember[]{existingMember});
                job.setUser(true);
                job.schedule();
                job.join();
                try {
                    EList versionList = existingMember.getVersionHistory();
                    if (versionList != null) {
                        for (CARMAMemberVersion currentMemberVersion : versionList) {
                            memberVersionMemberId = currentMemberVersion.getMemberId();
                            String currentEnvironmentName = CARMARequestUtil.getEnvironment(memberVersionMemberId);
                            String currentSystemName = CARMARequestUtil.getSystem(memberVersionMemberId);
                            String currentSubSystemName = CARMARequestUtil.getSubSystem(memberVersionMemberId);
                            String currentStageId = CARMARequestUtil.getStageId(memberVersionMemberId);
                            String currentTypeName = CARMARequestUtil.getType(memberVersionMemberId, CARMARequestUtil.getTypeIdentifyingChar(existingResource.getCarmaConnection()));
                            String currentElementName = CARMARequestUtil.getElementName(memberVersionMemberId);
                            currentVersion = CARMARequestUtil.getElementVersion(memberVersionMemberId);
                            currentLevel = CARMARequestUtil.getElementLevel(memberVersionMemberId);
                            if (!environmentName.equals(currentEnvironmentName) || !systemName.equals(currentSystemName) || !subSystemName.equals(currentSubSystemName) || !stageId.equals(currentStageId) || !typeName.equals(currentTypeName) || !elementName.equals(currentElementName) || !version.equals(currentVersion) || level != null && level.trim().length() != 0 && !level.equals(currentLevel)) continue;
                            carmaResource = new CARMARepositoryResource(existingResource.getRepositoryInstance(), (CARMAResource)currentMemberVersion, existingResource.getFilterString(), existingResource.isReadOnly());
                        }
                    }
                }
                catch (NotSynchronizedException e) {
                    throw new CARMANotSynchronizedException(e);
                }
            }
        }
        return carmaResource;
    }

    public static CARMARepositoryResource createCARMAMemberInstance(CARMARepositoryManager repositoryManager, String environmentName, String systemName, String subSystemName, String stageName, String stageId, String typeName, String elementName) throws OperationCanceledException, InterruptedException, CoreException, CARMANotSynchronizedException, CARMAConnectionNotConnectedException, CARMAUnsupportedOperationException {
        CARMARepositoryResource carmaResource = null;
        List<CARMAResource> resourceList = null;
        CARMAMember member = null;
        if (repositoryManager != null) {
            CARMAResource resource;
            String filterString = CARMARequestUtil.getFilterString(environmentName, systemName, subSystemName, stageId, typeName, elementName);
            resourceList = CARMARequestUtil.locateCARMAResourcesUsingFilter(repositoryManager, filterString, environmentName, systemName, subSystemName, stageName, stageId, typeName, elementName);
            if (resourceList != null && resourceList.size() > 0 && (resource = resourceList.get(0)) instanceof CARMAMember) {
                member = (CARMAMember)resource;
            }
            if (member != null) {
                CARMARepositoryInstance repositoryInstance = new CARMARepositoryInstance(repositoryManager, environmentName, systemName, stageName, stageId);
                repositoryInstance.setCarmaRepositoryInstance(member.getRepository());
                carmaResource = new CARMARepositoryResource(repositoryInstance, (CARMAResource)member, filterString, true);
            } else if (filterString != null) {
                CARMARequestUtil.removeFilterView((Filterable)repositoryManager.getCarmaRepositoryManager(), filterString);
            }
        }
        return carmaResource;
    }

    public static CARMARepositoryResource createCARMAMemberInstance(CARMARepositoryConnection carmaConnection, String environmentName, String systemName, String subSystemName, String stageName, String stageId, String typeName, String elementName) throws CoreException, InterruptedException, OperationCanceledException, CARMANotSynchronizedException, CARMAConnectionNotConnectedException, CARMAUnsupportedOperationException {
        CARMARepositoryManager repositoryManager;
        List<CARMARepositoryManager> repositoryManagers;
        Iterator<CARMARepositoryManager> repositoryManagersIterator;
        CARMARepositoryResource carmaResource = null;
        if (!carmaConnection.isConnected()) {
            carmaConnection.connect((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)new NullProgressMonitor(), 0));
        }
        RefreshJob job = new RefreshJob(CarmaUIPlugin.getResourceString((String)"refresh_job", (Object[])new Object[]{carmaConnection.getIdentifier()}), new Object[]{carmaConnection}, true);
        job.schedule();
        job.join();
        if (job.getResult().getCode() != 8 && (repositoryManagersIterator = (repositoryManagers = carmaConnection.getRepositoryManagers("COM.IBM.CARMA.ENDEVORRAM")).iterator()).hasNext() && (repositoryManager = repositoryManagersIterator.next()) != null) {
            carmaResource = CARMARequestUtil.createCARMAMemberInstance(repositoryManager, environmentName, systemName, subSystemName, stageName, stageId, typeName, elementName);
        }
        return carmaResource;
    }

    public static CARMARepositoryResource createCARMAMemberInstance(CARMARepositoryConnection carmaConnection, String environmentName, String systemName, String subSystemName, String stageId, String typeName, String elementName) throws CoreException, InterruptedException, OperationCanceledException, CARMANotSynchronizedException, CARMAConnectionNotConnectedException, CARMAUnsupportedOperationException {
        CARMARepositoryResource carmaResource = CARMARequestUtil.createCARMAMemberInstance(carmaConnection, environmentName, systemName, subSystemName, "", stageId, typeName, elementName);
        return carmaResource;
    }

    public static CARMARepositoryResource createCARMAMemberInstance(CARMARepositoryConnection carmaConnection, String environmentName, String systemName, String subSystemName, String stageId, String typeName, String elementName, String elementVersion, String elementLevel) throws CoreException, InterruptedException, OperationCanceledException, CARMANotSynchronizedException, CARMAConnectionNotConnectedException, CARMAUnsupportedOperationException {
        CARMARepositoryResource carmaResource = CARMARequestUtil.createCARMAMemberInstance(carmaConnection, environmentName, systemName, subSystemName, "", stageId, typeName, elementName);
        if (carmaResource != null && elementVersion != null && elementVersion.trim().length() > 0) {
            String newMemberID = CARMARequestUtil.getMemberID(environmentName, systemName, subSystemName, "", stageId, typeName, elementName, elementVersion, elementLevel);
            StringBuffer newName = new StringBuffer();
            CARMARequestUtil.appendField(newName, carmaResource.getName(), 10);
            CARMARequestUtil.appendField(newName, ".", 1);
            CARMARequestUtil.appendField(newName, elementVersion, 2);
            CARMARequestUtil.appendField(newName, ".", 1);
            CARMARequestUtil.appendField(newName, elementLevel, 2);
            String newMemberName = newName.toString();
            CARMARepositoryResource newCarmaResource = CARMARequestUtil.createCARMAMemberInstance(carmaResource, newMemberID, newMemberName);
            carmaResource = newCarmaResource != null ? newCarmaResource : null;
        }
        return carmaResource;
    }

    public static void openCARMAResourceInEditor(final CARMARepositoryResource resource, final boolean readOnly) {
        if (resource != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbench workbench = CarmaUIPlugin.getDefault().getWorkbench();
                    IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                    CARMAOpenMemberJob openJob = new CARMAOpenMemberJob(CarmaUIPlugin.getResourceString((String)"openJob_jobName", (Object[])new Object[]{resource.getName()}), resource, page, readOnly);
                    openJob.setUser(true);
                    openJob.schedule();
                }
            });
        }
    }

    public static void extractCARMAResourceContents(CARMARepositoryResource resource, boolean readOnly) {
        if (resource != null) {
            CARMAExtractMemberJob openJob = new CARMAExtractMemberJob(CarmaUIPlugin.getResourceString((String)"openJob_jobName", (Object[])new Object[]{resource.getName()}), resource, null, readOnly);
            openJob.setUser(true);
            openJob.schedule();
        }
    }
}

