/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.preferences.service;

import com.ez.eclient.preferences.ExtensionLoader;
import com.ez.eclient.preferences.LogUtil;
import com.ez.eclient.preferences.ServerPreferences;
import com.ez.eclient.preferences.ServerScope;
import com.ez.eclient.preferences.service.DynamicPreferencesService;
import com.ez.eclient.preferences.service.internal.Messages;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferenceFilter;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesService
implements DynamicPreferencesService {
    private static Logger L = LoggerFactory.getLogger(PreferencesService.class);
    public static final String SPECIAL_PROP_OVERWRITE = "ez.meta.overwrite";
    public static final boolean SPECIAL_PROP_OVERWRITE_DEFAULT = false;
    public static final String SPECIAL_PROP_ALLOW_OVERWRITE = "ez.meta.allow_overwrite";
    public static final boolean SPECIAL_PROP_ALLOW_OVERWRITE_DEFAULT = true;
    private final Map<String, ListenerList> PREF_LISTENERS = new HashMap<String, ListenerList>(){
        {
            this.put("instance", new ListenerList());
            this.put("configuration", new ListenerList());
            this.put("configurationServer", new ListenerList());
            this.put("default", new ListenerList());
        }
    };
    public static String[] DEFAULT_LOOKUP_ORDER = new String[]{"instance", "configuration", "configurationServer", "default"};
    public static String[] DEFAULT_SERVER_LOOKUP_ORDER = new String[]{"configurationServer", "configuration", "default"};
    private static final char KEY_SEGMENT_SEP = '.';
    private static volatile PreferencesService INSTANCE = null;
    private static final Map DEFAULTS_REGISTRY = Collections.synchronizedMap(new HashMap());
    private IPreferencesService impl;
    private final Set serverConfigGroups = Collections.synchronizedSet(new HashSet());
    private IEclipsePreferences.IPreferenceChangeListener INSTANCE_LISTENER = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            PreferencesService.this.instancePreferenceChange(event);
        }
    };
    private IEclipsePreferences.IPreferenceChangeListener SERVER_LISTENER = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            PreferencesService.this.serverPreferenceChange(event);
        }
    };

    protected void setPreferencesService(IPreferencesService impl) {
        if (impl == null) {
            throw new IllegalArgumentException("impl is null");
        }
        this.impl = impl;
    }

    protected void unsetPreferencesService(IPreferencesService impl) {
        if (this.impl != null && this.impl != impl) {
            throw new IllegalArgumentException("Invalid impl argument.");
        }
        this.impl = null;
    }

    protected void activate(ComponentContext ctx) {
        INSTANCE = this;
        ExtensionLoader.getInstance().ensurePostConfigure(this);
        this.hookListeners();
    }

    protected void deactivate(ComponentContext ctx) {
        INSTANCE = null;
    }

    public static PreferencesService getDefault() {
        return INSTANCE;
    }

    public PreferencesService() {
    }

    public PreferencesService(IPreferencesService impl) {
        if (impl == null) {
            throw new IllegalArgumentException("impl is null");
        }
        this.impl = impl;
        ExtensionLoader.getInstance().ensurePostConfigure(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPreferenceChangeListener(String scope, IEclipsePreferences.IPreferenceChangeListener listener) {
        Map<String, ListenerList> map = this.PREF_LISTENERS;
        synchronized (map) {
            ListenerList l = this.PREF_LISTENERS.get(scope);
            if (l == null) {
                l = new ListenerList();
                this.PREF_LISTENERS.put(scope, l);
            }
            l.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePreferenceChangeListener(String scope, IEclipsePreferences.IPreferenceChangeListener listener) {
        Map<String, ListenerList> map = this.PREF_LISTENERS;
        synchronized (map) {
            ListenerList l = this.PREF_LISTENERS.get(scope);
            if (l != null) {
                l.remove((Object)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerServerConfigGroup(String uniqueId) {
        Set set = this.serverConfigGroups;
        synchronized (set) {
            if (!this.serverConfigGroups.add(uniqueId)) {
                throw new IllegalArgumentException("Group already registered: " + uniqueId);
            }
        }
    }

    public String get(String key, String defaultValue, Preferences[] nodes) {
        if (nodes == null) {
            return defaultValue;
        }
        int i = 0;
        while (i < nodes.length) {
            String result;
            Preferences node = nodes[i];
            if (node != null && (result = node.get(key, null)) != null) {
                return result;
            }
            ++i;
        }
        return defaultValue;
    }

    public boolean getBoolean(String qualifier, String key, boolean defaultValue, IScopeContext[] scopes) {
        String result = this.get(ServerPreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, scopes));
        return result == null ? defaultValue : Boolean.valueOf(result);
    }

    public byte[] getByteArray(String qualifier, String key, byte[] defaultValue, IScopeContext[] contexts) {
        throw new RuntimeException("Not implemented.");
    }

    public double getDouble(String qualifier, String key, double defaultValue, IScopeContext[] contexts) {
        throw new RuntimeException("Not implemented.");
    }

    public float getFloat(String qualifier, String key, float defaultValue, IScopeContext[] contexts) {
        throw new RuntimeException("Not implemented.");
    }

    public int getInt(String qualifier, String key, int defaultValue, IScopeContext[] contexts) {
        throw new RuntimeException("Not implemented.");
    }

    public long getLong(String qualifier, String key, long defaultValue, IScopeContext[] contexts) {
        String result = this.get(ServerPreferences.decodePath(key)[1], null, this.getNodes(qualifier, key, contexts));
        return result == null ? defaultValue : Long.valueOf(result);
    }

    public String getString(String qualifier, String key, String defaultValue, IScopeContext[] scopes) {
        return this.get(ServerPreferences.decodePath(key)[1], defaultValue, this.getNodes(qualifier, key, scopes));
    }

    public IEclipsePreferences getRootNode() {
        return this.impl.getRootNode();
    }

    public IStatus exportPreferences(IEclipsePreferences node, OutputStream output, String[] excludesList) throws CoreException {
        throw new RuntimeException("Not implemented.");
    }

    public IStatus importPreferences(InputStream input) throws CoreException {
        throw new RuntimeException("Not implemented.");
    }

    public IStatus applyPreferences(IExportedPreferences preferences) throws CoreException {
        throw new RuntimeException("Not implemented.");
    }

    public IExportedPreferences readPreferences(InputStream input) throws CoreException {
        throw new RuntimeException("Not implemented.");
    }

    public String[] getDefaultLookupOrder(String qualifier, String key) {
        LookupOrder order = (LookupOrder)DEFAULTS_REGISTRY.get(this.getRegistryKey(qualifier, key));
        return order == null ? null : order.getOrder();
    }

    public String[] getLookupOrder(String qualifier, String key) {
        String[] order = this.getDefaultLookupOrder(qualifier, key);
        if (order == null && key != null) {
            order = this.getDefaultLookupOrder(qualifier, null);
        }
        if (order == null) {
            if (this.isServerConfigGroup(qualifier)) {
                L.trace("Server configuration group: " + qualifier);
                boolean hasOverwrite = false;
                Preferences p = this.getNode(qualifier, InstanceScope.INSTANCE);
                if (p != null) {
                    Preferences sp = this.getNode(qualifier, ServerScope.INSTANCE);
                    boolean allowOverwrite = true;
                    if (sp != null) {
                        allowOverwrite = sp.getBoolean(SPECIAL_PROP_ALLOW_OVERWRITE, true);
                    }
                    if (!allowOverwrite) {
                        L.debug("Overwrite not allowed: " + qualifier + "; user overwrite will be ignored.");
                        hasOverwrite = false;
                    } else {
                        hasOverwrite = p.getBoolean(SPECIAL_PROP_OVERWRITE, false);
                    }
                }
                if (hasOverwrite) {
                    L.trace("Overwrite set, settings will be taken from instance scope: " + qualifier);
                    order = DEFAULT_LOOKUP_ORDER;
                } else {
                    L.trace("Overwrite not set, settings will be taken from server scope: " + qualifier);
                    order = DEFAULT_SERVER_LOOKUP_ORDER;
                }
            } else {
                order = DEFAULT_LOOKUP_ORDER;
            }
        }
        return order;
    }

    public void setDefaultLookupOrder(String qualifier, String key, String[] order) {
        String registryKey = this.getRegistryKey(qualifier, key);
        if (order == null) {
            DEFAULTS_REGISTRY.remove(registryKey);
        } else {
            LookupOrder obj = new LookupOrder(order);
            DEFAULTS_REGISTRY.put(registryKey, obj);
        }
    }

    public void exportPreferences(IEclipsePreferences node, IPreferenceFilter[] filters, OutputStream output) throws CoreException {
        throw new RuntimeException("Not implemented.");
    }

    public IPreferenceFilter[] matches(IEclipsePreferences node, IPreferenceFilter[] filters) throws CoreException {
        throw new RuntimeException("Not implemented.");
    }

    public void applyPreferences(IEclipsePreferences node, IPreferenceFilter[] filters) throws CoreException {
        throw new RuntimeException("Not implemented.");
    }

    private Preferences[] getNodes(final String qualifier, String key, final IScopeContext[] contexts) {
        String[] order = this.getLookupOrder(qualifier, key);
        final String childPath = ServerPreferences.makeRelative(ServerPreferences.decodePath(key)[0]);
        final ArrayList result = new ArrayList();
        int i = 0;
        while (i < order.length) {
            final String scopeString = order[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    boolean found = false;
                    int j = 0;
                    while (contexts != null && j < contexts.length) {
                        IEclipsePreferences node;
                        IScopeContext context = contexts[j];
                        if (context != null && context.getName().equals(scopeString) && (node = context.getNode(qualifier)) != null) {
                            found = true;
                            if (childPath != null) {
                                node = node.node(childPath);
                            }
                            result.add(node);
                        }
                        ++j;
                    }
                    if (!found) {
                        Preferences node = PreferencesService.this.getRootNode().node(scopeString).node(qualifier);
                        if (childPath != null) {
                            node = node.node(childPath);
                        }
                        result.add(node);
                    }
                    found = false;
                }

                public void handleException(Throwable t) {
                    L.error("Unexpected error.", t);
                }
            });
            ++i;
        }
        return result.toArray(new Preferences[result.size()]);
    }

    private Preferences getNode(String qualifier, IScopeContext context) {
        Preferences node = null;
        Preferences cp = this.getRootNode().node(context.getName());
        if (cp != null) {
            node = cp.node(qualifier);
        }
        return node;
    }

    private String getRegistryKey(String qualifier, String key) {
        if (qualifier == null) {
            throw new IllegalArgumentException();
        }
        if (key == null) {
            return qualifier;
        }
        return String.valueOf(qualifier) + '/' + key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isServerConfigGroup(String qualifier) {
        Set set = this.serverConfigGroups;
        synchronized (set) {
            String g;
            if (this.serverConfigGroups.contains(qualifier)) {
                return true;
            }
            HashSet groups = new HashSet(this.serverConfigGroups);
            Iterator iterator = groups.iterator();
            do {
                if (!iterator.hasNext()) {
                    return false;
                }
                Object o = iterator.next();
                g = (String)o;
            } while (!qualifier.startsWith(g = String.valueOf(g) + '.'));
            return true;
        }
    }

    private void hookListeners() {
        IEclipsePreferences root = this.impl.getRootNode();
        IEclipsePreferences instance = (IEclipsePreferences)root.node("instance");
        IEclipsePreferences server = (IEclipsePreferences)root.node("configurationServer");
        try {
            instance.accept(new IPreferenceNodeVisitor(){

                public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                    PreferencesService.addNodeChangeListener(node, PreferencesService.this.INSTANCE_LISTENER);
                    node.addPreferenceChangeListener(PreferencesService.this.INSTANCE_LISTENER);
                    return true;
                }
            });
        }
        catch (BackingStoreException e) {
            LogUtil.log(4, Messages.getString(PreferencesService.class, "log.error.visit", new String[]{"instance"}), e);
        }
        try {
            server.accept(new IPreferenceNodeVisitor(){

                public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                    PreferencesService.addNodeChangeListener(node, PreferencesService.this.SERVER_LISTENER);
                    node.addPreferenceChangeListener(PreferencesService.this.SERVER_LISTENER);
                    return true;
                }
            });
        }
        catch (BackingStoreException e) {
            LogUtil.log(4, Messages.getString(PreferencesService.class, "log.error.visit", new String[]{"instance"}), e);
        }
    }

    private static void addNodeChangeListener(IEclipsePreferences node, final IEclipsePreferences.IPreferenceChangeListener l) {
        node.addNodeChangeListener(new IEclipsePreferences.INodeChangeListener(){

            public void removed(IEclipsePreferences.NodeChangeEvent event) {
                IEclipsePreferences cep = (IEclipsePreferences)event.getChild();
                cep.addPreferenceChangeListener(l);
            }

            public void added(IEclipsePreferences.NodeChangeEvent event) {
                IEclipsePreferences cep = (IEclipsePreferences)event.getChild();
                cep.removePreferenceChangeListener(l);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireListeners(String scope, final IEclipsePreferences.PreferenceChangeEvent event) {
        Object[] ls = null;
        Map<String, ListenerList> map = this.PREF_LISTENERS;
        synchronized (map) {
            ListenerList l = this.PREF_LISTENERS.get(scope);
            if (l != null) {
                ls = l.getListeners();
            }
        }
        if (ls != null) {
            int i = 0;
            while (i < ls.length) {
                final IEclipsePreferences.IPreferenceChangeListener listener = (IEclipsePreferences.IPreferenceChangeListener)ls[i];
                ISafeRunnable job = new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        listener.preferenceChange(event);
                    }
                };
                SafeRunner.run((ISafeRunnable)job);
                ++i;
            }
        }
    }

    private void serverPreferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        L.trace("serverPreferenceChange: " + event);
        if (!(event.getSource() instanceof IEclipsePreferences)) {
            this.fireListeners("instance", event);
            return;
        }
        IEclipsePreferences serverPrefs = (IEclipsePreferences)event.getSource();
        String qualifier = serverPrefs.name();
        Preferences localPrefs = this.impl.getRootNode().node("instance").node(qualifier);
        if (event.getKey().equals(SPECIAL_PROP_ALLOW_OVERWRITE)) {
            boolean isOverwriteOld;
            boolean allowOverwrite = serverPrefs.getBoolean(SPECIAL_PROP_ALLOW_OVERWRITE, true);
            boolean isOverwrite = localPrefs != null && localPrefs.getBoolean(SPECIAL_PROP_OVERWRITE, false);
            this.fireListeners("configurationServer", event);
            if (!allowOverwrite && (isOverwrite = false) != (isOverwriteOld = isOverwrite) && localPrefs != null) {
                localPrefs.putBoolean(SPECIAL_PROP_OVERWRITE, isOverwrite);
            }
        } else {
            boolean isOverwrite = localPrefs != null && localPrefs.getBoolean(SPECIAL_PROP_OVERWRITE, false);
            boolean allowOverwrite = serverPrefs.getBoolean(SPECIAL_PROP_ALLOW_OVERWRITE, true);
            if (!allowOverwrite && isOverwrite) {
                isOverwrite = false;
                L.debug("Overwrite not allowed: " + localPrefs.name() + "; user overwrite will be ignored.");
            }
            if (!isOverwrite) {
                this.fireListeners("configurationServer", event);
            } else {
                this.fireListeners("configurationServer", event);
                this.fireListeners("instance", new IEclipsePreferences.PreferenceChangeEvent((Object)localPrefs, event.getKey(), event.getOldValue(), event.getNewValue()));
            }
        }
    }

    private void instancePreferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        L.trace("instancePreferenceChange: " + event);
        if (!(event.getSource() instanceof IEclipsePreferences)) {
            this.fireListeners("instance", event);
            return;
        }
        IEclipsePreferences localPrefs = (IEclipsePreferences)event.getSource();
        boolean specialHandling = this.isServerConfigGroup(localPrefs.name());
        String qualifier = localPrefs.name();
        if (!specialHandling) {
            this.fireListeners("instance", event);
            return;
        }
        Preferences serverPrefs = this.impl.getRootNode().node("configurationServer").node(qualifier);
        if (event.getKey().equals(SPECIAL_PROP_OVERWRITE)) {
            Object[] v;
            String k;
            String[] serverKeys = null;
            String[] localKeys = null;
            HashMap values = new HashMap();
            try {
                serverKeys = serverPrefs.keys();
            }
            catch (BackingStoreException e) {
                LogUtil.log(4, Messages.getString(PreferencesService.class, "log.error.keys"), e);
            }
            try {
                localKeys = serverPrefs.keys();
            }
            catch (BackingStoreException e) {
                LogUtil.log(4, Messages.getString(PreferencesService.class, "log.error.keys"), e);
            }
            String[] stringArray = serverKeys;
            int n = serverKeys.length;
            int n2 = 0;
            while (n2 < n) {
                k = stringArray[n2];
                v = (Object[])values.get(k);
                if (v == null) {
                    v = new Object[]{serverPrefs.get(k, null), null};
                }
                ++n2;
            }
            stringArray = localKeys;
            n = localKeys.length;
            n2 = 0;
            while (n2 < n) {
                k = stringArray[n2];
                v = (Object[])values.get(k);
                if (v == null) {
                    v = new Object[]{null, localPrefs.get(k, null)};
                }
                ++n2;
            }
            this.fireListeners("instance", event);
            boolean isOverwrite = localPrefs.getBoolean(SPECIAL_PROP_OVERWRITE, false);
            boolean allowOverwrite = serverPrefs.getBoolean(SPECIAL_PROP_ALLOW_OVERWRITE, true);
            if (!allowOverwrite) {
                L.debug("Overwrite not allowed: " + qualifier);
            }
            if (isOverwrite && allowOverwrite) {
                for (Map.Entry e : values.entrySet()) {
                    Object[] pair = (Object[])e.getValue();
                    this.fireListeners("instance", new IEclipsePreferences.PreferenceChangeEvent((Object)localPrefs, (String)e.getKey(), pair[0], pair[1]));
                }
            } else {
                for (Map.Entry e : values.entrySet()) {
                    Object[] pair = (Object[])e.getValue();
                    this.fireListeners("instance", new IEclipsePreferences.PreferenceChangeEvent((Object)localPrefs, (String)e.getKey(), pair[1], pair[0]));
                }
            }
        } else {
            boolean isOverwrite = localPrefs.getBoolean(SPECIAL_PROP_OVERWRITE, false);
            boolean allowOverwrite = serverPrefs.getBoolean(SPECIAL_PROP_ALLOW_OVERWRITE, true);
            if (!allowOverwrite) {
                L.debug("Overwrite not allowed: " + qualifier);
            }
            if (isOverwrite && allowOverwrite) {
                this.fireListeners("instance", event);
            }
        }
    }

    private static class LookupOrder {
        private String[] order;

        LookupOrder(String[] order) {
            int i = 0;
            while (i < order.length) {
                if (order[i] == null) {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            this.order = order;
        }

        public String[] getOrder() {
            return this.order;
        }
    }
}

