/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.preferences;

import com.ez.eclient.preferences.BasePreferences;
import com.ez.eclient.preferences.ExtensionLoader;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class ServerPreferences
extends BasePreferences {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private final IPath baseLocation;
    private boolean initialized = false;
    private String qualifier;
    private int segmentCount;
    private IEclipsePreferences loadLevel;

    public ServerPreferences() {
        this(null, null);
    }

    private ServerPreferences(IEclipsePreferences parent, String name) {
        super(parent, name, true);
        this.initializeChildren();
        String path = this.absolutePath();
        this.baseLocation = new Path(ExtensionLoader.getInstance().getRootLocation());
        this.segmentCount = ServerPreferences.getSegmentCount(path);
        if (this.segmentCount < 2) {
            return;
        }
        this.qualifier = ServerPreferences.getSegment(path, 1);
    }

    @Override
    protected BasePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName, Object context) {
        return new ServerPreferences(nodeParent, nodeName);
    }

    @Override
    protected void load(IPath location, boolean notify) throws BackingStoreException {
        super.load(location, notify);
    }

    @Override
    protected void load(boolean notify) throws BackingStoreException {
        this.load(this.getLocation(), notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeChildren() {
        if (this.initialized || this.parent == null) {
            return;
        }
        try {
            ServerPreferences serverPreferences = this;
            synchronized (serverPreferences) {
                String[] names = this.computeChildren(this.baseLocation);
                int i = 0;
                while (i < names.length) {
                    this.addChild(names[i], null);
                    ++i;
                }
            }
        }
        finally {
            this.initialized = true;
        }
    }

    @Override
    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            ServerPreferences node = this;
            int i = 2;
            while (i < this.segmentCount) {
                node = (IEclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    @Override
    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return false;
    }

    @Override
    protected IPath computeLocation(IPath root, String qualifier) {
        return root == null ? null : root.append(qualifier).addFileExtension("prefs");
    }

    @Override
    protected IPath getLocation() {
        return this.computeLocation(this.baseLocation, this.qualifier);
    }
}

