/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.preferences;

import com.ez.eclient.preferences.service.Configurator;
import com.ez.eclient.preferences.service.PreferencesService;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionLoader {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(ExtensionLoader.class);
    private static ExtensionLoader INSTANCE = new ExtensionLoader();
    static List<Configurator> CONFIGURATORS = null;
    private final Object CONFIGURATORS_G = new Object();
    static volatile Properties PROPERTIES = null;

    public static ExtensionLoader getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensurePostConfigure(PreferencesService service) {
        Object object = this.CONFIGURATORS_G;
        synchronized (object) {
            L.info("Pre configure.");
            this.ensureExtensions();
            for (Configurator c : CONFIGURATORS) {
                L.info("Invoke postconfigure on " + c);
                try {
                    c.postConfigure(service);
                }
                catch (Exception ex) {
                    L.error("Failed to call extension.", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensurePreConfigure() {
        Object object = this.CONFIGURATORS_G;
        synchronized (object) {
            L.info("Post configure.");
            this.ensureExtensions();
            if (PROPERTIES == null) {
                PROPERTIES = new Properties();
                for (Configurator c : CONFIGURATORS) {
                    L.info("Invoke preconfigure on " + c);
                    try {
                        c.preConfigure(PROPERTIES);
                    }
                    catch (Exception ex) {
                        L.error("Failed to call extension.", (Throwable)ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRootLocation() {
        if (PROPERTIES == null) {
            Object object = this.CONFIGURATORS_G;
            synchronized (object) {
                if (PROPERTIES == null) {
                    throw new IllegalStateException("Not configured.");
                }
            }
        }
        return (String)PROPERTIES.get("configuration.default_root_location");
    }

    private void ensureExtensions() {
        if (CONFIGURATORS == null) {
            L.info("Loading extensions...");
            CONFIGURATORS = new LinkedList<Configurator>();
            IConfigurationElement[] configs = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ez.eclient.preferences.service.configurator");
            if (configs != null) {
                IConfigurationElement[] iConfigurationElementArray = configs;
                int n = configs.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement ce = iConfigurationElementArray[n2];
                    Object e = null;
                    L.info("Extension found: " + ce);
                    try {
                        e = ce.createExecutableExtension("class");
                    }
                    catch (CoreException ex) {
                        L.error("Can't create extension.", (Throwable)ex);
                    }
                    if (e != null) {
                        L.info("Extension created: " + e);
                    }
                    if (e != null && e instanceof Configurator) {
                        CONFIGURATORS.add((Configurator)e);
                    }
                    ++n2;
                }
            }
        }
    }
}

