/*
 * Decompiled with CFR 0.152.
 */
package com.ez.eclient.preferences;

import com.ez.eclient.preferences.Base64;
import com.ez.eclient.preferences.Constants;
import com.ez.eclient.preferences.ImmutableMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePreferences
implements IEclipsePreferences,
IScope {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(BasePreferences.class);
    private static final ILog EL = Platform.getLog((Bundle)FrameworkUtil.getBundle(BasePreferences.class));
    public static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";
    public static final String PREFS_FILE_EXTENSION = "prefs";
    protected static final IEclipsePreferences[] EMPTY_NODE_ARRAY = new IEclipsePreferences[0];
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    protected static final String VERSION_KEY = "eclipse.preferences.version";
    protected static final String VERSION_VALUE = "1";
    protected static final String PATH_SEPARATOR = String.valueOf('/');
    protected static final String DOUBLE_SLASH = "//";
    protected static final String EMPTY_STRING = "";
    private String cachedPath;
    protected Map children;
    protected boolean dirty = false;
    protected boolean loading = false;
    protected final String name;
    protected final boolean readonly;
    protected final IEclipsePreferences parent;
    protected ImmutableMap properties = ImmutableMap.EMPTY;
    protected boolean removed = false;
    private ListenerList nodeChangeListeners;
    private ListenerList preferenceChangeListeners;
    protected static final String debugPluginName = "org.eclipse.equinox.preferences";

    private BasePreferences() {
        this(null, null, false);
    }

    protected BasePreferences(IEclipsePreferences parent, String name, boolean readonly) {
        this.readonly = readonly;
        this.parent = parent;
        this.name = name;
        this.cachedPath = null;
    }

    public String absolutePath() {
        if (this.cachedPath == null) {
            String parentPath;
            this.cachedPath = this.parent == null ? PATH_SEPARATOR : ((parentPath = this.parent.absolutePath()).length() == 1 ? String.valueOf(parentPath) + this.name() : String.valueOf(parentPath) + PATH_SEPARATOR + this.name());
        }
        return this.cachedPath;
    }

    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
        if (!visitor.visit((IEclipsePreferences)this)) {
            return;
        }
        IEclipsePreferences[] toVisit = this.getChildren(true);
        int i = 0;
        while (i < toVisit.length) {
            toVisit[i].accept(visitor);
            ++i;
        }
    }

    protected synchronized IEclipsePreferences addChild(String childName, IEclipsePreferences child) {
        if (this.children == null) {
            this.children = Collections.synchronizedMap(new HashMap());
        }
        this.children.put(childName, child == null ? childName : child);
        return child;
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        if (this.nodeChangeListeners == null) {
            this.nodeChangeListeners = new ListenerList();
        }
        this.nodeChangeListeners.add((Object)listener);
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        if (this.preferenceChangeListeners == null) {
            this.preferenceChangeListeners = new ListenerList();
        }
        this.preferenceChangeListeners.add((Object)listener);
    }

    private IEclipsePreferences calculateRoot() {
        BasePreferences result = this;
        while (result.parent() != null) {
            result = (IEclipsePreferences)result.parent();
        }
        return result;
    }

    protected void checkRemoved() {
        if (this.removed) {
            throw new IllegalStateException(NLS.bind((String)"remove node", (Object)this.name));
        }
    }

    public String[] childrenNames() {
        this.checkRemoved();
        return this.internalChildNames();
    }

    protected String[] internalChildNames() {
        Map temp = this.children;
        if (temp == null || temp.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return temp.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public void clear() {
        this.checkRemoved();
        String[] keys = this.properties.keys();
        int i = 0;
        while (i < keys.length) {
            this.remove(keys[i]);
            ++i;
        }
        this.makeDirty();
    }

    protected String[] computeChildren(IPath root) {
        if (root == null) {
            return EMPTY_STRING_ARRAY;
        }
        IPath dir = root.append(DEFAULT_PREFERENCES_DIRNAME);
        ArrayList<String> result = new ArrayList<String>();
        File file = dir.toFile();
        File[] totalFiles = file.listFiles();
        if (totalFiles != null) {
            int i = 0;
            while (i < totalFiles.length) {
                String filename;
                if (totalFiles[i].isFile() && (filename = totalFiles[i].getName()).endsWith(".prefs")) {
                    String shortName = filename.substring(0, filename.length() - ".prefs".length());
                    result.add(shortName);
                }
                ++i;
            }
        }
        return result.toArray(EMPTY_STRING_ARRAY);
    }

    protected IPath computeLocation(IPath root, String qualifier) {
        return root == null ? null : root.append(DEFAULT_PREFERENCES_DIRNAME).append(qualifier).addFileExtension(PREFS_FILE_EXTENSION);
    }

    protected static void convertFromProperties(BasePreferences node, Properties table, boolean notify) {
        String version = table.getProperty(VERSION_KEY);
        if (version != null) {
            VERSION_VALUE.equals(version);
        }
        table.remove(VERSION_KEY);
        for (String string : table.keySet()) {
            String value = table.getProperty(string);
            if (value == null) continue;
            String[] splitPath = BasePreferences.decodePath(string);
            String path = splitPath[0];
            path = BasePreferences.makeRelative(path);
            String key = splitPath[1];
            BasePreferences childNode = (BasePreferences)node.internalNode(path, false, null);
            String oldValue = childNode.internalPut(key, value);
            if (!notify || value.equals(oldValue)) continue;
            childNode.firePreferenceEvent(key, oldValue, value);
        }
    }

    protected static void write(Properties properties, IPath location) throws BackingStoreException {
        File parentFile = location.toFile().getParentFile();
        if (parentFile == null) {
            return;
        }
        parentFile.mkdirs();
        OutputStream output = null;
        try {
            try {
                output = new BufferedOutputStream(new FileOutputStream(new File(location.toOSString())));
                output.write(BasePreferences.removeTimestampFromTable(properties).getBytes("UTF-8"));
                output.flush();
            }
            catch (IOException e) {
                String message = NLS.bind((String)"preference save exception", (Object)location);
                BasePreferences.log((IStatus)new Status(4, Constants.OWNER_NAME, 4, message, (Throwable)e));
                throw new BackingStoreException(message);
            }
        }
        catch (Throwable throwable) {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (output != null) {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected static String removeTimestampFromTable(Properties properties) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            properties.store(output, null);
        }
        String string = output.toString("UTF-8");
        String separator = System.getProperty("line.separator");
        return string.substring(string.indexOf(separator) + separator.length());
    }

    protected Properties convertToProperties(Properties result, String prefix) throws BackingStoreException {
        boolean addSeparator = prefix.length() != 0;
        ImmutableMap temp = this.properties;
        String[] keys = temp.keys();
        int i = 0;
        int imax = keys.length;
        while (i < imax) {
            String value = temp.get(keys[i]);
            if (value != null) {
                result.put(BasePreferences.encodePath(prefix, keys[i]), value);
            }
            ++i;
        }
        IEclipsePreferences[] childNodes = this.getChildren(true);
        int i2 = 0;
        while (i2 < childNodes.length) {
            BasePreferences child = (BasePreferences)childNodes[i2];
            String fullPath = addSeparator ? String.valueOf(prefix) + PATH_SEPARATOR + child.name() : child.name();
            child.convertToProperties(result, fullPath);
            ++i2;
        }
        return result;
    }

    public IEclipsePreferences create(IEclipsePreferences nodeParent, String nodeName) {
        return this.create(nodeParent, nodeName, null);
    }

    protected boolean isLoading() {
        return this.loading;
    }

    protected void setLoading(boolean isLoading) {
        this.loading = isLoading;
    }

    public IEclipsePreferences create(IEclipsePreferences nodeParent, String nodeName, Object context) {
        BasePreferences result = this.internalCreate(nodeParent, nodeName, context);
        if (nodeParent instanceof BasePreferences) {
            ((BasePreferences)nodeParent).addChild(nodeName, result);
        } else if (L.isDebugEnabled()) {
            L.debug("Parent not instance of " + BasePreferences.class);
        }
        IEclipsePreferences loadLevel = result.getLoadLevel();
        if (loadLevel == null) {
            return result;
        }
        if (result != loadLevel) {
            return result;
        }
        if (this.isAlreadyLoaded(result) || result.isLoading()) {
            return result;
        }
        try {
            try {
                result.setLoading(true);
                result.loadLegacy();
                result.load(false);
                result.loaded();
                result.flush();
            }
            catch (BackingStoreException e) {
                IPath location = result.getLocation();
                String message = NLS.bind((String)"Preferences laod exception", (Object)(location == null ? EMPTY_STRING : location.toString()));
                Status status = new Status(4, Constants.OWNER_NAME, 4, message, (Throwable)e);
                EL.log((IStatus)status);
                result.setLoading(false);
            }
        }
        finally {
            result.setLoading(false);
        }
        return result;
    }

    public synchronized void flush() throws BackingStoreException {
        if (!this.readonly) {
            this.internalFlush();
        }
    }

    protected void internalFlush() throws BackingStoreException {
        this.checkRemoved();
        IEclipsePreferences loadLevel = this.getLoadLevel();
        if (loadLevel == null) {
            String[] childrenNames = this.childrenNames();
            int i = 0;
            while (i < childrenNames.length) {
                this.node(childrenNames[i]).flush();
                ++i;
            }
            return;
        }
        if (this != loadLevel) {
            loadLevel.flush();
            return;
        }
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        try {
            this.save();
        }
        catch (BackingStoreException e) {
            this.dirty = true;
            throw e;
        }
    }

    public String get(String key, String defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : value;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : TRUE.equalsIgnoreCase(value);
    }

    public byte[] getByteArray(String key, byte[] defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : Base64.decode(value.getBytes());
    }

    protected synchronized boolean childExists(String childName) {
        if (this.children == null) {
            return false;
        }
        return this.children.get(childName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IEclipsePreferences getChild(String key, Object context, boolean create) {
        BasePreferences basePreferences = this;
        synchronized (basePreferences) {
            block9: {
                Object value;
                block8: {
                    block7: {
                        if (this.children != null) break block7;
                        return null;
                    }
                    value = this.children.get(key);
                    if (value != null) break block8;
                    return null;
                }
                if (value instanceof IEclipsePreferences) {
                    return (IEclipsePreferences)value;
                }
                if (create) break block9;
                return null;
            }
        }
        return this.addChild(key, this.create(this, key, context));
    }

    protected IEclipsePreferences[] getChildren(boolean create) {
        ArrayList<IEclipsePreferences> result = new ArrayList<IEclipsePreferences>();
        String[] names = this.internalChildNames();
        int i = 0;
        while (i < names.length) {
            IEclipsePreferences child = this.getChild(names[i], null, create);
            if (child != null) {
                result.add(child);
            }
            ++i;
        }
        return result.toArray(EMPTY_NODE_ARRAY);
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.internalGet(key);
        double result = defaultValue;
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public float getFloat(String key, float defaultValue) {
        String value = this.internalGet(key);
        float result = defaultValue;
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public int getInt(String key, int defaultValue) {
        String value = this.internalGet(key);
        int result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    protected IEclipsePreferences getLoadLevel() {
        return null;
    }

    protected IPath getLocation() {
        return null;
    }

    public long getLong(String key, long defaultValue) {
        String value = this.internalGet(key);
        long result = defaultValue;
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    protected BasePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName, Object context) {
        return new BasePreferences(nodeParent, nodeName, this.readonly);
    }

    protected String internalGet(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        String result = this.properties.get(key);
        return result;
    }

    protected IEclipsePreferences internalNode(String path, boolean notify, Object context) {
        this.checkRemoved();
        if (path.length() == 0) {
            return this;
        }
        if (path.charAt(0) == '/') {
            return (IEclipsePreferences)this.calculateRoot().node(path.substring(1));
        }
        int index = path.indexOf(47);
        String key = index == -1 ? path : path.substring(0, index);
        boolean added = false;
        IEclipsePreferences child = this.getChild(key, context, true);
        if (child == null) {
            child = this.create(this, key, context);
            added = true;
        }
        if (added && notify) {
            this.fireNodeEvent(new IEclipsePreferences.NodeChangeEvent((Preferences)this, (Preferences)child), true);
        }
        return (IEclipsePreferences)child.node(index == -1 ? EMPTY_STRING : path.substring(index + 1));
    }

    protected String internalPut(String key, String newValue) {
        this.checkRemoved();
        String oldValue = this.properties.get(key);
        if (oldValue != null && oldValue.equals(newValue)) {
            return oldValue;
        }
        this.properties = this.properties.put(key, newValue);
        return oldValue;
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return true;
    }

    public String[] keys() {
        this.checkRemoved();
        return this.properties.keys();
    }

    protected void load(boolean notify) throws BackingStoreException {
        this.load(this.getLocation(), notify);
    }

    protected static Properties loadProperties(IPath location) throws BackingStoreException {
        Properties result;
        block14: {
            InputStream input = null;
            result = new Properties();
            try {
                input = new BufferedInputStream(new FileInputStream(location.toFile()));
                result.load(input);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Properties properties = result;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                return properties;
            }
            catch (IOException e) {
                try {
                    String message = NLS.bind((String)"Preferences load exception", (Object)location);
                    BasePreferences.log((IStatus)new Status(1, Constants.OWNER_NAME, 1, message, (Throwable)e));
                    throw new BackingStoreException(message);
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
            }
            if (input == null) break block14;
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    protected void load(IPath location, boolean notify) throws BackingStoreException {
        if (location == null) {
            return;
        }
        Properties fromDisk = BasePreferences.loadProperties(location);
        BasePreferences.convertFromProperties(this, fromDisk, notify);
    }

    protected void loaded() {
    }

    protected void loadLegacy() {
    }

    public static void log(IStatus status) {
        EL.log(status);
    }

    protected void makeDirty() {
        BasePreferences node = this;
        while (node != null && !node.removed) {
            Preferences p = node.parent();
            node.dirty = true;
            if (p instanceof BasePreferences) {
                node = (BasePreferences)p;
                continue;
            }
            node = null;
            if (!L.isDebugEnabled()) continue;
            L.debug("Parent not instance of " + BasePreferences.class);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String name() {
        return this.name;
    }

    public Preferences node(String pathName) {
        return this.internalNode(pathName, true, null);
    }

    protected void fireNodeEvent(final IEclipsePreferences.NodeChangeEvent event, final boolean added) {
        if (this.nodeChangeListeners == null) {
            return;
        }
        Object[] listeners = this.nodeChangeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IEclipsePreferences.INodeChangeListener listener = (IEclipsePreferences.INodeChangeListener)listeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    if (added) {
                        listener.added(event);
                    } else {
                        listener.removed(event);
                    }
                }
            };
            SafeRunner.run((ISafeRunnable)job);
            ++i;
        }
    }

    public boolean nodeExists(String path) throws BackingStoreException {
        boolean noSlash;
        if (path.length() == 0) {
            return !this.removed;
        }
        this.checkRemoved();
        if (path.charAt(0) == '/') {
            return this.calculateRoot().nodeExists(path.substring(1));
        }
        int index = path.indexOf(47);
        boolean bl = noSlash = index == -1;
        if (noSlash) {
            return this.childExists(path);
        }
        String childName = path.substring(0, index);
        if (!this.childExists(childName)) {
            return false;
        }
        IEclipsePreferences child = this.getChild(childName, null, true);
        if (child == null) {
            return false;
        }
        return child.nodeExists(path.substring(index + 1));
    }

    public Preferences parent() {
        this.checkRemoved();
        return this.parent;
    }

    protected void firePreferenceEvent(String key, Object oldValue, Object newValue) {
        if (this.preferenceChangeListeners == null) {
            return;
        }
        Object[] listeners = this.preferenceChangeListeners.getListeners();
        final IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent((Object)this, key, oldValue, newValue);
        int i = 0;
        while (i < listeners.length) {
            final IEclipsePreferences.IPreferenceChangeListener listener = (IEclipsePreferences.IPreferenceChangeListener)listeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.preferenceChange(event);
                }
            };
            SafeRunner.run((ISafeRunnable)job);
            ++i;
        }
    }

    public void put(String key, String newValue) {
        if (key == null || newValue == null) {
            throw new NullPointerException();
        }
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putBoolean(String key, boolean value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = value ? TRUE : FALSE;
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putByteArray(String key, byte[] value) {
        String oldValue;
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        String newValue = new String(Base64.encode(value));
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putDouble(String key, double value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Double.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putFloat(String key, float value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Float.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putInt(String key, int value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Integer.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void putLong(String key, long value) {
        String oldValue;
        if (key == null) {
            throw new NullPointerException();
        }
        String newValue = Long.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.firePreferenceEvent(key, oldValue, newValue);
        }
    }

    public void remove(String key) {
        this.checkRemoved();
        String oldValue = this.properties.get(key);
        if (oldValue == null) {
            return;
        }
        this.properties = this.properties.removeKey(key);
        this.makeDirty();
        this.firePreferenceEvent(key, oldValue, null);
    }

    public void removeNode() throws BackingStoreException {
        this.checkRemoved();
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            this.remove(keys[i]);
            ++i;
        }
        if (this.parent != null && this.parent.parent() != null) {
            this.removed = true;
            if (this.parent instanceof BasePreferences) {
                ((BasePreferences)this.parent).removeNode(this);
            } else if (L.isDebugEnabled()) {
                L.debug("Parent not instance of " + BasePreferences.class);
            }
        }
        IEclipsePreferences[] childNodes = this.getChildren(false);
        int i2 = 0;
        while (i2 < childNodes.length) {
            try {
                childNodes[i2].removeNode();
            }
            catch (IllegalStateException illegalStateException) {}
            ++i2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNode(IEclipsePreferences child) {
        boolean wasRemoved = false;
        BasePreferences basePreferences = this;
        synchronized (basePreferences) {
            if (this.children != null) {
                boolean bl = wasRemoved = this.children.remove(child.name()) != null;
                if (wasRemoved) {
                    this.makeDirty();
                }
                if (this.children.isEmpty()) {
                    this.children = null;
                }
            }
        }
        if (wasRemoved) {
            this.fireNodeEvent(new IEclipsePreferences.NodeChangeEvent((Preferences)this, (Preferences)child), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNode(String key) {
        BasePreferences basePreferences = this;
        synchronized (basePreferences) {
            if (this.children != null) {
                boolean wasRemoved;
                boolean bl = wasRemoved = this.children.remove(key) != null;
                if (wasRemoved) {
                    this.makeDirty();
                }
                if (this.children.isEmpty()) {
                    this.children = null;
                }
            }
        }
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        if (this.nodeChangeListeners == null) {
            return;
        }
        this.nodeChangeListeners.remove((Object)listener);
        if (this.nodeChangeListeners.size() == 0) {
            this.nodeChangeListeners = null;
        }
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        if (this.preferenceChangeListeners == null) {
            return;
        }
        this.preferenceChangeListeners.remove((Object)listener);
        if (this.preferenceChangeListeners.size() == 0) {
            this.preferenceChangeListeners = null;
        }
    }

    protected void save() throws BackingStoreException {
        this.save(this.getLocation());
    }

    protected void save(IPath location) throws BackingStoreException {
        if (location == null) {
            return;
        }
        Properties table = this.convertToProperties(new SortedProperties(), EMPTY_STRING);
        if (table.isEmpty()) {
            if (location.toFile().exists() && !location.toFile().delete()) {
                String message = NLS.bind((String)"Preferences failed delete", (Object)location);
                BasePreferences.log((IStatus)new Status(2, Constants.OWNER_NAME, 2, message, null));
            }
            return;
        }
        table.put(VERSION_KEY, VERSION_VALUE);
        BasePreferences.write(table, location);
    }

    public static String encodePath(String path, String key) {
        int pathLength;
        int n = pathLength = path == null ? 0 : path.length();
        String result = key.indexOf(47) == -1 ? (pathLength == 0 ? key : String.valueOf(path) + '/' + key) : (pathLength == 0 ? DOUBLE_SLASH + key : String.valueOf(path) + DOUBLE_SLASH + key);
        return result;
    }

    public static String getSegment(String path, int segment) {
        int start = path.indexOf(47) == 0 ? 1 : 0;
        int end = path.indexOf(47, start);
        if (end == path.length() - 1) {
            end = -1;
        }
        int i = 0;
        while (i < segment) {
            if (end == -1) {
                return null;
            }
            start = end + 1;
            end = path.indexOf(47, start);
            ++i;
        }
        if (end == -1) {
            end = path.length();
        }
        return path.substring(start, end);
    }

    public static int getSegmentCount(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, String.valueOf('/'));
        return tokenizer.countTokens();
    }

    public static String makeRelative(String path) {
        String result = path;
        if (path == null) {
            return EMPTY_STRING;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            result = path.length() == 0 ? EMPTY_STRING : path.substring(1);
        }
        return result;
    }

    public static String[] decodePath(String fullPath) {
        String key = null;
        String path = null;
        int index = fullPath.indexOf(DOUBLE_SLASH);
        if (index == -1) {
            int lastIndex = fullPath.lastIndexOf(47);
            if (lastIndex == -1) {
                key = fullPath;
            } else {
                path = fullPath.substring(0, lastIndex);
                key = fullPath.substring(lastIndex + 1);
            }
        } else {
            path = fullPath.substring(0, index);
            key = fullPath.substring(index + 2);
        }
        if (path != null) {
            if (path.length() == 0) {
                path = null;
            } else if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
        }
        return new String[]{path, key};
    }

    public void sync() throws BackingStoreException {
        this.checkRemoved();
        IEclipsePreferences node = this.getLoadLevel();
        if (node == null) {
            return;
        }
        if (node instanceof BasePreferences) {
            ((BasePreferences)node).load(true);
            node.flush();
        }
    }

    public String toDeepDebugString() {
        final StringBuffer buffer = new StringBuffer();
        IPreferenceNodeVisitor visitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                buffer.append(node);
                buffer.append('\n');
                String[] keys = node.keys();
                int i = 0;
                while (i < keys.length) {
                    buffer.append(node.absolutePath());
                    buffer.append(PATH_SEPARATOR);
                    buffer.append(keys[i]);
                    buffer.append('=');
                    buffer.append(node.get(keys[i], "*default*"));
                    buffer.append('\n');
                    ++i;
                }
                return true;
            }
        };
        try {
            this.accept(visitor);
        }
        catch (BackingStoreException e) {
            System.out.println("Exception while calling #toDeepDebugString()");
            L.error("Exception while calling #toDeepDebugString():", (Throwable)e);
        }
        return buffer.toString();
    }

    public String toString() {
        return this.absolutePath();
    }

    protected class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        @Override
        public synchronized Enumeration keys() {
            TreeSet<Object> set = new TreeSet<Object>();
            Enumeration<Object> e = super.keys();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
            return Collections.enumeration(set);
        }

        @Override
        public Set entrySet() {
            TreeSet<Map.Entry<Object, Object>> set = new TreeSet<Map.Entry<Object, Object>>(new Comparator(){

                public int compare(Object e1, Object e2) {
                    String s1 = (String)((Map.Entry)e1).getKey();
                    String s2 = (String)((Map.Entry)e2).getKey();
                    return s1.compareTo(s2);
                }
            });
            Iterator<Map.Entry<Object, Object>> i = super.entrySet().iterator();
            while (i.hasNext()) {
                set.add(i.next());
            }
            return set;
        }
    }
}

