/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.preferences;

import com.ez.internal.utils.ServiceUtils;
import com.ez.workspace.internal.Messages;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String NO_IP = Messages.getString(Utils.class, (String)"noIp.label");

    public static Map rezolveString(String arg0) {
        HashMap result = new HashMap();
        if (arg0 == null || arg0.equals("")) {
            return result;
        }
        StringTokenizer stok = new StringTokenizer(arg0, ";");
        int mapSize = stok.countTokens();
        int i = 0;
        while (i < mapSize) {
            String host;
            String allEntry = stok.nextToken(";");
            int pos = allEntry.indexOf(40);
            if (pos != -1) {
                host = allEntry.substring(0, pos);
                String ip = allEntry.substring(pos + 1, allEntry.length() - 1);
                List list = result.containsKey(host) ? (List)result.get(host) : new ArrayList();
                list.add(ip);
                result.put(host, list);
            } else {
                host = allEntry;
                List list = result.containsKey(host) ? (List)result.get(host) : new ArrayList();
                list.add(NO_IP);
                result.put(host, list);
            }
            ++i;
        }
        return result;
    }

    public static Set getIPs(String arg0) {
        HashSet<String> res = new HashSet<String>();
        if (arg0 == null || arg0.equals("")) {
            return res;
        }
        StringTokenizer stok = new StringTokenizer(arg0, ";");
        int mapSize = stok.countTokens();
        int i = 0;
        while (i < mapSize) {
            String allEntry = stok.nextToken(";");
            int pos = allEntry.indexOf(40);
            if (pos != -1) {
                String ip = allEntry.substring(pos + 1, allEntry.length() - 1);
                res.add(ip);
            }
            ++i;
        }
        return res;
    }

    private static Set getHosts(String arg0) {
        HashSet<String> res = new HashSet<String>();
        if (arg0 == null || arg0.equals("")) {
            return res;
        }
        StringTokenizer stok = new StringTokenizer(arg0, ";");
        int mapSize = stok.countTokens();
        int i = 0;
        while (i < mapSize) {
            String host;
            String allEntry = stok.nextToken(";");
            int pos = allEntry.indexOf(40);
            if (pos != -1) {
                host = allEntry.substring(0, pos);
                res.add(host);
            } else {
                host = allEntry;
                res.add(host);
            }
            ++i;
        }
        return res;
    }

    public static boolean isHostInPreference(String searchHost) {
        boolean res = false;
        IPreferenceStore prefStore = WorkspacePrefUtils.getPreferenceStore();
        String entryFromPrefString = prefStore.getString("xiServers");
        Set hostsFromPreference = Utils.getHosts(entryFromPrefString);
        for (String host : hostsFromPreference) {
            if (!host.equalsIgnoreCase(searchHost)) continue;
            res = true;
            break;
        }
        return res;
    }

    public static boolean isIPInPreference(String searchIP) {
        boolean res = false;
        if (searchIP == null || searchIP.equals("")) {
            return false;
        }
        IPreferenceStore prefStore = WorkspacePrefUtils.getPreferenceStore();
        String entryFromPrefString = prefStore.getString("xiServers");
        StringTokenizer stok = new StringTokenizer(entryFromPrefString, ";");
        int mapSize = stok.countTokens();
        int i = 0;
        while (i < mapSize) {
            String ip;
            String allEntry = stok.nextToken(";");
            int pos = allEntry.indexOf(40);
            if (pos != -1 && searchIP.equalsIgnoreCase(ip = allEntry.substring(pos + 1, allEntry.length() - 1))) {
                res = true;
                break;
            }
            ++i;
        }
        return res;
    }

    public static String getTemporaryFolder() {
        String tempPath = null;
        tempPath = ServiceUtils.isOsgi() ? WorkspacePrefUtils.getPreferenceStore().getString("tempFolderPathPreference") : System.getProperty("java.io.tmpdir");
        return tempPath;
    }
}

