/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.preferences;

import com.ez.internal.utils.PreferencesUtils;
import com.ez.workspace.preferences.PreferenceConstants;
import com.ez.workspace.preferences.PreferenceUtils;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PreferenceInitializer.class);

    public void initializeDefaultPreferences() {
        boolean wkspSet = Platform.getInstanceLocation().isSet();
        L.trace("1. initializeDefaultPreferences()::wkspSet={}", (Object)wkspSet);
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        ScopedPreferenceStore log4jStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.ez.eclient.logging.preferences");
        log4jStore.setDefault("logPathPreference", (String)com.ez.eclient.logging.preferences.PreferenceUtils.getDefaultValue((String)"logPathPreference"));
        wkspSet = Platform.getInstanceLocation().isSet();
        L.trace("2.initializeDefaultPreferences()::wkspSet={}", (Object)wkspSet);
        store.setDefault("additionalSVGforVisio", ((Boolean)PreferenceUtils.getDefaultValue((String)"additionalSVGforVisio")).booleanValue());
        store.setDefault("levelsZoomPreference", (String)PreferenceUtils.getDefaultValue((String)"levelsZoomPreference"));
        store.setDefault("verboseLogPreference", ((Boolean)PreferenceUtils.getDefaultValue((String)"verboseLogPreference")).booleanValue());
        store.setDefault("enableEasyLogPreference", ((Boolean)PreferenceUtils.getDefaultValue((String)"enableEasyLogPreference")).booleanValue());
        store.setDefault("indirectLinksPreference", ((Boolean)PreferenceUtils.getDefaultValue((String)"indirectLinksPreference")).booleanValue());
        store.setDefault("graphNodesExceed", ((Integer)PreferenceUtils.getDefaultValue((String)"graphNodesExceed")).intValue());
        store.setDefault("callgraphLevelsLimitedPreference", ((Boolean)PreferenceUtils.getDefaultValue((String)"callgraphLevelsLimitedPreference")).booleanValue());
        store.setDefault("callgraphLimitExceed", ((Integer)PreferenceUtils.getDefaultValue((String)"callgraphLimitExceed")).intValue());
        store.setDefault("graphHighlightedOnlyExpandableAtLimit", ((Boolean)PreferenceUtils.getDefaultValue((String)"graphHighlightedOnlyExpandableAtLimit")).booleanValue());
        store.setDefault("showCgOtherPrj", ((Boolean)PreferenceUtils.getDefaultValue((String)"showCgOtherPrj")).booleanValue());
        store.setDefault("callgraphWithoutResources", ((Boolean)PreferenceUtils.getDefaultValue((String)"callgraphWithoutResources")).booleanValue());
        store.setDefault("SQL Table", Boolean.TRUE.booleanValue());
        store.setDefault("CICS Transaction", Boolean.TRUE.booleanValue());
        store.setDefault("File", Boolean.TRUE.booleanValue());
        store.setDefault("Map", Boolean.TRUE.booleanValue());
        store.setDefault("MQ", Boolean.TRUE.booleanValue());
        store.setDefault("IMS", Boolean.TRUE.booleanValue());
        store.setDefault("Adabas", Boolean.TRUE.booleanValue());
        store.setDefault("Datacom", Boolean.TRUE.booleanValue());
        store.setDefault("DAL", Boolean.TRUE.booleanValue());
        store.setDefault("DBI Table", Boolean.TRUE.booleanValue());
        store.setDefault("IDMS", Boolean.TRUE.booleanValue());
        store.setDefault("tempFolderPathPreference", PreferenceConstants.DEFAULT_TEMP_FOLDER);
        File temp = new File(PreferenceConstants.DEFAULT_TEMP_FOLDER);
        if (!temp.exists() || temp.isFile()) {
            boolean vb = temp.mkdir();
            L.debug("temporary folder created={}", (Object)vb);
        }
        String ip = PreferencesUtils.manageClientIP();
        L.debug("pref client ip: {}", (Object)ip);
    }
}

