/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.ui.utils;

import com.ez.eclient.configuration.Configuration;
import com.ez.eclient.configuration.service.ConfigurationService;
import com.ez.eclient.configuration.service.DefaultConfigurationService;
import com.ez.report.generation.common.ui.internal.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger L = LoggerFactory.getLogger(Utils.class);
    private static final String SWAP_FOLDER = "cache";

    public static String getReportExternalizedName(String key) {
        return Messages.getString(Utils.class, key);
    }

    public static void addParametersFromPreferences(Map<String, Object> inputs) {
        String role;
        String owner;
        String defaultValue = "-";
        Configuration conf = ConfigurationService.getDefault().getConfiguration("analyses.reports");
        String orgName = (String)conf.getObject("reports.organization");
        if (orgName == null || orgName.length() == 0) {
            orgName = defaultValue;
        }
        if ((owner = (String)conf.getObject("reports.owner")) == null || owner.length() == 0) {
            owner = defaultValue;
        }
        if ((role = (String)conf.getObject("reports.organizationRole")) == null || role.length() == 0) {
            role = defaultValue;
        }
        inputs.put("organization", orgName);
        inputs.put("owner", owner);
        inputs.put("organization_role", role);
        InputStream is = null;
        String customImage = Utils.getReportLogoPath();
        if (customImage != null && !customImage.trim().isEmpty()) {
            try {
                is = new FileInputStream(new File(customImage));
            }
            catch (Exception e) {
                L.error("could not load custom image", (Throwable)e);
                customImage = null;
            }
        } else {
            customImage = null;
        }
        if (customImage == null) {
            is = com.ez.report.generation.common.utils.Utils.getDefaultLogo();
        }
        inputs.put("report image header", is);
        String swapFolder = Utils.getSwapFolderPath();
        inputs.put("swap_folder", swapFolder);
    }

    public static String getReportLogoPath() {
        Object obj;
        String ret = null;
        Configuration conf = ((DefaultConfigurationService)ConfigurationService.getDefault()).getConfiguration("analyses.reports");
        if (conf != null && (obj = conf.getObject("reports.reportImageHeader")) != null && !((String)obj).isEmpty()) {
            ret = (String)obj;
        }
        return ret;
    }

    public static String rgbToString(RGB color) {
        StringBuffer defVal = new StringBuffer();
        defVal.append(color.red);
        defVal.append(",");
        defVal.append(color.green);
        defVal.append(",");
        defVal.append(color.blue);
        return defVal.toString();
    }

    public static final String getSwapFolderPath() {
        String path = String.valueOf(com.ez.workspace.preferences.Utils.getTemporaryFolder()) + com.ez.internal.utils.Utils.SYSTEM_FILE_SEPARATOR_PROPERTY + SWAP_FOLDER;
        File swapFolder = new File(path);
        if (!swapFolder.exists()) {
            swapFolder.mkdir();
        }
        return path;
    }
}

