/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.ui.internal;

import com.ez.report.generation.common.ReportsRepository;
import com.ez.report.generation.common.model.ReportGroupInformation;
import com.ez.report.generation.common.model.ReportInformation;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    private static final Logger L = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "com.ez.report.generation.common.ui";
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.loadExtensions();
    }

    private void loadExtensions() {
        this.loadGroups();
        this.loadReports();
    }

    private void loadReports() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ez.report.generation.common.report");
        if (config.length < 1) {
            L.warn("no report defined with com.ez.report.generation.common.report extension");
        } else {
            int i = 0;
            while (i < config.length) {
                IConfigurationElement ext = config[i];
                String reportID = ext.getAttribute("id");
                if (reportID != null && !reportID.isEmpty()) {
                    ReportInformation info = new ReportInformation();
                    info.setReportID(reportID);
                    String att = ext.getAttribute("name");
                    if (att != null && !att.isEmpty()) {
                        info.setReportName(att);
                    }
                    if ((att = ext.getAttribute("imageName")) != null && !att.isEmpty()) {
                        info.setImageName(att);
                    }
                    if ((att = ext.getAttribute("groupId")) != null && !att.isEmpty()) {
                        info.setReportGroupId(att);
                    }
                    if ((att = ext.getAttribute("hasProperties")) != null && !att.isEmpty()) {
                        Boolean ret = Boolean.valueOf(att);
                        info.setHasProperties(ret.booleanValue());
                    }
                    if ((att = ext.getAttribute("propertiesViewID")) != null && !att.isEmpty()) {
                        info.setReportPropertyViewID(att);
                    }
                    IConfigurationElement[] elems = ext.getChildren();
                    int j = 0;
                    while (j < elems.length) {
                        IConfigurationElement elem = elems[j];
                        if ("builder".equals(elem.getName())) {
                            info.setBuilderClassName(elem.getAttribute("class"));
                        } else if ("model".equals(elem.getName())) {
                            info.setReportClassName(elem.getAttribute("class"));
                        } else if ("executor".equals(elem.getName())) {
                            info.setReportExecutorClassName(elem.getAttribute("class"));
                        } else if ("inputProvider".equals(elem.getName())) {
                            info.setInputProviderClassName(elem.getAttribute("class"));
                        }
                        ++j;
                    }
                    String bundleName = ((RegistryContributor)ext.getContributor()).getName();
                    info.setBundleName(bundleName);
                    ReportsRepository.addReportInformation((int)Integer.valueOf(reportID), (ReportInformation)info);
                }
                ++i;
            }
        }
    }

    private void loadGroups() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ez.report.generation.common.report.group");
        if (config.length < 1) {
            System.out.println("no group defined with com.ez.report.generation.common.report.group extension");
        } else {
            int i = 0;
            while (i < config.length) {
                String att;
                IConfigurationElement ext = config[i];
                String id = ext.getAttribute("id");
                if (id != null && !id.isEmpty() && (att = ext.getAttribute("name")) != null && !att.isEmpty()) {
                    ReportGroupInformation info = new ReportGroupInformation(id, att);
                    att = ext.getAttribute("position");
                    if (att != null && !att.isEmpty()) {
                        try {
                            int pos = Integer.valueOf(att);
                            info.setPosition(Integer.valueOf(pos));
                        }
                        catch (NumberFormatException e) {
                            L.error("Error:", (Throwable)e);
                        }
                    }
                    ReportsRepository.addReportGroupInformation((ReportGroupInformation)info);
                }
                ++i;
            }
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }
}

