/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.ui;

import com.ez.common.ui.properties.AnalysisSelection;
import com.ez.eclient.configuration.Configuration;
import com.ez.eclient.configuration.service.ConfigurationService;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.LogUtil;
import com.ez.protection.Registry;
import com.ez.report.generation.common.GenerationStatus;
import com.ez.report.generation.common.ui.ReportAnalysis;
import com.ez.report.generation.common.ui.ReportExportProvider;
import com.ez.report.generation.common.ui.ReportInfoAdapter;
import com.ez.report.generation.common.ui.internal.Activator;
import com.ez.report.generation.common.ui.internal.Messages;
import com.ez.report.generation.common.ui.utils.Utils;
import com.ez.report.generation.common.utils.ReportsUtils;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.analysis.job.GraphTranslateJob;
import com.ez.workspace.analysis.job.SelectionJob;
import com.ez.workspace.model.EZWorkspace;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRSwapFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReportJob
extends AbstractAnalysisJob
implements CloseHook {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportJob.class);
    protected ReportInfoAdapter graphInfo = null;
    protected String info = null;
    private RefreshRunnable reportRunn;
    protected JasperPrint print;
    private JasperReport jasperReport;
    private Connection conn = null;
    protected Map params;
    private JRDataSource ds;
    protected EZEntityID id = null;
    protected Composite control = null;
    protected ReportMouseActionsHook mouseHook = new ReportMouseActionsHook();
    protected SelectionJob selectJob;
    protected String viewTabLabel = "";
    protected Map dsMap = new HashMap();

    public ReportJob(String info, EZEntityID id) {
        super(info);
        this.info = info;
        this.id = id;
        this.setUser(true);
        this.params = new HashMap();
        this.selectJob = new SelectionJob(id);
    }

    protected abstract void customizeJasperPrint(JasperPrint var1);

    protected IStatus run(IProgressMonitor monitor) {
        L.debug("making {}", (Object)this.info);
        IStatus status = Status.OK_STATUS;
        monitor.beginTask(Messages.getString(ReportJob.class, "generateReport.task.text"), 12000);
        monitor.subTask(Messages.getString(ReportJob.class, "generateReport.task.text"));
        L.debug("start run");
        try {
            InputStream reportStream = this.getReportStream();
            monitor.worked(1000);
            L.debug("before load object");
            this.jasperReport = (JasperReport)JRLoader.loadObject((InputStream)reportStream);
            monitor.worked(1000);
            L.debug("after load object");
            this.putBaseParameters();
            L.debug("after load base params");
            if (this.params == null) {
                this.params = new HashMap();
            } else {
                this.checkParams();
            }
            this.params.putAll(this.getReportParameters());
            monitor.worked(1000);
            L.debug("after load specific params");
            this.ds = this.getDataSource();
            monitor.worked(3000);
            L.debug("after getting datasource");
            if (!monitor.isCanceled()) {
                monitor.worked(500);
                this.checkParams();
            }
            if (!monitor.isCanceled()) {
                block17: {
                    Thread currentThread = Thread.currentThread();
                    ClassLoader oldLoader = currentThread.getContextClassLoader();
                    try {
                        try {
                            boolean useScriptlet = this.useScriptlet();
                            L.trace("{}.useScriptlet={}", ((Object)((Object)this)).getClass(), (Object)useScriptlet);
                            if (useScriptlet) {
                                currentThread.setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
                                L.trace("class loader changed to: {}", (Object)currentThread.getContextClassLoader());
                            }
                            JRProperties.setProperty((String)"net.sf.jasperreports.awt.ignore.missing.font", (String)Boolean.TRUE.toString());
                            if (this.ds == null) {
                                String swapFolder = Utils.getSwapFolderPath();
                                JRSwapFile swapFile = new JRSwapFile(swapFolder, 1024, 512);
                                JRSwapFileVirtualizer virtualizer = new JRSwapFileVirtualizer(100, swapFile, true);
                                this.params.put("REPORT_VIRTUALIZER", virtualizer);
                                this.print = JasperFillManager.fillReport((JasperReport)this.jasperReport, (Map)this.params, (Connection)this.conn);
                                virtualizer.setReadOnly(true);
                            } else {
                                this.print = JasperFillManager.fillReport((JasperReport)this.jasperReport, (Map)this.params, (JRDataSource)this.ds);
                            }
                        }
                        catch (Throwable e) {
                            L.trace("printing loader at error: {} \noldLoader: {}", (Object)currentThread.getContextClassLoader(), (Object)oldLoader);
                            L.error("error generating the report", e);
                            currentThread.setContextClassLoader(oldLoader);
                            L.trace("class loader changed back to: {}", (Object)currentThread.getContextClassLoader());
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        currentThread.setContextClassLoader(oldLoader);
                        L.trace("class loader changed back to: {}", (Object)currentThread.getContextClassLoader());
                        throw throwable;
                    }
                    currentThread.setContextClassLoader(oldLoader);
                    L.trace("class loader changed back to: {}", (Object)currentThread.getContextClassLoader());
                }
                monitor.worked(2500);
                this.customizeJasperPrint(this.print);
                monitor.worked(1000);
            }
            if (!monitor.isCanceled()) {
                status = this.callReportOutputProvider(monitor);
                monitor.worked(1900);
                this.analysis.jobFinished(null);
            } else {
                if (this.analysis != null) {
                    this.analysis.cancellRequest(null);
                }
                status = Status.CANCEL_STATUS;
            }
        }
        catch (JRException e) {
            L.error("jasper exception", (Throwable)e);
            LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(ReportJob.class, "jasper.Exception.log"), (String)Messages.getString(ReportJob.class, "jasper.exception.log.title"), (Plugin)Activator.getDefault(), (boolean)false);
            monitor.setCanceled(true);
            status = Status.CANCEL_STATUS;
        }
        monitor.done();
        return status;
    }

    protected IStatus callReportOutputProvider(IProgressMonitor pmonitor) {
        boolean showResults;
        IStatus st = Status.OK_STATUS;
        Object param = this.analysis.getContextValue("showResults");
        boolean bl = showResults = param != null ? (Boolean)param : true;
        if (!showResults) {
            ReportExportProvider outputProvider = new ReportExportProvider(true, false, false);
            outputProvider.setDocument(this.print);
            String filePath = (String)this.analysis.getContextValue("exportPath");
            outputProvider.setFilePath(filePath);
            String fileName = (String)this.analysis.getContextValue("exportFileName");
            outputProvider.setFileName(fileName);
            GenerationStatus stat = outputProvider.showResults(pmonitor);
            switch (stat) {
                case CANCELED: {
                    st = Status.CANCEL_STATUS;
                    break;
                }
                case ERROR: {
                    st = new Status(4, "com.ez.report.generation.common.ui", Messages.getString(ReportJob.class, "errorAtExport.statusMessage"));
                    break;
                }
            }
        } else {
            if (this.reportRunn == null) {
                this.reportRunn = new RefreshRunnable();
            }
            Display.getDefault().syncExec((Runnable)this.reportRunn);
        }
        return st;
    }

    protected void putBaseParameters() {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        Utils.addParametersFromPreferences(inputs);
        com.ez.report.generation.common.utils.Utils.setParamsForTitle((Map)this.params, inputs);
        String value = Messages.getString(ReportJob.class, "appendix.label");
        this.params.put("annexLbl", value);
        value = Messages.getString(ReportJob.class, "resources.summary.lbl");
        this.params.put("resourcesSummary", value);
        value = Messages.getString(ReportJob.class, "summary.lbl");
        this.params.put("summary", value);
        value = Messages.getString(ReportJob.class, "toc.title");
        this.params.put("toc.title", value);
        value = Messages.getString(ReportJob.class, "page.txt");
        this.params.put("page", value);
        value = Messages.getString(ReportJob.class, "of.txt");
        this.params.put("of", value);
        com.ez.report.generation.common.utils.Utils.putSubreportStream((String)"reports/HeadingsReport.jasper", (String)"headingsTemplate", (Map)this.params);
        this.params.put("showAppendix", Boolean.TRUE);
    }

    public void closing() {
        L.debug("report job {} is closing", (Object)this);
        EZWorkspace ws = EZWorkspace.getInstance();
        ws.removeJob(this.id, ((Object)((Object)this)).getClass(), (GraphTranslateJob)this);
        if (this.params != null) {
            this.params.clear();
            this.params = null;
        }
        this.ds = null;
        this.jasperReport = null;
        if (this.print != null && this.print.getStylesMap() != null) {
            this.print.getStylesMap().clear();
            this.print = null;
        }
        this.analysis = null;
        if (this.control != null) {
            this.control.dispose();
            this.control = null;
        }
        this.reportRunn = null;
        if (this.graphInfo != null) {
            this.graphInfo.dispose();
            this.graphInfo = null;
        }
    }

    public abstract String getReportTemplate();

    public InputStream getReportStream() {
        return this.getReportStream(null);
    }

    public InputStream getReportStream(String templateFilePath) {
        String fileName = templateFilePath == null ? this.getReportTemplate() : templateFilePath;
        Bundle bundle = Platform.getBundle((String)"com.ez.jasperreports");
        Path path = new Path(fileName);
        InputStream stream = null;
        URL[] files = FileLocator.findEntries((Bundle)bundle, (IPath)path);
        if (files != null && files.length > 0) {
            URL fileURL = files[0];
            try {
                stream = fileURL.openStream();
            }
            catch (IOException e) {
                L.error("error at loading template", (Throwable)e);
            }
        } else {
            L.warn("template report not found: {}", (Object)templateFilePath);
        }
        return stream;
    }

    public abstract Map getReportParameters();

    public void buildComponents(Composite composite) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        this.completeInfoAdapter(composite);
    }

    protected void completeInfoAdapter(Composite composite) {
        if (this.graphInfo != null) {
            this.graphInfo.setParent(composite);
            this.graphInfo.setMouseHook(this.mouseHook);
        }
    }

    public abstract JRDataSource getDataSource();

    public GraphInfo getGraphInfo() {
        return this.graphInfo;
    }

    public void init() {
        L.debug("init required");
        String className = this.analysis.getClass().getName();
        Registry reg = Registry.getInstance();
        boolean enabled = reg.check(className);
        if (enabled) {
            this.schedule();
        }
    }

    public boolean isDirty() {
        return false;
    }

    public void markAsDirty() {
        L.debug("dirty required");
    }

    public boolean belongsTo(Object family) {
        return "REPORT_JOB".equals(family);
    }

    public void addLocaleParameter(Map params) {
        ReportsUtils.addLocaleParameter((Map)params);
    }

    protected abstract boolean useScriptlet();

    protected void filterPages(JasperPrint jasperPrint) {
        List pages;
        if (jasperPrint != null && (pages = jasperPrint.getPages()) != null && pages.size() > 0) {
            ReportsUtils.removeEmptyPages((List)pages, (String)this.analysis.toString());
        }
    }

    protected void moveTableOfContents(JasperPrint jasperPrint) {
        this.moveTableOfContents(jasperPrint, false);
    }

    protected void moveTableOfContents(JasperPrint jasperPrint, boolean useAnchorIndexes) {
        ReportsUtils.moveTableOfContents((JasperPrint)jasperPrint, (boolean)useAnchorIndexes);
    }

    protected void modifiedPrevious(List pages, int i) {
        int j = 0;
        while (j < i) {
            JRPrintPage pg = (JRPrintPage)pages.get(j);
            List pgEls = pg.getElements();
            boolean elFound = false;
            if (pgEls != null && pgEls.size() > 0 && !elFound) {
                Iterator it3 = pgEls.iterator();
                while (it3.hasNext() && !elFound) {
                    JRPrintElement pgEl = (JRPrintElement)it3.next();
                    if (!(pgEl instanceof JRTemplatePrintFrame) || !"frmPageNr".equalsIgnoreCase(pgEl.getKey())) continue;
                    List subEls = ((JRTemplatePrintFrame)pgEl).getElements();
                    for (Object elem : subEls) {
                        if (!(elem instanceof JRPrintText) || !"txtTotalPages".equals(((JRPrintText)elem).getKey())) continue;
                        String str = ((JRPrintText)elem).getFullText();
                        int initValue = Integer.valueOf(str);
                        int newValue = initValue - 1;
                        L.debug("total nr changed again from {} to {}", (Object)initValue, (Object)String.valueOf(newValue));
                        ((JRPrintText)elem).setText(String.valueOf(newValue));
                        elFound = true;
                    }
                }
            }
            ++j;
        }
    }

    protected void checkParams() {
        L.trace("checking mandatory parameters");
        Object obj = this.params.get("REPORT_SCRIPTLET");
        L.trace("   JRParameter.REPORT_SCRIPTLET={}", obj);
        obj = this.params.get("scriptlet");
        L.trace("   scriptlet={}", obj);
        obj = this.params.get("headingsTemplate");
        L.trace("   headingsTemplate: {}", obj);
    }

    private class RefreshRunnable
    implements Runnable {
        private RefreshRunnable() {
        }

        @Override
        public void run() {
            ReportJob.this.graphInfo.setDocument(ReportJob.this.print);
            Configuration conf = ConfigurationService.getDefault().getConfiguration("analyses.reports");
            Boolean activateView = null;
            if (conf != null) {
                activateView = (Boolean)conf.getObject("reports.activateView");
            }
            if (activateView == null) {
                activateView = true;
            }
            if (activateView.booleanValue()) {
                IWorkbenchWindow window = null;
                IWorkbench workbench = PlatformUI.getWorkbench();
                int windowc = workbench.getWorkbenchWindowCount();
                if (windowc > 0) {
                    window = workbench.getActiveWorkbenchWindow();
                }
                if (window == null) {
                    L.warn("active window is null");
                    return;
                }
                try {
                    window.getActivePage().showView("com.ez.analysis.display.view.ReportsView", null, 1);
                }
                catch (PartInitException e) {
                    L.error("AnalysisView cannot be activated!", (Throwable)e);
                }
            }
        }
    }

    abstract class ReportAction
    extends Action {
        protected EZAnalysisType analysisType;
        protected EZObjectType objType = null;
        private Job job = new ActionJob();

        public ReportAction() {
            this.job.setUser(true);
        }

        public abstract void execute(IProgressMonitor var1);

        public void run() {
            this.job.setName(this.getText());
            this.job.schedule();
        }

        private class ActionJob
        extends Job {
            public ActionJob() {
                super("action job");
            }

            protected IStatus run(IProgressMonitor monitor) {
                ReportAction.this.execute(monitor);
                return Status.OK_STATUS;
            }
        }
    }

    public class ReportMouseActionsHook {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        public final String SHOW_PROPERTIES = Messages.getString(ReportJob.class, "showProperties.button");
        private ReportAction showProperties = null;

        public ReportAction getClickSelection() {
            if (this.showProperties == null) {
                this.showProperties = new ReportAction(ReportJob.this){

                    @Override
                    public void execute(IProgressMonitor monitor) {
                        monitor.beginTask(Messages.getString(ReportJob.class, "showProperty.task.text"), -1);
                        AnalysisSelection sel = new AnalysisSelection();
                        sel.setAnalysisName(ReportJob.this.analysis.getType().getName());
                        sel.setAnalysisType(((ReportAnalysis)ReportJob.this.analysis).getLabelType());
                        HashSet<String> names = ReportJob.this.analysis.getContextSetValue("inputs name string");
                        if (names == null || names.isEmpty()) {
                            String prj = (String)ReportJob.this.analysis.getContextValue("input_project_names");
                            names = new HashSet<String>();
                            names.add(prj);
                        }
                        sel.setInputs((Collection)names);
                        ((ReportMouseActionsHook)ReportMouseActionsHook.this).ReportJob.this.selectJob.setSelection((ISelection)new StructuredSelection((Object)sel));
                        ((ReportMouseActionsHook)ReportMouseActionsHook.this).ReportJob.this.selectJob.schedule();
                        monitor.done();
                    }
                };
            }
            this.showProperties.setText(this.SHOW_PROPERTIES);
            this.showProperties.setEnabled(true);
            return this.showProperties;
        }
    }
}

