/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.ui;

import com.ez.internal.id.EZEntityID;
import com.ez.report.generation.common.ExtraFileType;
import com.ez.report.generation.common.ui.AbstractExportCSVAction;
import com.ez.report.generation.common.ui.EZExportAsDocxAction;
import com.ez.report.generation.common.ui.EZExportAsPdfAction;
import com.ez.report.generation.common.ui.EZExportAsXlsAction;
import com.ez.report.generation.common.ui.EZPrintAction;
import com.ez.report.generation.common.ui.ExportAsRtfAction;
import com.ez.report.generation.common.ui.GoBackAction;
import com.ez.report.generation.common.ui.ReportIDSegment;
import com.ez.report.generation.common.ui.ReportJob;
import com.ez.report.generation.common.ui.internal.Messages;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.ReportViewer;
import com.jasperassistant.designer.viewer.StatusBar;
import com.jasperassistant.designer.viewer.actions.ExportMenuAction;
import com.jasperassistant.designer.viewer.actions.FirstPageAction;
import com.jasperassistant.designer.viewer.actions.LastPageAction;
import com.jasperassistant.designer.viewer.actions.NextPageAction;
import com.jasperassistant.designer.viewer.actions.PageNumberContributionItem;
import com.jasperassistant.designer.viewer.actions.PreviousPageAction;
import com.jasperassistant.designer.viewer.actions.ZoomActualSizeAction;
import com.jasperassistant.designer.viewer.actions.ZoomComboContributionItem;
import com.jasperassistant.designer.viewer.actions.ZoomFitPageAction;
import com.jasperassistant.designer.viewer.actions.ZoomFitPageWidthAction;
import com.jasperassistant.designer.viewer.actions.ZoomInAction;
import com.jasperassistant.designer.viewer.actions.ZoomOutAction;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.fill.JRTemplatePrintText;
import net.sf.jasperreports.view.JRHyperlinkListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportInfoAdapter
extends GraphInfoAdapter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ReportInfoAdapter.class);
    private Composite ctrl;
    protected ReportViewer reportViewer;
    private Composite parent;
    private ToolBarManager tbManager;
    private ReportJob.ReportMouseActionsHook mouseHook;
    private GoBackAction gba;
    private EZExportAsPdfAction pdfAction;
    private ExportAsRtfAction rtfAction;
    protected ExportMenuAction exportMenu;
    protected EZExportAsXlsAction xlsAction;
    private EZExportAsDocxAction docxAction;
    private AbstractExportCSVAction csvAction;
    private boolean closed = false;
    private ArrayList<Runnable> closeHandlers;
    MouseAdapter mouseLst;

    public ReportInfoAdapter(EZEntityID id) {
        super(id);
    }

    public Image getImage() {
        return null;
    }

    public Composite getControl() {
        if (this.ctrl == null) {
            this.buildControl();
        }
        return this.ctrl;
    }

    public Component getCanvasComponent() {
        return null;
    }

    public Composite buildControl() {
        if (this.ctrl == null) {
            this.ctrl = new Composite(this.parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginWidth = 2;
            layout.marginWidth = 2;
            layout.verticalSpacing = 2;
            this.ctrl.setLayout((Layout)layout);
            this.reportViewer = new ReportViewer(2048);
            this.tbManager = new ToolBarManager(0x800000);
            this.exportMenu = new ExportMenuAction((IReportViewer)this.reportViewer);
            this.pdfAction = this.instantiateExportPDFAction();
            this.pdfAction.setFileName(this.getDefaultExportFileName());
            this.exportMenu.getMenuManager().add((IAction)this.pdfAction);
            this.rtfAction = this.instantiateExportRtfAction();
            this.rtfAction.setFileName(this.getDefaultExportFileName());
            this.exportMenu.getMenuManager().add((IAction)this.rtfAction);
            this.xlsAction = this.instantiateXlsExportAction();
            this.xlsAction.setFileName(this.getDefaultExportFileName());
            this.exportMenu.getMenuManager().add((IAction)this.xlsAction);
            this.docxAction = this.instantiateExportDocxAction();
            this.docxAction.setFileName(this.getDefaultExportFileName());
            this.exportMenu.getMenuManager().add((IAction)this.docxAction);
            this.csvAction = this.instantiateCSVExportAction(this.reportViewer);
            if (this.csvAction != null) {
                this.csvAction.setFileName(this.getDefaultExportFileName());
                this.exportMenu.getMenuManager().add((IAction)this.csvAction);
            }
            this.exportMenu.setDefaultAction((IAction)this.pdfAction);
            this.tbManager.add((IAction)this.exportMenu);
            this.tbManager.add((IAction)new EZPrintAction((IReportViewer)this.reportViewer));
            L.info("SWT.getPlatform(): " + SWT.getPlatform());
            this.tbManager.add((IContributionItem)new Separator());
            this.tbManager.add((IAction)new FirstPageAction((IReportViewer)this.reportViewer));
            this.tbManager.add((IAction)new PreviousPageAction((IReportViewer)this.reportViewer));
            this.tbManager.add((IContributionItem)new PageNumberContributionItem((IReportViewer)this.reportViewer){

                public void fill(ToolBar parent, int index) {
                    ToolItem[] itms;
                    super.fill(parent, index);
                    ToolItem[] toolItemArray = itms = parent.getItems();
                    int n = itms.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ToolItem itm = toolItemArray[n2];
                        if (itm.getControl() instanceof Text) {
                            Text text = (Text)itm.getControl();
                            text.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                                public void getName(AccessibleEvent e) {
                                    e.result = Messages.getString(ReportInfoAdapter.class, "PageNumberContributorItem.descript");
                                }
                            });
                            break;
                        }
                        ++n2;
                    }
                }
            });
            this.tbManager.add((IAction)new NextPageAction((IReportViewer)this.reportViewer));
            this.tbManager.add((IAction)new LastPageAction((IReportViewer)this.reportViewer));
            this.tbManager.add((IContributionItem)new Separator());
            this.tbManager.add((IAction)new ZoomActualSizeAction((IReportViewer)this.reportViewer));
            this.tbManager.add((IAction)new ZoomFitPageAction((IReportViewer)this.reportViewer));
            this.tbManager.add((IAction)new ZoomFitPageWidthAction((IReportViewer)this.reportViewer));
            this.tbManager.add((IContributionItem)new Separator());
            this.gba = new GoBackAction((IReportViewer)this.reportViewer);
            this.tbManager.add((IAction)this.gba);
            this.tbManager.add((IContributionItem)new Separator());
            this.tbManager.add((IAction)new ZoomOutAction((IReportViewer)this.reportViewer));
            this.tbManager.add((IContributionItem)new ZoomComboContributionItem((IReportViewer)this.reportViewer){

                public void handleEvent(Event event) {
                    if (event.type != 13 || event.stateMask != 0) {
                        super.handleEvent(event);
                    }
                }

                public void fill(ToolBar parent, int index) {
                    ToolItem[] itms;
                    super.fill(parent, index);
                    ToolItem[] toolItemArray = itms = parent.getItems();
                    int n = itms.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ToolItem itm = toolItemArray[n2];
                        if (itm.getControl() instanceof Combo) {
                            Combo combo = (Combo)itm.getControl();
                            combo.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                                public void getName(AccessibleEvent e) {
                                    e.result = Messages.getString(ReportInfoAdapter.class, "ZoomComboContributionItem.descript");
                                }
                            });
                            break;
                        }
                        ++n2;
                    }
                }
            });
            this.tbManager.add((IAction)new ZoomInAction((IReportViewer)this.reportViewer));
            ToolBar toolbar = this.tbManager.createControl(this.ctrl);
            GridData gd = new GridData(768);
            toolbar.setLayoutData((Object)gd);
            Control reportViewerControl = this.reportViewer.createControl(this.ctrl);
            reportViewerControl.setLayoutData((Object)new GridData(1808));
            this.addMouseListener(reportViewerControl);
            this.addHyperlinkListeners();
            StatusBar statusBar = new StatusBar();
            statusBar.setReportViewer((IReportViewer)this.reportViewer);
            Control statusBarControl = statusBar.createControl(this.ctrl);
            statusBarControl.setLayoutData((Object)new GridData(768));
            this.ctrl.computeSize(-1, -1);
            toolbar.pack(true);
            this.ctrl.pack();
            this.ctrl.setVisible(true);
        }
        return this.ctrl;
    }

    protected void addMouseListener(Control reportViewerControl) {
        if (this.mouseLst == null) {
            this.mouseLst = new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (e.count == 1 && e.button == 1) {
                        if (ReportInfoAdapter.this.mouseHook != null) {
                            ReportJob.ReportAction act = ReportInfoAdapter.this.mouseHook.getClickSelection();
                            act.run();
                        } else {
                            L.warn("mouseHook is null for job " + (Object)((Object)this));
                        }
                    }
                    super.mouseUp(e);
                }
            };
        }
        reportViewerControl.addMouseListener((MouseListener)this.mouseLst);
    }

    protected void addHyperlinkListeners() {
        this.reportViewer.addHyperlinkListener(new JRHyperlinkListener(){

            public void gotoHyperlink(JRPrintHyperlink hyperlink) throws JRException {
                if (hyperlink instanceof JRTemplatePrintText) {
                    String anchorName = ((JRTemplatePrintText)hyperlink).getAnchorName();
                    String hyperlinkName = ((JRTemplatePrintText)hyperlink).getHyperlinkAnchor();
                    L.debug("hyperlink [" + hyperlinkName + "] pressed");
                    L.debug("hyperlink is corresponding to anchor:" + anchorName);
                    if (anchorName != null) {
                        ReportInfoAdapter.this.registerAnchor(anchorName);
                    }
                }
            }
        });
    }

    public void updateInfoAdapter(GraphInfo cpy) {
        if (cpy instanceof ReportInfoAdapter) {
            ReportInfoAdapter copy = (ReportInfoAdapter)cpy;
            this.ctrl = copy.ctrl;
            this.tbManager = copy.tbManager;
            this.exportMenu = copy.exportMenu;
            this.pdfAction = copy.pdfAction;
            this.rtfAction = copy.rtfAction;
            this.xlsAction = copy.xlsAction;
            this.csvAction = copy.csvAction;
            this.docxAction = copy.docxAction;
            this.gba = copy.gba;
            this.image = copy.image;
            ReportViewer old = copy.reportViewer;
            if (old != null) {
                JRHyperlinkListener[] hypLst = old.getHyperlinkListeners();
                int i = 0;
                while (i < hypLst.length) {
                    JRHyperlinkListener lst = hypLst[i];
                    old.removeHyperlinkListener(lst);
                    ++i;
                }
                if (copy.mouseLst != null) {
                    old.getViewerCanvas().removeMouseListener((MouseListener)copy.mouseLst);
                }
            }
            old.unsetDocument(null);
            this.reportViewer = old;
            if (old != null) {
                this.addMouseListener((Control)this.reportViewer.getViewerCanvas());
                this.addHyperlinkListeners();
            }
            copy.reportViewer = null;
            copy.tbManager = null;
            copy.exportMenu = null;
            copy.pdfAction = null;
            copy.rtfAction = null;
            copy.xlsAction = null;
            copy.gba = null;
            copy.image = null;
            copy.ctrl = null;
        }
    }

    protected String getDefaultExportFileName() {
        String name = "";
        ReportIDSegment sg = (ReportIDSegment)this.id.getSegment(ReportIDSegment.class);
        EZAnalysis analysis = sg.getAnalysis();
        if (analysis != null && analysis.getType() != null) {
            name = analysis.getType().getName();
            if (name != null) {
                name = name.replaceAll("->", "VS");
                name = name.replaceAll("/", "__S__");
            } else {
                L.warn("null default file name for analysis: " + analysis);
            }
        } else {
            L.warn("null analysis or analysis type; no default file at export! " + analysis);
        }
        return name != null ? name : "";
    }

    protected AbstractExportCSVAction instantiateCSVExportAction(ReportViewer viewer) {
        return null;
    }

    protected EZExportAsXlsAction instantiateXlsExportAction() {
        return new EZExportAsXlsAction((IReportViewer)this.reportViewer);
    }

    protected ExportAsRtfAction instantiateExportRtfAction() {
        return new ExportAsRtfAction((IReportViewer)this.reportViewer);
    }

    protected EZExportAsDocxAction instantiateExportDocxAction() {
        return new EZExportAsDocxAction((IReportViewer)this.reportViewer);
    }

    protected EZExportAsPdfAction instantiateExportPDFAction() {
        return new EZExportAsPdfAction((IReportViewer)this.reportViewer);
    }

    public void setParent(Composite parent) {
        this.parent = parent;
    }

    public void setDocument(JasperPrint print) {
        if (this.reportViewer != null) {
            this.reportViewer.setDocument(print);
        }
    }

    public void setCtrl(Composite ctrl) {
        this.ctrl = ctrl;
    }

    public void dispose() {
        if (this.closeHandlers != null) {
            for (Runnable runn : this.closeHandlers) {
                try {
                    runn.run();
                }
                catch (Exception ex) {
                    L.error("error at close handler", (Throwable)ex);
                }
            }
        }
        if (this.ctrl != null) {
            this.ctrl.dispose();
            this.ctrl = null;
        }
        if (this.reportViewer != null) {
            JRHyperlinkListener[] listeners = this.reportViewer.getHyperlinkListeners();
            if (listeners != null) {
                int i = 0;
                while (i < listeners.length) {
                    this.reportViewer.removeHyperlinkListener(listeners[i]);
                    listeners[i] = null;
                    ++i;
                }
            }
            this.reportViewer = null;
        }
        if (this.tbManager != null) {
            this.tbManager.dispose();
            this.tbManager = null;
        }
        super.dispose();
    }

    public ReportJob.ReportMouseActionsHook getMouseHook() {
        return this.mouseHook;
    }

    public void setMouseHook(ReportJob.ReportMouseActionsHook mouseHook) {
        this.mouseHook = mouseHook;
    }

    protected void registerAnchor(String anchorName) {
        this.gba.setAnchorName(anchorName);
    }

    public ReportViewer getReportViewer() {
        return this.reportViewer;
    }

    public void setExportedFile(ExtraFileType type, String file) {
        this.addExportedFile(type, file);
    }

    public void setExportedFile(String file) {
        this.addExportedFile(ExtraFileType.GRAPH, file);
    }

    public void addExportedFile(ExtraFileType type, String file) {
        if (file != null) {
            switch (type) {
                case GRAPH: {
                    this.pdfAction.addExportedFile(file);
                    this.rtfAction.addExportedFile(file);
                    this.xlsAction.addExportedFile(file);
                    this.docxAction.addExportedFile(file);
                    break;
                }
                case CSV: {
                    if (this.csvAction == null) break;
                    this.csvAction.addExportedFile(file);
                }
            }
        }
    }

    public ISelectionListener getSelectionListener() {
        return null;
    }

    public void close() {
        this.closed = true;
    }

    public boolean wasClosed() {
        return this.closed;
    }

    public void addExportedFiles(Map<ExtraFileType, List<String>> files) {
        for (ExtraFileType type : files.keySet()) {
            this.addExportedFiles(type, files.get(type));
        }
    }

    public void addExportedFiles(ExtraFileType type, List<String> files) {
        if (files != null) {
            for (String file : files) {
                this.addExportedFile(type, file);
            }
        }
    }

    public void setCloseHandlers(List<Runnable> closeHandlers) {
        this.closeHandlers = new ArrayList<Runnable>(closeHandlers);
    }

    public boolean isReport() {
        return true;
    }
}

