/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.ui;

import com.ez.report.generation.common.GenerationStatus;
import com.ez.report.generation.common.ReportOutputProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportExportProvider
implements ReportOutputProvider {
    private static final Logger L = LoggerFactory.getLogger(ReportExportProvider.class);
    private JasperPrint print;
    private String filePath;
    private boolean exportPdf = false;
    private boolean exportRtf = false;
    private boolean exportXls = false;
    private String fileName;
    private List<String> exported = new ArrayList<String>();

    public ReportExportProvider(boolean exportPdf, boolean exportRtf, boolean exportXls) {
        this.exportPdf = exportPdf;
        this.exportRtf = exportRtf;
        this.exportXls = exportXls;
    }

    public GenerationStatus showResults(IProgressMonitor monitor) {
        GenerationStatus st = GenerationStatus.OK;
        if (this.exportPdf) {
            st = this.exportToPDF();
        }
        if (monitor.isCanceled()) {
            st = GenerationStatus.CANCELED;
        } else {
            if (st.isOK() && this.exportRtf) {
                st = this.exportToRtf();
            }
            if (monitor.isCanceled()) {
                st = GenerationStatus.CANCELED;
            } else if (st.isOK() && this.exportXls) {
                st = this.exportToXLS();
            }
        }
        return st;
    }

    private GenerationStatus exportToPDF() {
        GenerationStatus st = GenerationStatus.OK;
        try {
            String fName = this.getPathComplete(".pdf");
            File pdfFile = new File(fName);
            JRPdfExporter pdfExporter = new JRPdfExporter();
            pdfExporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.print);
            pdfExporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)pdfFile);
            pdfExporter.exportReport();
            L.info("report exported: " + pdfFile.getAbsolutePath());
            this.exported.add(fName);
        }
        catch (Throwable e) {
            L.error("error at exporting " + this.filePath + " into .PDF file", e);
            st = GenerationStatus.ERROR;
        }
        return st;
    }

    private GenerationStatus exportToXLS() {
        GenerationStatus st = GenerationStatus.OK;
        try {
            String fName = this.getPathComplete(".xls");
            File xlsFile = new File(fName);
            JRXlsExporter exporterXLS = new JRXlsExporter();
            exporterXLS.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.print);
            exporterXLS.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)xlsFile);
            exporterXLS.setParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, (Object)Boolean.TRUE);
            exporterXLS.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)Boolean.TRUE);
            exporterXLS.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_DETECT_CELL_TYPE, (Object)Boolean.TRUE);
            exporterXLS.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
            exporterXLS.setParameter((JRExporterParameter)JExcelApiExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.TRUE);
            exporterXLS.exportReport();
            this.exported.add(fName);
        }
        catch (Throwable e) {
            L.error("error at exporting " + this.filePath + " into .XLS file", e);
            st = GenerationStatus.ERROR;
        }
        return st;
    }

    private GenerationStatus exportToRtf() {
        GenerationStatus st = GenerationStatus.OK;
        try {
            JRRtfExporter exporter = new JRRtfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.print);
            String fName = this.getPathComplete(".rtf");
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)new File(fName));
            exporter.exportReport();
            this.exported.add(fName);
        }
        catch (Throwable e) {
            L.error("error at exporting " + this.filePath + " into .RTF file", e);
            st = GenerationStatus.ERROR;
        }
        return st;
    }

    private String getPathComplete(String fileExtension) {
        String p = this.filePath.endsWith(File.separator) ? this.filePath : this.filePath.concat(File.separator);
        p = p.concat(this.fileName).concat(fileExtension);
        return p;
    }

    public void setDocument(JasperPrint reportDocument) {
        this.print = reportDocument;
    }

    public void setFilePath(String path) {
        this.filePath = path;
    }

    public void setFileName(String fName) {
        this.fileName = fName;
    }

    public List<String> getOutputFiles() {
        return this.exported.isEmpty() ? null : this.exported;
    }
}

