/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.ui;

import com.ez.report.generation.common.ui.AbstractExportCSVAction;
import com.ez.report.generation.common.ui.internal.Messages;
import com.jasperassistant.designer.viewer.ReportViewer;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreGeneratedCSVExportAction
extends AbstractExportCSVAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(PreGeneratedCSVExportAction.class);

    public PreGeneratedCSVExportAction(ReportViewer reportViewer) {
        super(reportViewer);
    }

    @Override
    protected IStatus doSaveToCSV(IProgressMonitor pmonitor, String file) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        IStatus status = Status.OK_STATUS;
        if (this.exportedFile == null) {
            L.error("csv file was not generated!");
            status = new Status(4, "com.ez.report.generation.common.ui", Messages.getString(PreGeneratedCSVExportAction.class, "filenotavailable.status.message"));
        } else {
            monitor.worked(20);
            monitor.setTaskName(Messages.getString(PreGeneratedCSVExportAction.class, "writting.taskName", new String[]{file}));
            String csv = this.exportedFile;
            try {
                FileUtils.copyFile((File)new File(csv), (File)new File(file));
            }
            catch (IOException e) {
                L.error("csv file cannot be written to {}", (Object)file, (Object)e);
                status = new Status(4, "com.ez.report.generation.common.ui", Messages.getString(PreGeneratedCSVExportAction.class, "filenotwritten.status.message", new String[]{file}), (Throwable)e);
            }
            monitor.worked(80);
        }
        if (monitor.isCanceled()) {
            status = Status.CANCEL_STATUS;
        }
        return status;
    }
}

