/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.ui;

import com.ez.report.generation.common.ui.ExecExportStatus;
import com.ez.report.generation.common.ui.internal.Activator;
import com.ez.report.generation.common.ui.internal.Messages;
import com.ez.report.generation.common.utils.Utils;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportAsRtfAction
extends AbstractExportAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ExportAsRtfAction.class);
    protected List<String> exportedFiles = new ArrayList<String>();
    private ExecExportStatus st;
    private static final ImageDescriptor ICON = ImageDescriptor.createFromFile(Activator.class, (String)"/icons/rtf.png");
    private static final ImageDescriptor DISABLED_ICON = ImageDescriptor.createFromFile(Activator.class, (String)"/icons/rtf.png");

    public ExportAsRtfAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString(ExportAsRtfAction.class, "ExportAsRtfAction.label"));
        this.setToolTipText(Messages.getString(ExportAsRtfAction.class, "ExportAsRtfAction.tooltip"));
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(DISABLED_ICON);
        this.setFileExtensions(new String[]{"*.rtf"});
        this.setFilterNames(new String[]{Messages.getString(ExportAsRtfAction.class, "ExportAsRtfAction.filterName")});
        this.setDefaultFileExtension("rtf");
        this.st = new ExecExportStatus();
    }

    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        try {
            JRRtfExporter exporter = new JRRtfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.getReportViewer().getDocument());
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)file);
            exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, (Object)monitor);
            this.setAdditionalParameters(exporter);
            exporter.exportReport();
            List filePages = this.getReportViewer().getDocument().getPages();
            int i = 0;
            while (i < filePages.size()) {
                if (monitor != null) {
                    monitor.afterPageExport();
                }
                ++i;
            }
            this.postExport(file);
            this.st.exportFile = file.getAbsolutePath();
            this.st.exportStatus = 1;
        }
        catch (Throwable ex) {
            L.error("error at exporting report to rtf", ex);
            this.st.exportStatus = 2;
        }
        Display.getDefault().syncExec((Runnable)this.st);
    }

    protected void setAdditionalParameters(JRRtfExporter exporter) {
    }

    protected void postExport(File file) throws IOException {
        if (this.exportedFiles != null && !this.exportedFiles.isEmpty()) {
            for (String f : this.exportedFiles) {
                try {
                    String sourcePath = this.getGraphPath(f);
                    Utils.exportFile((String)f, (File)file, (String)sourcePath);
                }
                catch (IOException e) {
                    L.error("error at exporting report into .svg file: " + file, (Throwable)e);
                    throw e;
                }
            }
        }
    }

    protected String getGraphPath(String f) {
        return com.ez.internal.utils.Utils.getApplicationDefaultPath().concat(File.separator).concat(f);
    }

    public void setExportedFile(String file) {
        this.addExportedFile(file);
    }

    public void addExportedFile(String file) {
        this.exportedFiles.add(file);
    }
}

