/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.ui;

import com.ez.internal.utils.LogUtil;
import com.ez.report.generation.common.ui.ExecExportStatus;
import com.ez.report.generation.common.ui.internal.Activator;
import com.ez.report.generation.common.ui.internal.Messages;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.ExportAsSingleXlsAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZExportAsXlsAction
extends ExportAsSingleXlsAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZExportAsXlsAction.class);
    private static final ImageDescriptor ICON = Activator.getImageDescriptor("icons/xlsx.png");
    private ExecExportStatus st;
    public String[] sheetNames = null;
    protected List<String> exportedFiles = new ArrayList<String>();

    public EZExportAsXlsAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString(EZExportAsXlsAction.class, "exportAsXlsAction.label"));
        this.setToolTipText(Messages.getString(EZExportAsXlsAction.class, "exportAsXlsAction.tooltip"));
        this.setFileExtensions(new String[]{"*.xlsx"});
        this.setDefaultFileExtension("xlsx");
        this.setFilterNames(new String[]{Messages.getString(EZExportAsXlsAction.class, "exportAsXlsAction.filterName")});
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(ICON);
        this.st = new ExecExportStatus();
    }

    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        try {
            JRXlsxExporter exporter = new JRXlsxExporter();
            SimpleExporterInput exporterInput = new SimpleExporterInput(this.getReportViewer().getDocument());
            exporter.setExporterInput((ExporterInput)exporterInput);
            SimpleOutputStreamExporterOutput exporterOutput = new SimpleOutputStreamExporterOutput(file);
            exporter.setExporterOutput((ExporterOutput)exporterOutput);
            SimpleXlsxReportConfiguration configuration = new SimpleXlsxReportConfiguration();
            configuration.setOnePagePerSheet(Boolean.valueOf(false));
            configuration.setDetectCellType(Boolean.valueOf(true));
            configuration.setRemoveEmptySpaceBetweenRows(Boolean.valueOf(true));
            configuration.setIgnoreHyperlink(Boolean.valueOf(true));
            configuration.setWhitePageBackground(Boolean.valueOf(true));
            configuration.setFontSizeFixEnabled(Boolean.valueOf(true));
            configuration.setProgressMonitor(monitor);
            configuration.setOnePagePerSheet(Boolean.valueOf(false));
            configuration.setSheetNames(this.sheetNames);
            exporter.setConfiguration((ReportExportConfiguration)configuration);
            exporter.exportReport();
            this.postExport(file);
            this.st.exportFile = file.getAbsolutePath();
            this.st.exportStatus = 1;
        }
        catch (Throwable ex) {
            L.error("error at exporting report to xlsx", ex);
            LogUtil.displayErrorMessage((Throwable)ex.getCause(), (String)Messages.getString(EZExportAsXlsAction.class, "export.errorLog.message"), (String)Messages.getString(EZExportAsXlsAction.class, "export.errorLog.title"), (Plugin)Activator.getDefault(), (boolean)false);
            this.st.exportStatus = 2;
        }
        Display.getDefault().syncExec((Runnable)this.st);
    }

    protected void postExport(File file) throws IOException {
    }

    public void addExportedFile(String file) {
        this.exportedFiles.add(file);
    }

    public void setFileName(String fileName) {
        super.setFileName(fileName);
        if (this.sheetNames == null) {
            this.sheetNames = new String[]{fileName.trim()};
        }
    }
}

