/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.ui;

import com.ez.internal.utils.LogUtil;
import com.ez.report.generation.common.ui.ExecExportStatus;
import com.ez.report.generation.common.ui.internal.Activator;
import com.ez.report.generation.common.ui.internal.Messages;
import com.ez.report.generation.common.utils.Utils;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.ExportAsPdfAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZExportAsPdfAction
extends ExportAsPdfAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZExportAsPdfAction.class);
    private static final ImageDescriptor ICON = Activator.getImageDescriptor("icons/pdf.png");
    private ExecExportStatus st = null;
    protected List<String> exportedFiles = new ArrayList<String>();

    public EZExportAsPdfAction(IReportViewer viewer) {
        super(viewer);
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(ICON);
        this.setText(Messages.getString(EZExportAsPdfAction.class, "exportAsPdfAction.label"));
        this.setToolTipText(Messages.getString(EZExportAsPdfAction.class, "exportAsPdfAction.tooltip"));
        this.st = new ExecExportStatus();
    }

    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        try {
            JRPdfExporter exporter = new JRPdfExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.getReportViewer().getDocument());
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)file);
            exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, (Object)monitor);
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.FORCE_LINEBREAK_POLICY, (Object)Boolean.TRUE);
            String pdfProp = this.getReportViewer().getDocument().getProperty("pdf_metadata_author");
            if (pdfProp != null) {
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_AUTHOR, (Object)pdfProp);
            }
            if ((pdfProp = this.getReportViewer().getDocument().getProperty("pdf_metadata_title")) != null) {
                exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_TITLE, (Object)pdfProp);
            }
            this.setAdditionalParameters(exporter);
            exporter.exportReport();
            this.postExport(file);
            this.st.exportFile = file.getAbsolutePath();
            this.st.exportStatus = 1;
        }
        catch (Throwable ex) {
            L.error("error at exporting report to pdf", ex);
            LogUtil.displayErrorMessage((Throwable)ex.getCause(), (String)Messages.getString(EZExportAsPdfAction.class, "export.errorLog.message"), (String)Messages.getString(EZExportAsPdfAction.class, "export.errorLog.title"), (Plugin)Activator.getDefault(), (boolean)false);
            this.st.exportStatus = 2;
        }
        Display.getDefault().syncExec((Runnable)this.st);
    }

    protected void postExport(File file) throws IOException {
        if (this.exportedFiles != null) {
            for (String f : this.exportedFiles) {
                try {
                    String sourcePath = this.getGraphPath(f);
                    Utils.exportFile((String)f, (File)file, (String)sourcePath);
                }
                catch (IOException e) {
                    L.error("exporting {}", (Object)f, (Object)e);
                    throw e;
                }
            }
        }
    }

    protected String getGraphPath(String f) {
        return com.ez.internal.utils.Utils.getApplicationDefaultPath().concat(File.separator).concat(f);
    }

    protected void setAdditionalParameters(JRPdfExporter exporter) {
    }

    public void setExportedFile(String file) {
        this.addExportedFile(file);
    }

    public void addExportedFile(String file) {
        this.exportedFiles.add(file);
    }
}

