/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.ui;

import com.ez.internal.utils.LogUtil;
import com.ez.report.generation.common.ui.ExecExportStatus;
import com.ez.report.generation.common.ui.internal.Activator;
import com.ez.report.generation.common.ui.internal.Messages;
import com.ez.report.generation.common.utils.Utils;
import com.jasperassistant.designer.viewer.IReportViewer;
import com.jasperassistant.designer.viewer.actions.AbstractExportAction;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.ooxml.JRDocxExporter;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EZExportAsDocxAction
extends AbstractExportAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZExportAsDocxAction.class);
    private static final ImageDescriptor ICON = Activator.getImageDescriptor("icons/docx.png");
    private ExecExportStatus st;
    public String[] sheetNames = null;
    protected List<String> exportedFiles = new ArrayList<String>();

    public EZExportAsDocxAction(IReportViewer viewer) {
        super(viewer);
        this.setText(Messages.getString(EZExportAsDocxAction.class, "exportAsDocxAction.label"));
        this.setToolTipText(Messages.getString(EZExportAsDocxAction.class, "exportAsDocxAction.tooltip"));
        this.setFileExtensions(new String[]{"*.docx"});
        this.setDefaultFileExtension("docx");
        this.setFilterNames(new String[]{Messages.getString(EZExportAsDocxAction.class, "exportAsDocxAction.filterName")});
        this.setImageDescriptor(ICON);
        this.setDisabledImageDescriptor(ICON);
        this.st = new ExecExportStatus();
    }

    protected void exportWithProgress(File file, JRExportProgressMonitor monitor) throws JRException {
        try {
            JRDocxExporter exporter = new JRDocxExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)this.getReportViewer().getDocument());
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE, (Object)file);
            exporter.setParameter(JRExporterParameter.PROGRESS_MONITOR, (Object)monitor);
            this.setAdditionalParameters(exporter);
            exporter.exportReport();
            this.postExport(file);
            this.st.exportFile = file.getAbsolutePath();
            this.st.exportStatus = 1;
        }
        catch (Throwable ex) {
            L.error("error at exporting report to docx", ex);
            LogUtil.displayErrorMessage((Throwable)ex.getCause(), (String)Messages.getString(EZExportAsDocxAction.class, "export.errorLog.message"), (String)Messages.getString(EZExportAsDocxAction.class, "export.errorLog.title"), (Plugin)Activator.getDefault(), (boolean)false);
            this.st.exportStatus = 2;
        }
        Display.getDefault().syncExec((Runnable)this.st);
    }

    protected void postExport(File file) throws IOException {
        if (this.exportedFiles != null) {
            for (String f : this.exportedFiles) {
                try {
                    String sourcePath = this.getGraphPath(f);
                    Utils.exportFile((String)f, (File)file, (String)sourcePath);
                }
                catch (IOException e) {
                    L.error("exporting {}", (Object)f, (Object)e);
                    throw e;
                }
            }
        }
    }

    protected String getGraphPath(String f) {
        return com.ez.internal.utils.Utils.getApplicationDefaultPath().concat(File.separator).concat(f);
    }

    protected void setAdditionalParameters(JRDocxExporter exporter) {
    }

    public void setExportedFile(String file) {
        this.addExportedFile(file);
    }

    public void addExportedFile(String file) {
        this.exportedFiles.add(file);
    }
}

