/*
 * Decompiled with CFR 0.152.
 */
package com.ez.report.generation.common.ui;

import com.ez.report.generation.common.ui.ExecExportStatus;
import com.ez.report.generation.common.ui.internal.Activator;
import com.ez.report.generation.common.ui.internal.Messages;
import com.jasperassistant.designer.viewer.ReportViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExportCSVAction
extends Action {
    private static final Logger L = LoggerFactory.getLogger(AbstractExportCSVAction.class);
    private static final ImageDescriptor ICON = Activator.getImageDescriptor("icons/csv.png");
    private String fileName;
    private ReportViewer reportViewer;
    protected String exportedFile = null;

    public AbstractExportCSVAction(ReportViewer reportViewer) {
        this.reportViewer = reportViewer;
        this.setImageDescriptor(ICON);
        this.setText(Messages.getString(AbstractExportCSVAction.class, "export.csv.label"));
        this.setToolTipText(Messages.getString(AbstractExportCSVAction.class, "export.csv.tooltip"));
    }

    public void setFileName(String defaultExportFileName) {
        this.fileName = defaultExportFileName;
    }

    public void run() {
        String file;
        FileDialog fd = new FileDialog(Display.getDefault().getActiveShell(), 8192);
        fd.setFilterExtensions(new String[]{"*.csv"});
        fd.setFileName(this.fileName);
        fd.setFilterNames(new String[]{Messages.getString(AbstractExportCSVAction.class, "export.csv.filterName")});
        String fileTmp = fd.open();
        L.debug("fileName: {}", (Object)fileTmp);
        if (fileTmp != null && !fileTmp.endsWith(".csv")) {
            fileTmp = fileTmp.concat(".csv");
        }
        if ((file = fileTmp) != null) {
            L.debug("save to: {}", (Object)file);
            Job toCSV = new Job(Messages.getString(AbstractExportCSVAction.class, "exporting.jobName")){

                protected IStatus run(IProgressMonitor monitor) {
                    ExecExportStatus ees = new ExecExportStatus();
                    ees.exportFile = file;
                    IStatus status = AbstractExportCSVAction.this.doSaveToCSV(monitor, file);
                    ees.exportStatus = status.equals(Status.OK_STATUS) ? 1 : 2;
                    Display.getDefault().asyncExec((Runnable)ees);
                    return status;
                }
            };
            toCSV.schedule();
        }
    }

    protected abstract IStatus doSaveToCSV(IProgressMonitor var1, String var2);

    public void addExportedFile(String file) {
        this.exportedFile = file;
    }
}

