/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.model;

import com.ez.internal.analysis.config.inputs.EZCProject;
import com.ez.internal.analysis.config.inputs.EZCSharpProject;
import com.ez.internal.analysis.config.inputs.EZJavaProject;
import com.ez.internal.analysis.config.inputs.EZJdtProject;
import com.ez.internal.analysis.config.inputs.EZNwProject;
import com.ez.internal.analysis.config.inputs.EZProjectInputType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.analysis.config.inputs.UnhandledProjectInputType;
import com.ez.mainframe.model.internal.Messages;

public enum ProjectType {
    abap("com.ez.abap.project.nature", new EZProjectInputType(), "Abap"),
    java("com.ez.java.project.ezjavanature", (EZProjectInputType)new EZJavaProject(), "Java"),
    javaWazi("com.ez.java.project.ezjavanature", (EZProjectInputType)new EZJavaProject(), "Java"),
    c("com.ez.c.project.nature", (EZProjectInputType)new EZCProject(), "C"),
    csharp("com.ez.csharp.project.nature", (EZProjectInputType)new EZCSharpProject(), "C#"),
    nw("com.ez.nw.project.WebDynproNature", (EZProjectInputType)new EZNwProject(), "Netweaver"),
    jdt("org.eclipse.jdt.core.javanature", (EZProjectInputType)new EZJdtProject(), true, "JDT"),
    zos("", (EZProjectInputType)new EZSourceProjectInputType(), "z/OS"),
    vme("", (EZProjectInputType)new EZSourceProjectInputType(), "VME"),
    vse("", (EZProjectInputType)new EZSourceProjectInputType(), "VSE"),
    smart("", (EZProjectInputType)new EZSourceProjectInputType(), "SMART AS/400"),
    mainframe("", (EZProjectInputType)new EZSourceProjectInputType(), "Mainframe"),
    other("", (EZProjectInputType)new UnhandledProjectInputType(), true, Messages.getString(ProjectType.class, "projectType.name.other"));

    private String nature;
    private EZProjectInputType objectType;
    private boolean nonEZ;
    private String typeName;

    private ProjectType(String nature, EZProjectInputType objectType, boolean nonEZ, String typeName) {
        this.nature = nature;
        this.objectType = objectType;
        this.nonEZ = nonEZ;
        this.typeName = typeName;
    }

    private ProjectType(String nature, EZProjectInputType objectType, String typeName) {
        this(nature, objectType, false, typeName);
    }

    public String getNature() {
        return this.nature;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public EZProjectInputType getObjectType() {
        return (EZProjectInputType)this.objectType.copy();
    }

    public boolean isEZ() {
        return !this.nonEZ;
    }
}

