/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.model;

import com.ez.mainframe.model.ProjectType;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectInfo
implements Comparable<ProjectInfo> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ProjectInfo.class);
    public static final String DRIVE = "drive";
    public static final String PROJECT_NAME = "projectName";
    public static final String PROJECT_LOCATION = "projectLocation";
    public static final String ENVIRONMENT = "environment";
    public static final String LANGUAGES = "languages";
    public static final String DB_TYPES = "dbTypes";
    public static final String MAP_TYPES = "mapTypes";
    public static final String IS_UCMDB = "isUCMDB";
    public static final String DB_ENGINE = "dbEngine";
    public static final String ON_MAINFRAME = "onMainframe";
    public static final String NO_DEFINITION = "noDefinition";
    public static final String SCHEMA_NAME = "schemaName";
    public static final String UUID = "ccs_uuid";
    public static final String METADATA = "project_metadata";
    public static final String USECROSS = "useCross";
    private IProject prj;
    private ProjectType type;
    private boolean eclipse;
    private String name;
    private ImageDescriptor descriptor;
    private Map<String, Object> info;
    private String description;
    private String metadataKeys;
    private Map<String, Object> metadataTable;

    public String getInform() {
        Boolean isUcmdb = false;
        String env = "";
        String langpart = "";
        if (this.info != null) {
            isUcmdb = (Boolean)this.info.get(IS_UCMDB);
            env = (String)this.info.get(ENVIRONMENT);
            env = env == null ? "" : env;
            List languages = (List)this.info.get(LANGUAGES);
            if (languages != null && !languages.isEmpty()) {
                StringBuilder langbuf = new StringBuilder(" (");
                TreeSet set = new TreeSet(languages);
                boolean first = true;
                for (String lang : set) {
                    if (!first) {
                        langbuf.append(", ");
                    } else {
                        first = false;
                    }
                    langbuf.append(lang);
                }
                langbuf.append(")");
                langpart = langbuf.toString();
            }
        }
        if (isUcmdb == null) {
            isUcmdb = false;
        }
        StringBuilder sb = new StringBuilder();
        if (this.info != null) {
            sb.append(env);
            if (isUcmdb.booleanValue()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("multi app");
            }
            if (sb.length() > 0 && !langpart.isEmpty()) {
                sb.append("; ");
            }
            sb.append(langpart);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (obj instanceof ProjectInfo) {
            if (obj == this) {
                equals = true;
            } else {
                boolean nameEquals = this.name == null && ((ProjectInfo)obj).getName() == null ? true : (this.name != null && ((ProjectInfo)obj).getName() != null ? this.name.equals(((ProjectInfo)obj).getName()) : false);
                boolean typeEquals = this.type == null && ((ProjectInfo)obj).getType() == null ? true : (this.type != null && ((ProjectInfo)obj).getType() != null ? this.type.equals((Object)((ProjectInfo)obj).getType()) : false);
                equals = nameEquals && typeEquals;
            }
        } else {
            equals = false;
        }
        return equals;
    }

    public int hashCode() {
        return this.name.hashCode() + this.type.hashCode();
    }

    @Override
    public int compareTo(ProjectInfo o2) {
        if (o2 == null) {
            return 1;
        }
        if (this.name == null && o2.getName() == null) {
            return 0;
        }
        if (this.name == null) {
            return -1;
        }
        if (o2.getName() == null) {
            return 1;
        }
        return this.name.compareToIgnoreCase(o2.getName());
    }

    public String toString() {
        return "ProjectInfo [prj=" + this.prj + ", type=" + (Object)((Object)this.type) + ", isEclipse=" + this.isEclipse() + ", name=" + this.name + ", descriptor=" + this.descriptor + ", info=" + this.info + "]";
    }

    public boolean hasDefinition() {
        boolean ret = true;
        Object noDef = this.info.get(NO_DEFINITION);
        ret = noDef == null || (Boolean)noDef == false;
        return ret;
    }

    public boolean isVME() {
        return ProjectType.vme.equals((Object)this.type);
    }

    public boolean isIDMSXDbVMEProject() {
        List dbtypes = (List)this.info.get(DB_TYPES);
        return ProjectType.vme.equals((Object)this.type) && dbtypes.contains("IDMSX");
    }

    public boolean isZOS() {
        return ProjectType.zos.equals((Object)this.type);
    }

    public IProject getPrj() {
        return this.prj;
    }

    public void setPrj(IProject prj) {
        this.prj = prj;
    }

    public ProjectType getType() {
        return this.type;
    }

    public void setType(ProjectType type) {
        this.type = type;
    }

    public boolean isEclipse() {
        return this.eclipse;
    }

    public void setEclipse(boolean eclipse) {
        this.eclipse = eclipse;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ImageDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ImageDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setInfo(Map<String, Object> info) {
        this.info = info;
    }

    public Map<String, Object> getInfo() {
        return this.info;
    }

    public String getUUID() {
        Object id = this.info.get(UUID);
        return id != null ? id.toString() : null;
    }

    public String getMetadataKeys() {
        return this.metadataKeys;
    }

    public void setMetadataKeys(String metadataKeys) {
        this.metadataKeys = metadataKeys;
    }

    public Map<String, Object> getMetadataTable() {
        return this.metadataTable;
    }

    public void setMetadataTable(Map<String, Object> metadataTable) {
        this.metadataTable = metadataTable;
    }
}

