/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.oauth2.service.impl;

import com.ez.eclient.configuration.bootstrap.internal.Messages;
import com.ez.eclient.preferences.service.DynamicPreferencesService;
import com.ez.internal.utils.LogUtil;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.oauth2.AuthenticationEvent;
import com.ibm.ad.oauth2.AuthenticationStatusListener;
import com.ibm.ad.oauth2.MicroClient;
import com.ibm.ad.oauth2.configuration.SSOConfiguration;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import com.ibm.ad.oauth2.model.OAuth2Data;
import com.ibm.ad.oauth2.service.HTTPErrorHandler;
import com.ibm.ad.oauth2.service.SSOService;
import com.ibm.ad.oauth2.ui.ProgressRunn;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOServiceImpl
implements SSOService {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(SSOServiceImpl.class);
    private static final String READ_TIMEOUT_KEY = "ad.http.read.timeout";
    private static final String READ_TIMEOUT_DEF_VALUE = "10";
    private MicroClient client;
    private Boolean state = true;
    private Set<AuthenticationStatusListener> listeners = null;

    private MicroClient getClient() {
        return this.getClient(true);
    }

    private MicroClient getClient(boolean forceInit) {
        if (this.isValid()) {
            String val = System.getProperty("javax.net.ssl.trustStore");
            L.trace("javax.net.ssl.trustStore={}", (Object)val);
            System.out.println(">>>>>>>>>>>>>>>>>>> javax.net.ssl.trustStore=" + val);
            if (this.client == null && forceInit) {
                DynamicPreferencesService srv = this.getPrefsService();
                if (srv == null) {
                    L.error("no pref service available for now");
                    return null;
                }
                String callbackIP = srv.getString("general.auth.client.viewer.metadata", "authclient.callback", null, null);
                if (callbackIP == null) {
                    L.error("callback ip is not set in CCS! cannot continue!");
                } else {
                    L.trace("callback={}", (Object)callbackIP);
                    String clientID = srv.getString("general.auth.client.viewer.metadata", "authclient.id", null, null);
                    if (clientID == null) {
                        L.error("clientID is not set in CCS! cannot continue!");
                    } else {
                        L.trace("clientID={}", (Object)clientID);
                        String clientSecret = srv.getString("general.auth.client.viewer.metadata", "authclient.secret", null, null);
                        if (clientSecret == null) {
                            L.error("secret is not set in CCS! cannot continue!");
                        } else {
                            L.trace("client={}", (Object)clientSecret);
                            String authURI = srv.getString("general.auth.metadata", "authidentity.host", null, null);
                            if (authURI == null) {
                                L.error("authorization uri is not set in CCS! cannot continue!");
                            } else {
                                L.trace("authorization={}", (Object)authURI);
                                String discoveryURI = srv.getString("general.auth.metadata", "authidentity.discovery", null, null);
                                if (discoveryURI == null) {
                                    L.error("discovery is not set in CCS! cannot continue!");
                                } else {
                                    discoveryURI = String.valueOf(authURI) + "/" + discoveryURI;
                                    L.trace("discovery={}", (Object)discoveryURI);
                                    Long timeout = srv.getLong("general.auth.client.viewer.metadata", "authclient.timeout", 120L, null);
                                    OAuth2Data data = new OAuth2Data.Builder().withClientID(clientID).withClientSecret(clientSecret).withAuthIssuerURI(authURI).withRedirectURI(callbackIP).withDiscoveryURI(discoveryURI).withTimeout(timeout).build();
                                    this.client = new MicroClient();
                                    try {
                                        this.client.start(data);
                                    }
                                    catch (IOException | InterruptedException e) {
                                        L.error("client starting error", (Throwable)e);
                                        this.client = null;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            this.reportInvalidState();
        }
        return this.client;
    }

    private void reportInvalidState() {
        String log = "SSO service state is not consistent";
        String localizedMsg = Messages.getString(SSOServiceImpl.class, (String)"notconsistent.error.message");
        this.reportInvalidState(log, localizedMsg, true);
    }

    private void reportInvalidState(String logMsg, String localizedMsg, boolean showDialogError) {
        if (logMsg != null) {
            L.warn("{}", (Object)logMsg);
        }
        if (localizedMsg != null) {
            Status errorStatus = new Status(4, "com.ez.eclient.configuration.bootstrap", localizedMsg);
            LogUtil.displayErrorMessage((Status)errorStatus, (boolean)showDialogError);
        }
    }

    public boolean isAuthEnabled() {
        boolean ret = false;
        if (this.isValid()) {
            DynamicPreferencesService srv = this.getPrefsService();
            if (srv == null) {
                L.error("no pref service available for now; consider auth enabled");
                ret = true;
            } else {
                ret = srv.getBoolean("general.auth.metadata", "authidentity.enabled", SSOConfiguration.P_CONFIG_AUTH_ENABLED_DEFVAL.booleanValue(), null);
            }
        } else {
            L.info("SSO service state is not consistent; consider auth enabled");
            ret = true;
        }
        return ret;
    }

    private DynamicPreferencesService getPrefsService() {
        DynamicPreferencesService srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
        return srv;
    }

    public String getUser() throws Exception {
        L.error("method is deprecated and has no body now (token not parsed anymore on client)!");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateClient(boolean invalidate) {
        Boolean bl = this.state;
        synchronized (bl) {
            this.state = !invalidate;
            if (invalidate) {
                this.client = null;
            }
        }
        if (this.listeners != null) {
            AuthenticationEvent ev = new AuthenticationEvent(this.isValid() ? 4 : 3);
            for (AuthenticationStatusListener l : this.listeners) {
                l.onEvent(ev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid() {
        boolean b = true;
        Boolean bl = this.state;
        synchronized (bl) {
            b = this.state;
        }
        return b;
    }

    public boolean isAuthenticated() {
        return this.isValid() && this.client != null && !this.client.needAuth();
    }

    public void logout() {
        MicroClient mc;
        boolean ok = false;
        AuthenticationEvent ev = null;
        if (this.isValid() && (mc = this.getClient()) != null) {
            mc.logout();
            ok = true;
            ev = new AuthenticationEvent(2);
        }
        if (!ok) {
            String log = Messages.getString(SSOServiceImpl.class, (String)"logoutFailed.error.message");
            this.reportInvalidState(log, null, false);
            ev = new AuthenticationEvent(2);
        }
        if (this.listeners != null && ev != null) {
            for (AuthenticationStatusListener l : this.listeners) {
                l.onEvent(ev);
            }
        }
    }

    public void login() {
        boolean ok;
        block11: {
            MicroClient mc;
            ok = false;
            if (this.isValid() && (mc = this.getClient()) != null) {
                IProgressMonitor monitor;
                ProgressMonitorDialog pmd;
                ProgressRunn runn = null;
                try {
                    try {
                        if (mc.needAuth()) {
                            final Object doneLock = new Object();
                            final AuthenticationEvent[] ev = new AuthenticationEvent[1];
                            Thread check = new Thread(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    Object object = doneLock;
                                    synchronized (object) {
                                        try {
                                            doneLock.wait();
                                            if (SSOServiceImpl.this.listeners != null && ev[0] != null) {
                                                for (AuthenticationStatusListener l : SSOServiceImpl.this.listeners) {
                                                    l.onEvent(ev[0]);
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            L.error("error at notify auth listeners", (Throwable)e);
                                        }
                                    }
                                }
                            });
                            check.start();
                            runn = new ProgressRunn(this.getTimeout());
                            Thread th = new Thread((Runnable)runn);
                            th.start();
                            final ProgressRunn runnFinal = runn;
                            Thread logTh = new Thread(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    AuthenticationEvent event = null;
                                    try {
                                        mc.login();
                                        event = new AuthenticationEvent(0);
                                    }
                                    catch (Exception e) {
                                        L.error("could not login", (Throwable)e);
                                        event = new AuthenticationEvent(1);
                                    }
                                    ev[0] = event;
                                    Object object = doneLock;
                                    synchronized (object) {
                                        doneLock.notifyAll();
                                    }
                                    runnFinal.done();
                                }
                            });
                            logTh.start();
                            Thread checkCancel = new Thread(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run() {
                                    if (runnFinal != null) {
                                        while (!runnFinal.isDone()) {
                                            IProgressMonitor monitor;
                                            ProgressMonitorDialog pmd = runnFinal.getDialog();
                                            if (pmd != null && (monitor = pmd.getProgressMonitor()) != null && monitor.isCanceled()) {
                                                AuthenticationEvent event;
                                                ev[0] = event = new AuthenticationEvent(1);
                                                SSOServiceImpl.this.client.stop();
                                                SSOServiceImpl.this.client = null;
                                                break;
                                            }
                                            try {
                                                Thread.sleep(200L);
                                            }
                                            catch (InterruptedException e) {
                                                L.debug("error at notify after cancel at login", (Throwable)e);
                                            }
                                        }
                                    }
                                    Object object = doneLock;
                                    synchronized (object) {
                                        doneLock.notifyAll();
                                    }
                                }
                            });
                            checkCancel.start();
                        }
                        ok = true;
                    }
                    catch (Exception re) {
                        IProgressMonitor monitor2;
                        ProgressMonitorDialog pmd2;
                        L.error("error getting user", (Throwable)re);
                        if (runn != null && (pmd2 = runn.getDialog()) != null && (monitor2 = pmd2.getProgressMonitor()) != null && !monitor2.isCanceled()) {
                            monitor2.setCanceled(true);
                        }
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    IProgressMonitor monitor3;
                    ProgressMonitorDialog pmd3;
                    if (runn != null && (pmd3 = runn.getDialog()) != null && (monitor3 = pmd3.getProgressMonitor()) != null && !monitor3.isCanceled()) {
                        monitor3.setCanceled(true);
                    }
                    throw throwable;
                }
                if (runn != null && (pmd = runn.getDialog()) != null && (monitor = pmd.getProgressMonitor()) != null && !monitor.isCanceled()) {
                    monitor.setCanceled(true);
                }
            }
        }
        if (!ok) {
            String log = Messages.getString(SSOServiceImpl.class, (String)"loginFailed.error.message");
            this.reportInvalidState(log, null, false);
        }
    }

    private Long getTimeout() {
        Long timeout = 120L;
        DynamicPreferencesService srv = this.getPrefsService();
        if (srv == null) {
            L.warn("no pref service available to read timeout; default value ({}) it will be used", (Object)timeout);
        } else {
            timeout = srv.getLong("general.auth.client.viewer.metadata", "authclient.timeout", 120L, null);
        }
        return timeout;
    }

    public void request(URL url, HttpResponseConsumer consumer) throws Exception {
        this.request(url, "GET", null, consumer, null);
    }

    public void request(URL url, String method, String info, HttpResponseConsumer consumer, HTTPErrorHandler handler) throws Exception {
        if (this.isAuthEnabled()) {
            if (this.client != null) {
                this.client.request(url.toString(), method, info, consumer);
            } else {
                String log = "client not instantiated";
                String errLog = Messages.getString(SSOServiceImpl.class, (String)"askAuthentication.error.message");
                this.reportInvalidState(log, errLog, false);
                consumer.setHttpCode(-401);
            }
        } else {
            HttpURLConnection conn = null;
            String readTimeoutstr = System.getProperty(READ_TIMEOUT_KEY, READ_TIMEOUT_DEF_VALUE);
            int readTimeout = Integer.valueOf(READ_TIMEOUT_DEF_VALUE);
            try {
                readTimeout = Integer.valueOf(readTimeoutstr);
            }
            catch (NumberFormatException ex) {
                L.info("wrong value of {}; default ({}sec) it will be used", new Object[]{READ_TIMEOUT_KEY, READ_TIMEOUT_DEF_VALUE, ex});
            }
            try {
                try {
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod(method);
                    conn.setRequestProperty("Accept", "application/json");
                    conn.setConnectTimeout(10000);
                    conn.setReadTimeout(readTimeout * 1000);
                    if (!"GET".equalsIgnoreCase(method)) {
                        conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                        conn.setDoOutput(true);
                        if (info != null) {
                            OutputStream os = conn.getOutputStream();
                            os.write(info.getBytes("UTF-8"));
                            os.close();
                        } else {
                            L.warn("null extra-info when call {} method!", (Object)method);
                        }
                    }
                    conn.connect();
                    boolean ok = true;
                    int respCode = conn.getResponseCode();
                    if (respCode != 200) {
                        ok = false;
                        L.error("bad request {}; response={}", (Object)url, (Object)respCode);
                        switch (respCode) {
                            case 401: 
                            case 403: {
                                String msg = Messages.getString(SSOServiceImpl.class, (String)"notauthorized.error.message");
                                LogUtil.displayErrorMessage((Status)new Status(4, "com.ez.eclient.configuration.bootstrap", msg), (boolean)false);
                            }
                        }
                    }
                    consumer.setHttpCode(respCode);
                    if (ok) {
                        String encoding = conn.getContentEncoding();
                        byte[] bb = this.readAndClose(conn.getInputStream());
                        String content = encoding != null ? new String(bb, encoding) : new String(bb);
                        consumer.accept(content);
                    } else if (handler != null) {
                        handler.execute(respCode, conn.getErrorStream());
                    }
                }
                catch (UnsupportedEncodingException e) {
                    L.error("Content with unsupported encoding received from direct request to {} ; check File Service configuration", (Object)url, (Object)e);
                    if (handler != null) {
                        handler.treatException((Exception)e);
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
                catch (Exception e) {
                    L.error("while doing direct request ({})", (Object)url, (Object)e);
                    if (handler != null) {
                        handler.treatException(e);
                    }
                    if (conn != null) {
                        conn.disconnect();
                    }
                }
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
    }

    byte[] readAndClose(InputStream input) {
        byte[] bucket = new byte[32768];
        ByteArrayOutputStream result = new ByteArrayOutputStream(bucket.length);
        try {
            try {
                int bytesRead = 0;
                while (bytesRead != -1) {
                    bytesRead = input.read(bucket);
                    if (bytesRead <= 0) continue;
                    result.write(bucket, 0, bytesRead);
                }
            }
            finally {
                input.close();
            }
        }
        catch (IOException ex) {
            L.warn("error reading input stream", (Throwable)ex);
        }
        return result.toByteArray();
    }

    public void addListener(AuthenticationStatusListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<AuthenticationStatusListener>();
        }
        this.listeners.add(listener);
    }
}

