/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.oauth2.configuration.config;

import com.ez.eclient.configuration.bootstrap.BootstrapParticipant;
import com.ez.eclient.configuration.bootstrap.Bootstrapper;
import com.ez.eclient.configuration.bootstrap.internal.Messages;
import com.ez.eclient.configuration.synchro.service.ConfigurationDescription;
import com.ez.eclient.configuration.synchro.service.ConfigurationEvent;
import com.ez.eclient.configuration.synchro.service.ConfigurationFormat;
import com.ez.eclient.configuration.synchro.service.ConfigurationListener;
import com.ez.eclient.configuration.synchro.service.EventType;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.oauth2.service.SSOService;
import com.ibm.ad.oauth2.service.impl.SSOServiceImpl;
import java.util.List;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationConfigurator
implements BootstrapParticipant {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(ConfigurationConfigurator.class);

    public void preConfigure(Properties properties) {
    }

    public void postConfigure(Bootstrapper bs) {
        bs.registerEclipseConfiguration(new ConfigurationDescription("general.auth.metadata", "common", null, null, ConfigurationFormat.Properties, false, Messages.getString(ConfigurationConfigurator.class, (String)"configuration.categoryName.auth"), Messages.getString(ConfigurationConfigurator.class, (String)"configuration.name.server")), null);
        bs.registerEclipseConfiguration(new ConfigurationDescription("general.auth.client.viewer.metadata", "common", null, null, ConfigurationFormat.Properties, false, Messages.getString(ConfigurationConfigurator.class, (String)"configuration.categoryName.auth"), Messages.getString(ConfigurationConfigurator.class, (String)"configuration.name.client")), null);
        bs.registerListener(new ConfigurationListener(){

            public void notifyEvent(List<ConfigurationEvent> el) {
                for (ConfigurationEvent e : el) {
                    String cfID = e.getConfigurationDescription().getUniqueId();
                    if (!"general.auth.metadata".equals(cfID) && !"general.auth.client.viewer.metadata".equals(cfID)) continue;
                    EventType evType = e.getType();
                    L.debug("event {} happen on configID={}", (Object)evType, (Object)cfID);
                    SSOService srv = (SSOService)ServiceUtils.getService(SSOService.class);
                    if (srv != null) {
                        if (evType == EventType.SyncAvailable) {
                            srv.invalidateClient(true);
                            continue;
                        }
                        if (evType == EventType.SyncApplied) {
                            srv.invalidateClient(false);
                            continue;
                        }
                        L.info("unknown event type: {}", (Object)evType);
                        continue;
                    }
                    L.warn("cannot find SSO service");
                }
            }
        });
        BundleContext bundleContext = FrameworkUtil.getBundle(SSOService.class).getBundleContext();
        if (bundleContext != null) {
            ServiceReference ss = bundleContext.getServiceReference(SSOService.class);
            if (ss == null) {
                bundleContext.registerService(SSOService.class, (Object)new SSOServiceImpl(), null);
            } else {
                L.debug("SSO service already registered");
            }
        } else {
            L.error("context is null! cannot registry SSO service in OSGI");
        }
    }
}

