/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.core.utils;

import com.ez.internal.utils.Pair;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.model.IGraphRestrictionsLegendInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class Utils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final String ENV_SETTINGS_KEY = "env";

    public static String replaceCharacters(String phrase) {
        if (phrase != null) {
            phrase = phrase.replaceAll("\\|", "\\\\");
        }
        return phrase;
    }

    public static String convertToODBPath(String phrase) {
        if (phrase != null) {
            phrase = phrase.replaceAll("\\\\", "\\|");
        }
        return phrase;
    }

    public static StringBuilder makeStringBuilder(Set prgSids) {
        return Utils.makeStringBuilder(prgSids, false);
    }

    public static StringBuilder makeStringBuilder(Set prgSids, boolean asString) {
        StringBuilder sbBackward = new StringBuilder();
        for (Object sid : prgSids) {
            if (sbBackward.length() > 0) {
                sbBackward.append(", ");
            }
            if (asString) {
                sbBackward.append("'" + sid + "'");
                continue;
            }
            sbBackward.append(sid);
        }
        return sbBackward;
    }

    public static Pair<String, String> splitDSid(String dsid) {
        int indexOf = dsid.indexOf("|");
        if (indexOf > 0) {
            String member = dsid.substring(indexOf + 1);
            String datasetName = dsid.substring(0, indexOf);
            return new Pair((Object)datasetName, (Object)member);
        }
        return new Pair((Object)dsid, null);
    }

    public static void addRestrictionMarkersToLegend(LegendPanel legend, Set<IGraphRestrictionsLegendInfo> restrictionTypesSetForLegend) {
        ArrayList<IGraphRestrictionsLegendInfo> restrictionTypesList = new ArrayList<IGraphRestrictionsLegendInfo>(restrictionTypesSetForLegend);
        Collections.sort(restrictionTypesList, new Comparator<IGraphRestrictionsLegendInfo>(){

            @Override
            public int compare(IGraphRestrictionsLegendInfo restrictType1, IGraphRestrictionsLegendInfo restrictType2) {
                return restrictType1.getLegendLabel().compareTo(restrictType2.getLegendLabel());
            }
        });
        for (IGraphRestrictionsLegendInfo restrictLegendInfo : restrictionTypesList) {
            legend.placeLegendEntry(restrictLegendInfo.getLegendImagePath(), restrictLegendInfo.getLegendLabel());
        }
    }
}

