/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.core.utils;

import com.ez.eclient.preferences.service.DynamicPreferencesService;
import com.ez.gdb.core.itf.IODBConnectionService;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.internal.PasswordUtils;
import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ConnectionUtils.class);
    public static final String CLIENT_SSL_ENABLED = "com.ibm.ad.client.ssl.enabled";

    public static boolean checkConnection(String connection, String user, String pass) {
        boolean connOk = false;
        try (OServerAdmin server = null;){
            try {
                server = new OServerAdmin(connection).connect(user, pass);
                connOk = true;
            }
            catch (Throwable t) {
                L.error("while testing orientdb connection {} for user {}", new Object[]{connection, user, t});
                if (server != null) {
                    server.close();
                }
            }
        }
        return connOk;
    }

    public static Properties getODBSettings(String prjName) {
        DynamicPreferencesService srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
        if (srv == null) {
            L.warn("graphDB cannot be configured!");
            return null;
        }
        String host = srv.getString("general.networking.graphdb", "graphdb.host", null, null);
        String port = srv.getString("general.networking.graphdb", "graphdb.port", "2424", null);
        String odbUser = srv.getString("general.networking.graphdb", "graphdb.username", null, null);
        String odbPass = srv.getString("general.networking.graphdb", "graphdb.password", null, null);
        odbPass = PasswordUtils.decrypt((String)odbPass);
        String connection = "remote:" + host + ":" + port + "/" + prjName;
        L.debug("orientdb connection: {} with user {}", (Object)connection, (Object)odbUser);
        Properties env = new Properties();
        env.put("gdb.connection", connection);
        env.put("db", "EZ_" + prjName);
        env.put("gdb.user", odbUser);
        env.put("gdb.pass", odbPass);
        return env;
    }

    public static OrientBaseGraph getNoTxGraph(Properties env) {
        String connection = env.getProperty("gdb.connection");
        String user = env.getProperty("gdb.user");
        String pass = env.getProperty("gdb.pass");
        IODBConnectionService service = (IODBConnectionService)ServiceUtils.getService(IODBConnectionService.class);
        return service.getNoTxGraph(connection, user, pass);
    }

    public static OrientBaseGraph getTxGraph(Properties env) {
        String connection = env.getProperty("gdb.connection");
        String user = env.getProperty("gdb.user");
        String pass = env.getProperty("gdb.pass");
        IODBConnectionService service = (IODBConnectionService)ServiceUtils.getService(IODBConnectionService.class);
        return service.getTxGraph(connection, user, pass);
    }

    public static void releaseGraph(OrientBaseGraph graph, Properties env) {
        try {
            String connection = env.getProperty("gdb.connection");
            String user = env.getProperty("gdb.user");
            String pass = env.getProperty("gdb.pass");
            IODBConnectionService service = (IODBConnectionService)ServiceUtils.getService(IODBConnectionService.class);
            service.releaseGraph(graph, connection, user, pass);
        }
        catch (Throwable t) {
            L.error("could not release odb graph", t);
        }
    }
}

