/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.core.ui;

import com.ez.common.model.BaseResourceInput;
import com.ez.gdb.core.collectors.ODBProgramCollector;
import com.ez.internal.utils.Pair;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBCallgraphWizard
extends PrepareReportWizard {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ODBCallgraphWizard.class);
    public static final String CHILDREN_QUERY = "children_query";
    public static final String PRGS_CHILDREN_PAGE_NAME = "children_page";

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage next = super.getNextPage(page);
        if (next != null && PRGS_CHILDREN_PAGE_NAME.equals(next.getName())) {
            Pair<String, List<BaseResourceInput>> tmp = this.prepareSelectedParents();
            String parentList = (String)tmp.getFirst();
            List proxies = (List)tmp.getSecond();
            if (parentList != null && !parentList.isEmpty() || !proxies.isEmpty()) {
                ODBProgramCollector asspc = (ODBProgramCollector)((SelectProgramsPage)next).getResourcesCollector();
                String query = (String)this.getValue(CHILDREN_QUERY);
                if (query == null) {
                    query = "select ifnull(out('ProxyFor')[0], @rid).asString() as prgrid, name, sid, type,  $p.full as path, $a.sid as ancsid, $a.name as ancname  from ProgramProxy \n let $a = out('Ancestor')[0], $p = out('ProxyFor')[0].out('SourceInfo')[0]  where aliasType = 0 and ( type = 15 or type = 16 or type = 1 ) ";
                }
                query = String.valueOf(query) + " and (";
                if (!parentList.isEmpty()) {
                    query = String.valueOf(query) + " $a.sid in list(?) ";
                    query = query.replace("?", parentList);
                    if (!proxies.isEmpty()) {
                        query = String.valueOf(query) + " OR ";
                    }
                }
                if (!proxies.isEmpty()) {
                    for (BaseResourceInput inpt : proxies) {
                        String s = "($a.name='" + inpt.getName() + "' and $a.type=" + inpt.getTypeCode() + ")";
                        query = String.valueOf(query) + s;
                        query = String.valueOf(query) + " OR ";
                    }
                    query = query.substring(0, query.length() - 4);
                }
                query = String.valueOf(query) + " ) ";
                L.trace("{}", (Object)query);
                asspc.setQuery(query);
            } else {
                next = null;
            }
        }
        return next;
    }

    public boolean canFinish() {
        boolean ret = false;
        if (this.getContainer().getCurrentPage() == this.getPage(PRGS_CHILDREN_PAGE_NAME) || this.getContainer().getCurrentPage() == this.getPage("programs for callgraph page") || this.getContainer().getCurrentPage() == this.getPage("tests page")) {
            ret = this.getContainer().getCurrentPage().isPageComplete();
        }
        return ret;
    }

    private Pair<String, List<BaseResourceInput>> prepareSelectedParents() {
        Pair ret = new Pair((Object)"", new ArrayList());
        String assemblerList = "";
        List selected = this.getList("selected resources");
        if (selected != null && !selected.isEmpty()) {
            for (BaseMainframeResource4GUI pi4GUI : selected) {
                ProgramInput pi = (ProgramInput)pi4GUI.getObject();
                Integer type = pi.getTypeCode();
                if (pi.getResourceID() == -1) {
                    ((List)ret.getSecond()).add(pi);
                    continue;
                }
                if (type != 8 && type != 1) continue;
                assemblerList = String.valueOf(assemblerList) + pi.getResourceID().toString() + ",";
            }
        }
        if (!assemblerList.isEmpty()) {
            ret.setFirst((Object)assemblerList.substring(0, assemblerList.length() - 1));
        }
        return ret;
    }
}

