/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.core.preferences.pages;

import com.ez.common.ui.guielements.PasswordFieldEditor;
import com.ez.common.ui.preferences.pages.EZFieldEditorPreferencePage;
import com.ez.eclient.preferences.service.DynamicPreferencesService;
import com.ez.eclient.preferences.ui.PreferenceStoreFactory;
import com.ez.gdb.core.internal.Messages;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.internal.PasswordUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalODBSettingsPage
extends EZFieldEditorPreferencePage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(GlobalODBSettingsPage.class);
    public static final String PAGE_ID = "com.ez.analysis.gdb.globalsettingspage";
    private StringFieldEditor hostFieldEditor;
    private IntegerFieldEditor portFieldEditor;
    private StringFieldEditor usrFieldEditor;
    private PasswordFieldEditor passwFieldEditor;
    private Button btnTestDb;

    public GlobalODBSettingsPage() {
        super(1);
        this.setDescription(Messages.getString(GlobalODBSettingsPage.class, "page.description"));
        this.globalStore = PreferenceStoreFactory.createServerPreferences((String)"general.networking.graphdb");
        this.setPreferenceStore(this.globalStore);
    }

    protected void createMainFieldEditors(Composite parent) {
        this.hostFieldEditor = new StringFieldEditor("graphdb.host", Messages.getString(GlobalODBSettingsPage.class, "host.label"), parent);
        this.addField((FieldEditor)this.hostFieldEditor);
        this.portFieldEditor = new IntegerFieldEditor("graphdb.port", Messages.getString(GlobalODBSettingsPage.class, "port.label"), parent);
        this.addField((FieldEditor)this.portFieldEditor);
        this.usrFieldEditor = new StringFieldEditor("graphdb.username", Messages.getString(GlobalODBSettingsPage.class, "user.label"), parent);
        this.addField((FieldEditor)this.usrFieldEditor);
        this.passwFieldEditor = new PasswordFieldEditor("graphdb.password", Messages.getString(GlobalODBSettingsPage.class, "passw.label"), parent){

            protected void doStore() {
                String t = this.getTextControl().getText();
                PasswordUtils.usePasswordV2 = true;
                String s = PasswordUtils.encrypt((String)t);
                this.getPreferenceStore().setValue(this.getPreferenceName(), s);
            }

            protected void doLoad() {
                if (this.getTextControl() != null) {
                    String value = this.getPreferenceStore().getString(this.getPreferenceName());
                    value = PasswordUtils.decrypt((String)value);
                    this.getTextControl().setText(value);
                    this.oldValue = value;
                }
            }

            public String getStringValue() {
                if (this.getTextControl() != null) {
                    return this.getTextControl().getText();
                }
                String pref = this.getPreferenceStore().getString(this.getPreferenceName());
                return PasswordUtils.decrypt((String)pref);
            }

            public void setStringValue(String value) {
                value = PasswordUtils.decrypt((String)value);
                Text textField = this.getTextControl();
                if (textField != null) {
                    if (value == null) {
                        value = "";
                    }
                    if (!textField.isDisposed()) {
                        this.oldValue = textField.getText();
                        if (!this.oldValue.equals(value)) {
                            textField.setText(value);
                            this.valueChanged();
                        }
                    }
                }
            }
        };
        this.addField((FieldEditor)this.passwFieldEditor);
        GridData gd = (GridData)this.mainArea.getLayoutData();
        gd.verticalAlignment = 128;
        gd.grabExcessVerticalSpace = false;
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                GlobalODBSettingsPage.this.verifySettings();
            }
        };
        this.btnTestDb = new Button(this.mainArea.getParent(), 8);
        this.btnTestDb.setText(Messages.getString(GlobalODBSettingsPage.class, "testConn.button"));
        this.btnTestDb.addSelectionListener(listener);
        gd = new GridData(131072, 0x1000000, true, false);
        gd.horizontalSpan = 3;
        this.btnTestDb.setLayoutData((Object)gd);
    }

    protected void disableContent() {
        super.disableContent();
        boolean enabled = this.isLocal == false || this.overwriteAllowed() != false && this.mainAreaSwitch.getBooleanValue();
        this.btnTestDb.setEnabled(enabled);
    }

    private void verifySettings() {
        final String host = this.hostFieldEditor.getStringValue();
        final String port = this.portFieldEditor.getStringValue();
        final String user = this.usrFieldEditor.getStringValue();
        final String passw = this.passwFieldEditor.getStringValue();
        final String connection = "remote:" + host + ":" + port;
        Job job = new Job(Messages.getString(GlobalODBSettingsPage.class, "testConnection.jobName")){

            protected IStatus run(IProgressMonitor monitor) {
                final boolean connOk = ConnectionUtils.checkConnection(connection, user, passw);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!connOk) {
                            GlobalODBSettingsPage.this.setErrorMessage(Messages.getString(GlobalODBSettingsPage.class, "testConnection.dialog.errorMessage", new String[]{String.valueOf(host) + ":" + port}));
                        } else {
                            MessageDialog.openInformation(null, (String)Messages.getString(GlobalODBSettingsPage.class, "testConnection.dialog.title"), (String)Messages.getString(GlobalODBSettingsPage.class, "testConnection.dialog.message", new String[]{connection}));
                            GlobalODBSettingsPage.this.setErrorMessage(null);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    public boolean okToLeave() {
        boolean changed = super.okToLeave();
        if (!changed) {
            final Shell shell = Display.getDefault().getActiveShell();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    boolean toSave = MessageDialog.openQuestion((Shell)shell, (String)Messages.getString(GlobalODBSettingsPage.class, "propertiesModified.dialog.title"), (String)Messages.getString(GlobalODBSettingsPage.class, "propertiesModified.dialog.text"));
                    if (toSave) {
                        GlobalODBSettingsPage.this.performApply();
                        L.info("new ODB settings saved in preferences");
                    }
                }
            });
        }
        return this.isValid();
    }

    private boolean checkChanges() {
        if (this.isLocal.booleanValue()) {
            String selValue;
            DynamicPreferencesService srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
            if (srv == null) {
                L.error("graphDB is not configured!");
                return false;
            }
            String prefValue = srv.getString("general.networking.graphdb", "graphdb.host", null, null);
            if (prefValue.equalsIgnoreCase(selValue = this.hostFieldEditor.getStringValue())) {
                prefValue = srv.getString("general.networking.graphdb", "graphdb.port", "2424", null);
                if (prefValue.equalsIgnoreCase(selValue = this.portFieldEditor.getStringValue())) {
                    prefValue = srv.getString("general.networking.graphdb", "graphdb.username", null, null);
                    if (prefValue.equalsIgnoreCase(selValue = this.usrFieldEditor.getStringValue())) {
                        prefValue = srv.getString("general.networking.graphdb", "graphdb.password", null, null);
                        if ((prefValue = PasswordUtils.decrypt((String)prefValue)).equalsIgnoreCase(selValue = this.passwFieldEditor.getStringValue())) {
                            return false;
                        }
                        L.debug("password was changed");
                    } else {
                        L.debug("user was changed");
                    }
                } else {
                    L.debug("odb port was changed");
                }
            } else {
                L.debug("odb host was changed");
            }
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench) {
    }

    protected String getGlobalPageID() {
        return null;
    }
}

