/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.core.itf.impl;

import com.ez.ezsource.versioning.ApplicationType;
import com.ez.gdb.core.itf.IODBConnectionService;
import com.ez.gdb.core.itf.impl.ODBAdminServiceImpl;
import com.ez.mainframe.projects.utils.ProjectUtils;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBConnectionServiceImpl
implements IODBConnectionService {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ODBAdminServiceImpl.class);
    private Map<String, OrientGraphFactory> factoryMap = new HashMap<String, OrientGraphFactory>();
    private Map<String, Integer> graphs = new HashMap<String, Integer>();
    private final int poolSize = Integer.parseInt(System.getProperty("orient.pool.size", "20"));
    private Object lock = new Object();
    private CloseIfIdle thread = new CloseIfIdle("odb watcher");

    public ODBConnectionServiceImpl() {
        this.thread.start();
    }

    public void shouldStop() {
        this.thread.shouldStop = true;
        this.thread.interrupt();
    }

    private String getKey(String connection, String user, String pass) {
        return String.valueOf(connection) + "|" + user + "|" + pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrientGraphFactory getFactory(String connection, String user, String pass) {
        OrientGraphFactory factory = null;
        boolean ok = false;
        try {
            String prjName = connection.substring(connection.lastIndexOf("/") + 1, connection.length());
            if (prjName == null || prjName.isEmpty()) {
                L.error("cannot determine project's name to check authorization (connection: {})", (Object)connection);
            } else {
                ok = ProjectUtils.checkProject((String)prjName, (ApplicationType)ApplicationType.EZViewer);
            }
        }
        catch (Exception e) {
            L.error("error trying to check project's authorization (connection: {})", (Object)connection, (Object)e);
        }
        if (ok) {
            String key = this.getKey(connection, user, pass);
            Object object = this.lock;
            synchronized (object) {
                factory = this.factoryMap.get(key);
                if (factory == null) {
                    if (connection.contains("remote")) {
                        factory = new OrientGraphFactory(connection, user, pass);
                        factory = factory.setupPool(1, this.poolSize);
                    } else {
                        factory = new OrientGraphFactory(connection, "admin", "admin");
                    }
                    this.factoryMap.put(key, factory);
                    this.graphs.put(key, 0);
                }
            }
        } else {
            throw new RuntimeException("no factory for connection: " + connection);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientBaseGraph getNoTxGraph(String connection, String user, String pass) {
        OrientGraphFactory f = this.getFactory(connection, user, pass);
        OrientGraphNoTx graph = null;
        Object object = this.lock;
        synchronized (object) {
            graph = f.getNoTx();
            String key = this.getKey(connection, user, pass);
            Integer cnt = this.graphs.get(key);
            if (cnt != null) {
                this.graphs.put(key, cnt + 1);
            }
        }
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OrientBaseGraph getTxGraph(String connection, String user, String pass) {
        OrientGraphFactory f = this.getFactory(connection, user, pass);
        OrientGraph graph = null;
        Object object = this.lock;
        synchronized (object) {
            graph = f.getTx();
            String key = this.getKey(connection, user, pass);
            Integer cnt = this.graphs.get(key);
            if (cnt != null) {
                this.graphs.put(key, cnt + 1);
            }
        }
        return graph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseGraph(OrientBaseGraph graph, String connection, String user, String pass) {
        Object object = this.lock;
        synchronized (object) {
            String key = this.getKey(connection, user, pass);
            Integer cnt = this.graphs.get(key);
            if (cnt != null) {
                this.graphs.put(key, cnt - 1);
            }
        }
        if (!graph.isClosed()) {
            graph.shutdown();
        }
    }

    class CloseIfIdle
    extends Thread {
        int timeout;
        boolean shouldStop;

        public CloseIfIdle(String title) {
            super(title);
            this.timeout = 5000;
            this.shouldStop = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shouldStop) {
                Object object = ODBConnectionServiceImpl.this.lock;
                synchronized (object) {
                    LinkedList<String> remove = new LinkedList<String>();
                    for (String key : ODBConnectionServiceImpl.this.factoryMap.keySet()) {
                        OrientGraphFactory factory = (OrientGraphFactory)ODBConnectionServiceImpl.this.factoryMap.get(key);
                        if (factory != null) {
                            Integer count = (Integer)ODBConnectionServiceImpl.this.graphs.get(key);
                            if (count > 0) continue;
                            L.debug("closing factory, no usage");
                            try {
                                factory.close();
                            }
                            catch (Exception e) {
                                L.debug("exception while closing", (Throwable)e);
                            }
                            factory = null;
                            remove.add(key);
                            continue;
                        }
                        remove.add(key);
                    }
                    for (String key : remove) {
                        ODBConnectionServiceImpl.this.factoryMap.remove(key);
                    }
                }
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
            L.debug("closed CloseIfIdle");
        }
    }
}

