/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.core.itf.impl;

import com.ez.eclient.preferences.service.DynamicPreferencesService;
import com.ez.gdb.core.itf.IODBAdminService;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ad.internal.PasswordUtils;
import com.orientechnologies.orient.client.remote.OEngineRemote;
import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBAdminServiceImpl
implements IODBAdminService {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ODBAdminServiceImpl.class);
    private Set<String> dbNames = new HashSet<String>();
    private ODBPooling thread = new ODBPooling();

    public void shouldStop() {
        this.thread.shouldStop();
    }

    public ODBAdminServiceImpl() {
        this.thread.start();
    }

    @Override
    public boolean hasDatabase(String dbName) {
        return this.dbNames.contains(dbName);
    }

    private class ODBPooling
    extends Thread {
        private final int INIT_SLEEPTIME = 1000;
        private final int SLEEPTIME = 120000;
        private final int EXCEPTION_SLEEPTIME = 10000;
        private int sleep = 1000;
        private boolean shouldStop = false;

        public ODBPooling() {
            this.setName("ODBService.pooling");
        }

        public void shouldStop() {
            this.shouldStop = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.shouldStop) {
                ODBAdminServiceImpl.this.dbNames = this.updateDBNames();
                try {
                    if (ODBAdminServiceImpl.this.dbNames.isEmpty()) {
                        Thread.sleep(this.sleep);
                        continue;
                    }
                    Thread.sleep(120000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            L.debug("ODBPooling stopped");
        }

        private Set<String> updateDBNames() {
            OServerAdmin server = null;
            HashSet<String> names = new HashSet<String>();
            DynamicPreferencesService srv = (DynamicPreferencesService)ServiceUtils.getService(DynamicPreferencesService.class);
            if (srv == null) {
                L.warn("graphDB cannot be configured!");
                return null;
            }
            String host = srv.getString("general.networking.graphdb", "graphdb.host", null, null);
            String port = srv.getString("general.networking.graphdb", "graphdb.port", "2424", null);
            String user = srv.getString("general.networking.graphdb", "graphdb.username", null, null);
            String pass = srv.getString("general.networking.graphdb", "graphdb.password", null, null);
            if (host == null || host.trim().isEmpty() || port == null || port.trim().isEmpty() || user == null || user.trim().isEmpty() || pass == null || pass.trim().isEmpty()) {
                L.info("no orientdb settings, so no list of databases available");
            } else {
                pass = PasswordUtils.decrypt((String)pass);
                String connection = "remote:" + host + ":" + port;
                OServerAdmin admin = null;
                try {
                    try {
                        Orient.instance().registerEngine((OEngine)new OEngineRemote());
                        admin = new OServerAdmin(connection);
                        server = admin.connect(user, pass);
                        names.addAll(server.listDatabases().keySet());
                        this.sleep = 1000;
                    }
                    catch (Throwable t) {
                        if (ExceptionUtils.indexOfThrowable((Throwable)t, ONetworkProtocolException.class) != -1) {
                            L.error("Connection to Orient DB cannot be established for {}. Configuration error! Will NOT retry until next restart.", (Object)connection, (Object)t);
                            this.shouldStop();
                        } else {
                            L.info("exception reading list of databases from {}", (Object)connection, (Object)t);
                            this.sleep = 10000;
                        }
                        if (server != null) {
                            server.close();
                        }
                        if (admin != null) {
                            admin.close(true);
                        }
                    }
                }
                finally {
                    if (server != null) {
                        server.close();
                    }
                    if (admin != null) {
                        admin.close(true);
                    }
                }
            }
            return names;
        }
    }
}

