/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.core.internal;

import com.ez.gdb.core.itf.IODBAdminService;
import com.ez.gdb.core.itf.IODBConnectionService;
import com.ez.gdb.core.itf.impl.ODBAdminServiceImpl;
import com.ez.gdb.core.itf.impl.ODBConnectionServiceImpl;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "com.ez.gdb.core";
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void start(final BundleContext context) throws Exception {
        super.start(context);
        String value = System.getProperty("com.ibm.ad.client.ssl.enabled");
        if (value != null && value.equalsIgnoreCase("true")) {
            OGlobalConfiguration.CLIENT_USE_SSL.setValue((Object)"true");
            L.info("OGlobalConfiguration property client.ssl.enabled set to true!");
        }
        ODBConnectionServiceImpl connectionService = new ODBConnectionServiceImpl();
        context.registerService(IODBConnectionService.class.getName(), (Object)connectionService, null);
        L.debug("registering service: {}", (Object)IODBConnectionService.class.getName());
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle().equals(Activator.this.getBundle()) && event.getType() == 2) {
                    ODBAdminServiceImpl adminService = new ODBAdminServiceImpl();
                    context.registerService(IODBAdminService.class.getName(), (Object)adminService, null);
                    L.debug("registering service: {}", (Object)IODBAdminService.class.getName());
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        ServiceReference connReference;
        ServiceReference adminReference = context.getServiceReference(IODBAdminService.class.getName());
        if (adminReference != null) {
            ODBAdminServiceImpl service = (ODBAdminServiceImpl)context.getService(adminReference);
            service.shouldStop();
            L.debug("unregistering service {}", (Object)IODBAdminService.class.getName());
            context.ungetService(adminReference);
        }
        if ((connReference = context.getServiceReference(IODBConnectionService.class.getName())) != null) {
            ODBConnectionServiceImpl service = (ODBConnectionServiceImpl)context.getService(connReference);
            service.shouldStop();
            L.debug("unregistering service {}", (Object)IODBConnectionService.class.getName());
            context.ungetService(connReference);
        }
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

