/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.core.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.gdb.core.collectors.ODBAbstractCollector;
import com.ez.gdb.core.internal.Messages;
import com.ez.gdb.core.utils.Utils;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.PrgOrIncludeWithPathInput;
import com.ez.report.application.ui.collectors.ProgramInputsFactory4Wizard;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBProgramProxyCollector
extends ODBAbstractCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ODBProgramProxyCollector.class);
    public static final String EXISTINGPROGRAM_QUERY = "select @rid.asString() as proxyRid, name, sid, type, $p.full as path from  ProgramProxy \nlet $p = out('ProxyFor')[0].out('SourceInfo')[0], $a = out('Ancestor') \nwhere aliasType = 0 and (type = 1 or type = 2 or type = 8 or type = 3 or type = 10 or type = 11 or type = 13) and $a.size() = 0 @@@@@EZLEGACY@AND@@@@  limit " + LIMIT + " FETCHPLAN in_*:-2 out_*:-2 ";
    private List<ImageObj4Wizard> availableImages;

    @Override
    public List doCollect(boolean useFilters, Set<String> apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)150);
        monitor.setTaskName(Messages.getString(ODBProgramProxyCollector.class, "collectingData.taskName"));
        if (this.availableImages != null) {
            this.availableImages.clear();
        }
        ArrayList<BaseMainframeResource4GUI> resources = new ArrayList<BaseMainframeResource4GUI>();
        try {
            HashMap<String, PrgOrIncludeWithPathInput> names = new HashMap<String, PrgOrIncludeWithPathInput>();
            HashSet<Integer> availableTypesForFilters = new HashSet<Integer>();
            monitor.worked(100);
            long start = System.currentTimeMillis();
            this.processQuery(EXISTINGPROGRAM_QUERY, resources, names, availableTypesForFilters, monitor.newChild(50));
            L.debug("endODBPrgCollector {}ms", (Object)(System.currentTimeMillis() - start));
            L.debug("resources size in wizard {}", (Object)resources.size());
            ProgramInputsFactory4Wizard factory = ProgramInputsFactory4Wizard.getInstance();
            this.availableImages = factory.buildAvailableImagesFromTypes(availableTypesForFilters);
        }
        catch (ODatabaseException e) {
            L.error("odb connection error", (Throwable)e);
        }
        return resources;
    }

    private void processQuery(String queryToExec, List<BaseMainframeResource4GUI> resources, Map<String, PrgOrIncludeWithPathInput> names, Set<Integer> availableTypesForFilters, SubMonitor monitor) {
        String rid = "#-1:-1";
        boolean next = true;
        while (next && !monitor.isCanceled()) {
            String partialQuery = queryToExec.replace("@@@@@EZLEGACY@AND@@@@", rid != null ? " and @rid > " + rid : "");
            partialQuery = partialQuery.replace("@@@@@EZLEGACY@@@@", rid != null ? " where @rid > " + rid + " " : "");
            super.setPartialQuery(partialQuery);
            Iterable<OrientElement> results = super.getResults();
            rid = this.createObjects(results, resources, names, availableTypesForFilters, (IProgressMonitor)monitor.newChild(50));
            if (rid != null) continue;
            next = false;
        }
    }

    private String createObjects(Iterable<OrientElement> results, List<BaseMainframeResource4GUI> resources, Map<String, PrgOrIncludeWithPathInput> names, Set<Integer> availableTypesForFilters, IProgressMonitor pMonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)10);
        String proxyRidId = null;
        int count = 0;
        for (OrientElement element : results) {
            if (monitor.isCanceled()) {
                return null;
            }
            proxyRidId = (String)element.getProperty("proxyRid");
            Integer sqlID = (Integer)element.getProperty("sid");
            String name = (String)element.getProperty("name");
            Integer programType = (Integer)element.getProperty("type");
            String path = (String)element.getProperty("path");
            if (path != null) {
                path = Utils.replaceCharacters(path);
            }
            availableTypesForFilters.add(programType);
            PrgOrIncludeWithPathInput prgInput = new PrgOrIncludeWithPathInput(name, programType, sqlID, path, proxyRidId);
            prgInput.setOdbRID(proxyRidId);
            resources.add(new BaseMainframeResource4GUI((BaseResourceInput)prgInput));
            if (names.containsKey(name)) {
                names.get(name).displayPath(true);
                prgInput.displayPath(true);
            } else {
                names.put(name, prgInput);
            }
            ++count;
        }
        if (count < LIMIT) {
            proxyRidId = null;
        }
        return proxyRidId;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return this.availableImages;
    }
}

