/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.core.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.gdb.core.collectors.ODBAbstractCollector;
import com.ez.gdb.core.internal.Messages;
import com.ez.gdb.core.utils.Utils;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.ez.report.application.model.PrgOrIncludeWithPathInput;
import com.ez.report.application.ui.collectors.ProgramInputsFactory4Wizard;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBProgramCollector
extends ODBAbstractCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ODBProgramCollector.class);
    private static final String PROGRAM_WITH_VARIABLE_QUERY = "select @RID.asString() as prgrid, name, sid, type, $a.full as path \n from Program  let $a = out('SourceInfo')[0] where type = 1 and $a.hasVarDef = true @@@@@EZLEGACY@AND@@@@  limit " + LIMIT;
    private static final String PLI_PROGRAM_WITH_VARIABLE_QUERY = "select @RID.asString() as prgrid, name, sid, type, $a.full as path \n from Program  let $a = out('SourceInfo')[0] where (type = 2) and $a.hasVarDef = true @@@@@EZLEGACY@AND@@@@  limit " + LIMIT;
    public static final String PROGRAM_EXISTENT_QUERY = "select @RID.asString() as prgrid, name, sid, type,  $s.full as path, $a.sid as ancsid, $a.name as ancname  from Program  let $s = out('SourceInfo')[0], $a = in('ProxyFor')[0].out('Ancestor')[0] where (type = 1 or type = 2 or type = 3 or type = 10) @@@@@EZLEGACY@AND@@@@  limit " + LIMIT;
    public static final String ASS_PROGRAMS_CHILDREN_QUERY2 = "select $b.@rid.asString() as prgrid , $b.name as name,  $b.sid as sid , $b.type as type, $b.out('SourceInfo')[0].full as path from programproxy  let $b = in('Ancestor').out('ProxyFor')[0] where aliasType = 0 and sid in list(?) ";
    public static final String PROGRAMPROXY_CHILDREN_QUERY = "select ifnull(out('ProxyFor')[0], @rid).asString() as prgrid, name, sid, type,  $p.full as path, $a.sid as ancsid, $a.name as ancname  from ProgramProxy \n let $a = out('Ancestor')[0], $p = out('ProxyFor')[0].out('SourceInfo')[0]  where aliasType = 0 and ( type = 15 or type = 16 or type = 1 ) ";
    public static final String PROGRAMPROXY_CHILDREN_QUERY_SID_CONDITION = " $a.sid in list(?) ";
    public static final String EXISTINGPROGRAMPROXY_CHILDREN_QUERY = "select ifnull(out('ProxyFor')[0], @rid).asString() as prgrid, name, sid, type,  $p.full as path, $a.sid as ancsid, $a.name as ancname  from ProgramProxy \n let $a = out('Ancestor')[0], $p = out('ProxyFor')[0].out('SourceInfo')[0]  where aliasType = 0 and ( type = 15 or type = 16 or type = 1 )  and  $a.sid in list(?) and sid<>-1";
    private String query;
    private List<ImageObj4Wizard> availableImages;

    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public List doCollect(boolean useFilters, Set<String> apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)150);
        monitor.setTaskName(Messages.getString(ODBProgramCollector.class, "collectingData.taskName"));
        if (this.availableImages != null) {
            this.availableImages.clear();
        }
        ArrayList<BaseMainframeResource4GUI> resources = new ArrayList<BaseMainframeResource4GUI>();
        try {
            String queryToExec = null;
            queryToExec = this.query != null ? this.query : PLI_PROGRAM_WITH_VARIABLE_QUERY;
            boolean next = true;
            String rid = "#-1:-1";
            HashMap<String, PrgOrIncludeWithPathInput> names = new HashMap<String, PrgOrIncludeWithPathInput>();
            HashSet<Integer> availableTypesForFilters = new HashSet<Integer>();
            monitor.worked(100);
            long start = System.currentTimeMillis();
            while (next && !monitor.isCanceled()) {
                String partialQuery = queryToExec.replace("@@@@@EZLEGACY@AND@@@@", rid != null ? " and @rid > " + rid : "");
                partialQuery = partialQuery.replace("@@@@@EZLEGACY@@@@", rid != null ? " where @rid > " + rid + " " : "");
                super.setPartialQuery(partialQuery);
                Iterable<OrientElement> results = super.getResults();
                rid = this.createObjects(results, resources, names, availableTypesForFilters, (IProgressMonitor)monitor.newChild(50));
                if (rid != null) continue;
                next = false;
            }
            L.debug("endODBPrgCollector {}ms", (Object)(System.currentTimeMillis() - start));
            L.debug("resources size in wizard {}", (Object)resources.size());
            ProgramInputsFactory4Wizard factory = ProgramInputsFactory4Wizard.getInstance();
            this.availableImages = factory.buildAvailableImagesFromTypes(availableTypesForFilters, true);
        }
        catch (ODatabaseException e) {
            L.error("odb connection error", (Throwable)e);
        }
        return resources;
    }

    private String createObjects(Iterable<OrientElement> results, List<BaseMainframeResource4GUI> resources, Map<String, PrgOrIncludeWithPathInput> names, Set<Integer> availableTypesForFilters, IProgressMonitor pMonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)10);
        String ridId = null;
        int count = 0;
        for (OrientElement element : results) {
            if (monitor.isCanceled()) {
                return null;
            }
            if (!(element instanceof OrientVertex)) continue;
            ridId = (String)element.getProperty("prgrid");
            String name = (String)element.getProperty("name");
            Integer sqlID = (Integer)element.getProperty("sid");
            String path = Utils.replaceCharacters((String)element.getProperty("path"));
            Integer programType = (Integer)element.getProperty("type");
            availableTypesForFilters.add(programType);
            PrgOrIncludeWithPathInput prgInput = new PrgOrIncludeWithPathInput(name, programType, sqlID, path, ridId);
            prgInput.setOdbRID(ridId);
            if (programType == 15 || programType == 16 || programType == 1) {
                prgInput.setAncestorDBId((Integer)element.getProperty("ancsid"));
                prgInput.setAncestorName((String)element.getProperty("ancname"));
            }
            resources.add(new BaseMainframeResource4GUI((BaseResourceInput)prgInput));
            ++count;
            if (names.containsKey(name)) {
                names.get(name).displayPath(true);
                prgInput.displayPath(true);
                continue;
            }
            names.put(name, prgInput);
        }
        if (count < LIMIT) {
            ridId = null;
        }
        return ridId;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return this.availableImages;
    }
}

