/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.core.collectors;

import com.ez.common.model.BaseResourceInput;
import com.ez.common.ui.BaseResourceInput4GUI;
import com.ez.gdb.core.collectors.ODBAbstractCollector;
import com.ez.gdb.core.internal.Messages;
import com.ez.gdb.core.utils.Utils;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.gui.preferences.PreferenceUtils;
import com.ez.mainframe.model.dataset.MultipleVSAMInput;
import com.ez.report.application.model.BaseMainframeResource4GUI;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODBDatasetCollector
extends ODBAbstractCollector {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ODBDatasetCollector.class);
    private final String Query_WITH_TEMP = "select @rid.asString() as dsrid, dsid, sid from DSName\n\twhere @@@@@EZLEGACY@AND@@@@ \t\t\tisInstream = 'false' and isLib = 'false'\tlimit " + LIMIT;
    private final String Query_WITHOUT_TEMP = "select @rid.asString() as dsrid, dsid, sid from DSName\n\twhere @@@@@EZLEGACY@AND@@@@\t\t\tisLib = 'false' and isTemp = 'false' and isInstream = 'false'\tlimit " + LIMIT;
    private boolean excludeTempDs = false;

    public ODBDatasetCollector() {
    }

    public ODBDatasetCollector(boolean excludeTempDs) {
        this.excludeTempDs = excludeTempDs;
    }

    public List doCollect(boolean useFilters, Set apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)500);
        monitor.setTaskName(Messages.getString(ODBDatasetCollector.class, "collectingData.taskName"));
        ArrayList<BaseResourceInput4GUI> resources = new ArrayList<BaseResourceInput4GUI>();
        try {
            boolean next = true;
            String rid = "#-1:-1";
            HashSet<String> namesWithMember = new HashSet<String>();
            long start = System.currentTimeMillis();
            boolean displayTemptDatasets = !this.excludeTempDs && PreferenceUtils.getPreferenceStore().getBoolean("displayTemporaryDatasets");
            String query = displayTemptDatasets ? this.Query_WITH_TEMP : this.Query_WITHOUT_TEMP;
            while (next && !monitor.isCanceled()) {
                String partialQuery = query.replace("@@@@@EZLEGACY@AND@@@@", rid != null ? " @rid > " + rid + " and " : "");
                super.setPartialQuery(partialQuery);
                Iterable<OrientElement> results = super.getResults();
                rid = this.createObjects(resources, namesWithMember, results, (IProgressMonitor)monitor.newChild(10));
                if (rid != null) continue;
                next = false;
            }
            L.debug("endODBDatasetCollector {}ms", (Object)(System.currentTimeMillis() - start));
            L.debug("dataset in wizard size: {}", (Object)resources.size());
        }
        catch (ODatabaseException e) {
            L.error("odb connection error", (Throwable)e);
        }
        return resources;
    }

    protected String createObjects(List<BaseResourceInput4GUI> resources, Set<String> namesWithMember, Iterable<OrientElement> results, IProgressMonitor pMonitor) {
        MultipleVSAMInput inpt = null;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pMonitor, (int)100);
        int count = 0;
        String ridId = null;
        for (OrientElement elem : results) {
            if (monitor.isCanceled()) {
                return null;
            }
            ++count;
            ridId = (String)elem.getProperty("dsrid");
            String nameWithMember = (String)elem.getProperty("dsid");
            if (namesWithMember.contains(nameWithMember)) continue;
            Integer id = (Integer)elem.getProperty("sid");
            Pair<String, String> pair = Utils.splitDSid(nameWithMember);
            String memberName = pair.getSecond() == null ? "" : (String)pair.getSecond();
            String dsname = (String)pair.getFirst();
            inpt = new MultipleVSAMInput(dsname, memberName, id, null);
            BaseMainframeResource4GUI guiInpt = new BaseMainframeResource4GUI((BaseResourceInput)inpt);
            resources.add((BaseResourceInput4GUI)guiInpt);
            namesWithMember.add(nameWithMember);
        }
        if (count < LIMIT) {
            ridId = null;
        }
        return ridId;
    }

    public List getAvailableImages() {
        return null;
    }
}

