/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.core.collectors;

import com.ez.common.ui.listselection.Listable;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ODBAbstractCollector
implements ResourcesCollector<Listable> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ODBAbstractCollector.class);
    protected static final String MARKER = "@@@@@EZLEGACY@@@@";
    public static final String MARKER_AND = "@@@@@EZLEGACY@AND@@@@";
    public static final Integer LIMIT = 10000;
    protected static final String BEGIN_RID = "#-1:-1";
    private OrientBaseGraph dbg = null;
    protected Properties env = null;
    protected String partialQuery;

    public void setPartialQuery(String query) {
        this.partialQuery = query;
    }

    public Iterable<OrientElement> getResults() {
        long start = System.currentTimeMillis();
        Iterable results = (Iterable)this.dbg.command((OCommandRequest)new OCommandSQL(this.partialQuery)).execute(new Object[0]);
        L.debug("execute query for wizard: {}ms", (Object)(System.currentTimeMillis() - start));
        return results;
    }

    protected abstract List doCollect(boolean var1, Set<String> var2, String var3, IProgressMonitor var4) throws Exception;

    public final List collect(boolean useFilters, Set<String> apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        this.env = ConnectionUtils.getODBSettings(prjName);
        this.dbg = ConnectionUtils.getNoTxGraph(this.env);
        try {
            List list = this.doCollect(useFilters, apps, prjName, pMonitor);
            return list;
        }
        finally {
            ConnectionUtils.releaseGraph(this.dbg, this.env);
            this.dbg = null;
            this.env = null;
        }
    }
}

