/*
 * Decompiled with CFR 0.152.
 */
package com.ez.gdb.core.analysis;

import com.ez.gdb.core.itf.IODBAdminService;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.List;

public class GdbFilterUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static ProjectInfo getProjectInfo(EZObjectType inpObj) {
        EZSourceProjectIDSg prjIdSg;
        EZEntityID entity;
        ProjectInfo pInfo = null;
        if (inpObj != null && (pInfo = (ProjectInfo)inpObj.getProperty("PROJECT_INFO")) == null && (entity = inpObj.getEntID()) != null && (prjIdSg = (EZSourceProjectIDSg)entity.getSegment(EZSourceProjectIDSg.class)) != null) {
            pInfo = prjIdSg.getProjectInfo();
        }
        return pInfo;
    }

    public static boolean checkDefinition(ProjectInfo pInfo) {
        boolean ok = pInfo.hasDefinition();
        String pName = pInfo.getName();
        IODBAdminService service = (IODBAdminService)ServiceUtils.getService(IODBAdminService.class);
        if (service != null) {
            ok = service.hasDatabase(pName);
        }
        return ok;
    }

    public static List<String> checkDefinition(List<String> prjNames) {
        ArrayList<String> ret = null;
        IODBAdminService service = (IODBAdminService)ServiceUtils.getService(IODBAdminService.class);
        if (service != null) {
            ret = new ArrayList<String>();
            for (String prjName : prjNames) {
                boolean ok = service.hasDatabase(prjName);
                if (!ok) continue;
                ret.add(prjName);
            }
        }
        return ret;
    }
}

