/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.override.resolutions;

import com.ez.mainframe.override.resolutions.model.CompilerResolution;
import com.ez.mainframe.override.resolutions.model.JournalEntry;
import com.ez.mainframe.override.resolutions.model.Resolution;
import com.ez.mainframe.override.resolutions.model.UserAssistedResolution;
import com.ez.mainframe.override.resolutions.model.ValuesTriplet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class Translate {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    public static List<JournalEntry> toEntryList(JsonArray array) {
        if (array == null) {
            return null;
        }
        ArrayList<JournalEntry> list = new ArrayList<JournalEntry>();
        int i = 0;
        while (i < array.size()) {
            JsonObject jo = array.getJsonObject(i);
            JournalEntry je = Translate.toEntry(jo);
            list.add(je);
            ++i;
        }
        return list;
    }

    private static Date toDate(String ds) {
        int start = "date(".length();
        int end = ds.indexOf(")");
        String timestamp = ds.substring(start, end);
        return new Date(Long.parseLong(timestamp));
    }

    private static Set<ValuesTriplet<String, Integer, String>> toTripletSet(JsonArray a) {
        HashSet<ValuesTriplet<String, Integer, String>> s = new HashSet<ValuesTriplet<String, Integer, String>>();
        int i = 0;
        while (i < a.size()) {
            JsonObject to = a.getJsonObject(i);
            String program = Translate.getString(to, "name");
            int type = to.getInt("type");
            String ancestor = Translate.getString(to, "ancestor");
            s.add((ValuesTriplet<String, Integer, String>)new ValuesTriplet((Object)program, (Object)type, (Object)ancestor));
            ++i;
        }
        return s;
    }

    private static String getString(JsonObject o, String key) {
        return o.get((Object)key) == null || ((JsonValue)o.get((Object)key)).getValueType() == JsonValue.ValueType.NULL ? null : o.getString(key);
    }

    public static JournalEntry toEntry(JsonObject o) {
        if (o == null || o.isEmpty()) {
            return null;
        }
        JournalEntry e = new JournalEntry();
        e.date = Translate.toDate(o.getString("date"));
        e.user = Translate.getString(o, "user");
        e.oldValue = Translate.getString(o, "oldValue");
        JsonValue jv = (JsonValue)o.get((Object)"newValues");
        if (jv != null && jv.getValueType() != JsonValue.ValueType.NULL) {
            e.newValues = Translate.toTripletSet((JsonArray)jv);
        }
        e.stmtType = o.getInt("stmtType");
        e.resType = o.getInt("resType");
        e.index = o.getInt("index");
        e.used = o.getBoolean("used");
        e.state = o.getInt("state");
        e.userAtDelete = Translate.getString(o, "userAtDelete");
        e.callPath = Translate.getString(o, "callPath");
        e.callLine = o.getInt("callLine");
        e.contextName = Translate.getString(o, "contextName");
        e.contextPath = Translate.getString(o, "contextPath");
        e.contextSeq = o.getInt("contextSeq");
        e.programType = o.getInt("programType");
        e.programAncestor = Translate.getString(o, "programAncestor");
        jv = (JsonValue)o.get((Object)"resolution");
        if (jv != null && jv.getValueType() != JsonValue.ValueType.NULL) {
            e.resolution = Translate.toResolution((JsonObject)jv);
        }
        e.rank = o.getInt("rank");
        e.contextSid = o.getString("contextSid");
        return e;
    }

    private static Resolution toResolution(JsonObject o) {
        UserAssistedResolution r = null;
        boolean manual = o.getBoolean("manual", false);
        if (manual) {
            r = new UserAssistedResolution();
        } else {
            boolean solved = o.getBoolean("solved");
            r = new CompilerResolution(solved);
        }
        r.path = o.getString("path");
        r.line = o.getInt("line");
        r.stmtType = o.getInt("stmtType");
        r.resType = o.getInt("resType");
        r.index = o.getInt("index");
        r.priority = o.getInt("priority");
        JsonValue jv = (JsonValue)o.get((Object)"values");
        if (jv != null && jv.getValueType() != JsonValue.ValueType.NULL) {
            r.values = Translate.toTripletSet((JsonArray)jv);
        }
        r.contextName = o.getString("contextName");
        r.contextPath = o.getString("contextPath");
        r.contextSeq = o.getInt("contextSeq");
        r.creationDate = Translate.toDate(o.getString("creationDate"));
        return r;
    }

    public static JsonObject resolutionAsJSON(Resolution res) {
        if (res == null) {
            return null;
        }
        JsonObjectBuilder b = Json.createObjectBuilder().add("path", res.path).add("line", res.line.intValue()).add("stmtType", res.stmtType.intValue()).add("resType", res.resType.intValue()).add("index", res.index).add("priority", res.priority);
        JsonArray values = Translate.tripletSetAsJSON(res.values);
        if (values != null) {
            b.add("values", (JsonValue)values);
        }
        b.add("contextName", res.contextName);
        b.add("contextPath", res.contextPath);
        b.add("contextSeq", res.contextSeq.intValue());
        b.add("creationDate", Translate.dateAsJSONString(res.creationDate));
        b.add("manual", res.isManual());
        b.add("solved", res.isSolved());
        return b.build();
    }

    public static JsonObject entryAsJSON(JournalEntry je) {
        JsonObject res;
        JsonArray newValues;
        JsonObjectBuilder jb = Json.createObjectBuilder().add("date", Translate.dateAsJSONString(je.date)).add("user", je.user).add("stmtType", je.stmtType.intValue()).add("resType", je.resType.intValue()).add("index", je.index).add("used", je.used).add("state", je.state).add("callPath", je.callPath).add("callLine", je.callLine.intValue()).add("contextName", je.contextName).add("contextPath", je.contextPath).add("contextSeq", je.contextSeq.intValue()).add("programType", je.programType.intValue());
        if (je.oldValue != null) {
            jb.add("oldValue", je.oldValue);
        }
        if (je.programAncestor != null) {
            jb.add("programAncestor", je.programAncestor);
        }
        if ((newValues = Translate.tripletSetAsJSON(je.newValues)) != null) {
            jb.add("newValues", (JsonValue)newValues);
        }
        if ((res = Translate.resolutionAsJSON(je.resolution)) != null) {
            jb.add("resolution", (JsonValue)res);
        }
        jb.add("rank", je.rank);
        jb.add("contextSid", je.contextSid);
        return jb.build();
    }

    private static JsonArray tripletSetAsJSON(Set<ValuesTriplet<String, Integer, String>> ts) {
        if (ts == null) {
            return null;
        }
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (ValuesTriplet<String, Integer, String> t : ts) {
            JsonObjectBuilder tb = Json.createObjectBuilder().add("name", (String)t.getFirst()).add("type", ((Integer)t.getSecond()).intValue());
            if (t.getThird() != null) {
                tb.add("ancestor", (String)t.getThird());
            }
            array.add((JsonValue)tb.build());
        }
        return array.build();
    }

    private static String dateAsJSONString(Date date) {
        StringBuilder sb = new StringBuilder();
        sb.append("date(").append(date.getTime()).append(")");
        return sb.toString();
    }
}

