/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mainframe.override.resolutions;

import com.ez.eclient.service.rsrv.resolutions.ManualResolutionsService;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.override.resolutions.ResolutionException;
import com.ez.mainframe.override.resolutions.Translate;
import com.ez.mainframe.override.resolutions.internal.Messages;
import com.ez.mainframe.override.resolutions.model.JournalEntry;
import com.ez.mainframe.override.resolutions.model.Resolution;
import com.ibm.ad.oauth2.model.HttpResponseConsumer;
import com.ibm.ad.oauth2.service.HTTPErrorHandler;
import com.ibm.ad.oauth2.service.SSOService;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolutionsProxy {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ResolutionsProxy.class);

    public static List<JournalEntry> getAllCurrentResolutions(ProjectInfo pInfo) throws Exception {
        List<JournalEntry> ret = new ArrayList<JournalEntry>();
        ManualResolutionsService srv = ResolutionsProxy.checkCCSService();
        String prjName = pInfo.getName();
        try {
            String endpoint = srv.getCurrentResolutionEndpoint();
            String request = ResolutionsProxy.prepareURL(endpoint, new Pair((Object)"pn", (Object)prjName));
            String content = ResolutionsProxy.runRequest(request);
            if (content != null) {
                JsonReader reader = Json.createReader((Reader)new StringReader(content));
                JsonObject root = reader.readObject();
                ret = Translate.toEntryList(root.getJsonArray("data"));
            } else {
                L.error("null response content getting all current resolutions for project {}", (Object)prjName);
            }
        }
        catch (Exception e) {
            L.debug("while getting all current resolutions for project {}", (Object)prjName, (Object)e);
            if (e instanceof ResolutionException) {
                throw e;
            }
            String exceptMsg = Messages.getString(ResolutionsProxy.class, "allResolutions.exception", new String[]{prjName});
            throw new RuntimeException(exceptMsg, e);
        }
        return ret;
    }

    public static JournalEntry getLastEntry(ProjectInfo pInfo, String defPath, int defLine, int stmtTypeId, Integer resType, Integer idx, String prgName, String prgPath, Integer contextSeq, boolean onlyManual) {
        JournalEntry entry = null;
        ManualResolutionsService srv = ResolutionsProxy.checkCCSService();
        String endpoint = srv.getLastResolutionEndpoint();
        String prjName = pInfo.getName();
        try {
            String request = ResolutionsProxy.prepareURL(endpoint, new Pair((Object)"pn", (Object)prjName), new Pair((Object)"dp", (Object)defPath), new Pair((Object)"dl", (Object)String.valueOf(defLine)), new Pair((Object)"st", (Object)String.valueOf(stmtTypeId)), new Pair((Object)"rt", (Object)String.valueOf(resType)), new Pair((Object)"ri", (Object)String.valueOf(idx)), new Pair((Object)"cn", (Object)prgName), new Pair((Object)"cp", (Object)prgPath), new Pair((Object)"cs", (Object)String.valueOf(contextSeq)), new Pair((Object)"om", (Object)String.valueOf(onlyManual)));
            String content = ResolutionsProxy.runRequest(request);
            if (content != null) {
                JsonReader reader = Json.createReader((Reader)new StringReader(content));
                JsonObject root = reader.readObject();
                entry = Translate.toEntry(root.getJsonObject("data"));
            } else {
                L.error("empty/null response while getting last entry for a resolution in project {}", (Object)prjName);
            }
        }
        catch (Exception e) {
            L.debug("while getting resolutions for project {}", (Object)prjName, (Object)e);
            throw new RuntimeException(Messages.getString(ResolutionsProxy.class, "lastEntry.exception"), e);
        }
        return entry;
    }

    public static Map<Date, JournalEntry> getAllAppliedResolutions(ProjectInfo pInfo, String defPath, int defLine, int stmtTypeId, Integer resType, Integer idx, String prgName, String prgPath, Integer contextSeq) {
        HashMap<Date, JournalEntry> entries;
        block4: {
            entries = new HashMap<Date, JournalEntry>();
            ManualResolutionsService srv = ResolutionsProxy.checkCCSService();
            String endpoint = srv.getAppliedResEndpoint();
            String prjName = pInfo.getName();
            try {
                String request = ResolutionsProxy.prepareURL(endpoint, new Pair((Object)"pn", (Object)prjName), new Pair((Object)"dp", (Object)defPath), new Pair((Object)"dl", (Object)String.valueOf(defLine)), new Pair((Object)"st", (Object)String.valueOf(stmtTypeId)), new Pair((Object)"rt", (Object)String.valueOf(resType)), new Pair((Object)"ri", (Object)String.valueOf(idx)), new Pair((Object)"cn", (Object)prgName), new Pair((Object)"cp", (Object)prgPath), new Pair((Object)"cs", (Object)String.valueOf(contextSeq)));
                String content = ResolutionsProxy.runRequest(request);
                if (content != null) {
                    JsonReader reader = Json.createReader((Reader)new StringReader(content));
                    JsonObject root = reader.readObject();
                    List<JournalEntry> entryList = Translate.toEntryList(root.getJsonArray("data"));
                    for (JournalEntry je : entryList) {
                        entries.put(je.date, je);
                    }
                    break block4;
                }
                L.error("empty/null response while getting all applied resolutions for project {}", (Object)prjName);
                throw new RuntimeException(Messages.getString(ResolutionsProxy.class, "allApplied.serviceerror.exception", new String[]{prjName}));
            }
            catch (Exception e) {
                L.debug("while getting all applied resolutions for project {}", (Object)prjName, (Object)e);
                throw new RuntimeException(Messages.getString(ResolutionsProxy.class, "allApplied.exception", new String[]{prjName}), e);
            }
        }
        return entries;
    }

    public static void registerResolution(Resolution toApply, boolean saveResolution, String prgType, String prgId, String ancestor, ProjectInfo pInfo) {
        ResolutionsProxy.checkProjectUUID(pInfo);
        ManualResolutionsService srv = ResolutionsProxy.checkCCSService();
        String endpoint = srv.getRegisterEndpoint();
        String prjName = pInfo.getName();
        try {
            JsonObject rjo = Translate.resolutionAsJSON(toApply);
            JsonObjectBuilder infob = Json.createObjectBuilder().add("toApply", (JsonValue)rjo).add("save", saveResolution).add("type", prgType).add("id", prgId).add("project", prjName).add("uuid", pInfo.getUUID());
            if (ancestor != null) {
                infob.add("ancestor", ancestor);
            }
            JsonObject info = infob.build();
            StringWriter stringWriter = new StringWriter();
            JsonWriter writer = Json.createWriter((Writer)stringWriter);
            writer.writeObject(info);
            writer.close();
            String body = stringWriter.getBuffer().toString();
            String content = ResolutionsProxy.maybeChangeRequest("PUT", endpoint, body);
            L.trace("ok end for registering resolution on project {}; content={}", (Object)prjName, (Object)content);
        }
        catch (Exception e) {
            L.debug("registering resolution on project {}", (Object)prjName, (Object)e);
            throw new RuntimeException(Messages.getString(ResolutionsProxy.class, "register.exception", new String[]{prjName}), e);
        }
    }

    private static void checkProjectUUID(ProjectInfo pInfo) {
        if (pInfo.getUUID() == null) {
            throw new RuntimeException(Messages.getString(ResolutionsProxy.class, "wrongprojectUUID.exception"));
        }
    }

    private static String runRequest(String endpoint) throws Exception {
        String ret;
        block5: {
            ret = null;
            SSOService sso = (SSOService)ServiceUtils.getService(SSOService.class);
            if (sso != null) {
                ResolutionContentConsumer consumer = new ResolutionContentConsumer();
                try {
                    sso.request(new URL(endpoint), (HttpResponseConsumer)consumer);
                    ret = consumer.getContent();
                    Exception th = consumer.getException();
                    if (th != null) {
                        throw th;
                    }
                    if (consumer.getHttpCode() != 200) {
                        String msg = Messages.getString(ResolutionsProxy.class, "request.exception");
                        throw new ResolutionException(consumer.getHttpCode(), null, null, msg);
                    }
                    break block5;
                }
                catch (Exception ex) {
                    L.error("error getting results from manual resolutions service; endpoint: {}", (Object)endpoint, (Object)ex);
                    throw ex;
                }
            }
            L.error("cannot find SSOService!");
        }
        return ret;
    }

    private static String maybeChangeRequest(String method, String endpoint, String info) throws Exception {
        String ret;
        block4: {
            ret = null;
            SSOService sso = (SSOService)ServiceUtils.getService(SSOService.class);
            if (sso != null) {
                ResolutionContentConsumer consumer = new ResolutionContentConsumer();
                try {
                    sso.request(new URL(endpoint), method, info, (HttpResponseConsumer)consumer, (HTTPErrorHandler)new ResolutionsErrorHandler(endpoint, method));
                    ret = consumer.getContent();
                    Exception th = consumer.getException();
                    if (th != null) {
                        throw th;
                    }
                    break block4;
                }
                catch (Exception ex) {
                    L.debug("exception running {}", (Object)endpoint, (Object)ex);
                    throw ex;
                }
            }
            L.error("cannot find SSOService!");
        }
        return ret;
    }

    public static void deleteEntry(ProjectInfo pInfo, JournalEntry entry) {
        ResolutionsProxy.checkProjectUUID(pInfo);
        ManualResolutionsService srv = ResolutionsProxy.checkCCSService();
        String endpoint = srv.getDeleteEndpoint();
        String project = pInfo.getName();
        try {
            JsonObject ejo = Translate.entryAsJSON(entry);
            JsonObjectBuilder infob = Json.createObjectBuilder().add("delete", (JsonValue)ejo).add("project", project).add("uuid", pInfo.getUUID());
            JsonObject info = infob.build();
            StringWriter stringWriter = new StringWriter();
            JsonWriter writer = Json.createWriter((Writer)stringWriter);
            writer.writeObject(info);
            writer.close();
            String body = stringWriter.getBuffer().toString();
            String content = ResolutionsProxy.maybeChangeRequest("POST", endpoint, body);
            L.trace("ok end for delete a resolution on project {}; content={}", (Object)project, (Object)content);
        }
        catch (Exception e) {
            L.debug("deleting resolution on project {}", (Object)project, (Object)e);
            throw new RuntimeException(Messages.getString(ResolutionsProxy.class, "delete.exception", new String[]{project}), e);
        }
    }

    public static void reapplyResolution(JournalEntry unusedEntry, JournalEntry overriddenEntry, Resolution toApply, String ancestor, ProjectInfo pInfo) {
        ResolutionsProxy.checkProjectUUID(pInfo);
        ManualResolutionsService srv = ResolutionsProxy.checkCCSService();
        String endpoint = srv.getReapplyendpoint();
        String project = pInfo.getName();
        try {
            JsonObject uejo = Translate.entryAsJSON(unusedEntry);
            JsonObject oejo = Translate.entryAsJSON(overriddenEntry);
            JsonObject tajo = Translate.resolutionAsJSON(toApply);
            JsonObjectBuilder infob = Json.createObjectBuilder().add("project", project).add("uuid", pInfo.getUUID());
            if (ancestor != null) {
                infob.add("ancestor", ancestor);
            }
            if (uejo != null) {
                infob.add("unused", (JsonValue)uejo);
            }
            if (oejo != null) {
                infob.add("overriden", (JsonValue)oejo);
            }
            if (tajo != null) {
                infob.add("toApply", (JsonValue)tajo);
            }
            JsonObject info = infob.build();
            StringWriter stringWriter = new StringWriter();
            JsonWriter writer = Json.createWriter((Writer)stringWriter);
            writer.writeObject(info);
            writer.close();
            String body = stringWriter.getBuffer().toString();
            String content = ResolutionsProxy.maybeChangeRequest("PUT", endpoint, body);
            L.trace("ok end for reapplying resolution on project {}; content={}", (Object)project, (Object)content);
        }
        catch (Exception e) {
            L.debug("reapplying resolution on project {}", (Object)project, (Object)e);
            throw new RuntimeException(Messages.getString(ResolutionsProxy.class, "reapply.exception", new String[]{project}), e);
        }
    }

    public static List<JournalEntry> getAllMatchingEntries(JournalEntry entry, ProjectInfo pInfo) {
        ArrayList<JournalEntry> ret;
        block4: {
            ret = new ArrayList<JournalEntry>();
            ManualResolutionsService srv = ResolutionsProxy.checkCCSService();
            String endpoint = srv.getMatchingResolutionEndpoint();
            String project = pInfo.getName();
            try {
                JsonObject ejo = Translate.entryAsJSON(entry);
                JsonObjectBuilder infob = Json.createObjectBuilder().add("entry", (JsonValue)ejo).add("project", project);
                JsonObject info = infob.build();
                StringWriter stringWriter = new StringWriter();
                JsonWriter writer = Json.createWriter((Writer)stringWriter);
                writer.writeObject(info);
                writer.close();
                String body = stringWriter.getBuffer().toString();
                String content = ResolutionsProxy.maybeChangeRequest("POST", endpoint, body);
                if (content != null) {
                    JsonReader reader = Json.createReader((Reader)new StringReader(content));
                    JsonObject root = reader.readObject();
                    List<JournalEntry> entryList = Translate.toEntryList(root.getJsonArray("data"));
                    for (JournalEntry je : entryList) {
                        ret.add(je);
                    }
                    break block4;
                }
                L.error("empty/null response while getting all matching resolutions on project {}", (Object)project);
                throw new RuntimeException(Messages.getString(ResolutionsProxy.class, "allMatching.serviceerror.exception", new String[]{project}));
            }
            catch (Exception e) {
                L.debug("getting all matching entries on project {}", (Object)project, (Object)e);
                throw new RuntimeException(Messages.getString(ResolutionsProxy.class, "allMatching.exception", new String[]{project}), e);
            }
        }
        return ret;
    }

    public static Resolution getLastApplied(ProjectInfo pInfo, String defPath, int defLine, int stmtTypeId, Integer resType, Integer idx, String prgName, String prgPath, int contextSeq, boolean onlyManual) {
        L.debug("get last applied resolution");
        JournalEntry entry = ResolutionsProxy.getLastEntry(pInfo, defPath, defLine, stmtTypeId, resType, idx, prgName, prgPath, contextSeq, onlyManual);
        if (entry != null) {
            return entry.resolution;
        }
        return null;
    }

    private static ManualResolutionsService getCCSService() {
        ManualResolutionsService srv = (ManualResolutionsService)ServiceUtils.getService(ManualResolutionsService.class);
        if (srv != null) {
            if (!srv.isStarted()) {
                L.error("CCS manual resolution service is not started!");
                srv = null;
            }
        } else {
            L.error("CCS manual resolution service cannot be accessed!");
        }
        return srv;
    }

    private static ManualResolutionsService checkCCSService() throws ResolutionException {
        ManualResolutionsService srv = ResolutionsProxy.getCCSService();
        if (srv != null) {
            return srv;
        }
        throw new ResolutionException(Messages.getString(ResolutionsProxy.class, "serviceConnection.exception"), null);
    }

    @SafeVarargs
    private static String prepareURL(String prefix, Pair<String, String> ... params) {
        if (prefix == null) {
            throw new ResolutionException(Messages.getString(ResolutionsProxy.class, "service.exception"), null);
        }
        String url = null;
        try {
            url = String.valueOf(prefix) + "?";
            int no = 1;
            Pair<String, String>[] pairArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Pair<String, String> parameter = pairArray[n2];
                String paramName = (String)parameter.getFirst();
                String paramVal = (String)parameter.getSecond();
                url = String.valueOf(url) + paramName + "=" + URLEncoder.encode(paramVal, "UTF-8");
                if (no < params.length) {
                    url = String.valueOf(url) + "&";
                }
                ++no;
                ++n2;
            }
        }
        catch (Exception e) {
            L.error("error preparing url. prefix={}; params={}, paramValue={}", new Object[]{prefix, params, e});
        }
        return url;
    }

    private static ResolutionException printErrorDetails(String endpoint, int responseCode, InputStream content) {
        return ResolutionsProxy.printErrorDetails(endpoint, responseCode, content, null);
    }

    private static ResolutionException printErrorDetails(String endpoint, int responseCode, InputStream content, String cont) {
        ResolutionException ex = null;
        JsonObject root = null;
        BufferedReader in = null;
        byte[] bb = null;
        if (content != null) {
            bb = ResolutionsProxy.readStream(content);
            in = new BufferedReader(new InputStreamReader(content));
        } else if (cont != null) {
            in = new BufferedReader(new StringReader(cont));
        }
        if (in != null) {
            try {
                JsonReader reader = Json.createReader(in);
                root = reader.readObject();
                Object err = root.get((Object)"error");
                Object code = root.get((Object)"code");
                Object msg = root.get((Object)"msg");
                L.error("request ({}) error;  code={}, msg={}, error={}", new Object[]{endpoint, msg, code, err});
                ex = new ResolutionException(responseCode, err.toString(), code.toString(), msg.toString());
            }
            catch (Throwable th) {
                L.info("error printing details", th);
                String s = bb != null ? new String(bb) : cont;
                L.error("{} is the error content of request: {}", (Object)s, (Object)endpoint);
                String msg = Messages.getString(ResolutionsProxy.class, "request.exception2", new String[]{endpoint});
                ex = new ResolutionException(msg, th);
            }
        } else {
            L.error("printing response details; error content is empty for request ({})", (Object)endpoint);
            String msg = Messages.getString(ResolutionsProxy.class, "request.exception", new String[]{endpoint});
            ex = new ResolutionException(msg, null);
        }
        return ex;
    }

    static byte[] readStream(InputStream input) {
        byte[] bucket = new byte[32768];
        ByteArrayOutputStream result = new ByteArrayOutputStream(bucket.length);
        try {
            int bytesRead = 0;
            while (bytesRead != -1) {
                bytesRead = input.read(bucket);
                if (bytesRead <= 0) continue;
                result.write(bucket, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            L.warn("error reading stream", (Throwable)ex);
        }
        return result.toByteArray();
    }

    public static String getLocalizedResolutionType(Resolution.ResolutionType type) {
        String str = "";
        switch (type) {
            case NOT_RESOLVED: {
                str = Messages.getString(ResolutionsProxy.class, "resolutionType.notResolved");
                break;
            }
            case AUTOMATICALLY_RESOLVED: {
                str = Messages.getString(ResolutionsProxy.class, "resolutionType.automaticallyResolved");
                break;
            }
            case MANUALLY_RESOLVED: {
                str = Messages.getString(ResolutionsProxy.class, "resolutionType.manual");
            }
        }
        return str;
    }

    static class ResolutionContentConsumer
    extends HttpResponseConsumer {
        Exception ex = null;

        ResolutionContentConsumer() {
        }

        public void accept(String content) {
            L.trace("got a text in ResolutionContentConsumer: {}", (Object)content.length());
            if (content != null && !content.isEmpty()) {
                if (this.httpCode == 200) {
                    this.ret = content;
                } else {
                    try (JsonReader reader = null;){
                        try {
                            reader = Json.createReader((Reader)new StringReader(content));
                            JsonObject root = reader.readObject();
                            Object err = root.get((Object)"error");
                            Object code = root.get((Object)"code");
                            Object msg = root.get((Object)"msg");
                            L.error("request error;  code={}, msg={}, error={}", new Object[]{code, msg, err});
                            this.ex = new ResolutionException(this.httpCode, err.toString(), code.toString(), msg.toString());
                        }
                        catch (Exception e) {
                            L.info("while parsing request reply", (Throwable)e);
                            this.ex = new ResolutionException(this.httpCode, null, null, content);
                            if (reader != null) {
                                reader.close();
                            }
                        }
                    }
                }
            }
        }

        public Exception getException() {
            return this.ex;
        }

        public String getContent() {
            return this.ret;
        }
    }

    static class ResolutionsErrorHandler
    implements HTTPErrorHandler {
        String endpoint;
        String method;

        public ResolutionsErrorHandler(String endpoint, String httpMethod) {
            this.endpoint = endpoint;
            this.method = httpMethod;
        }

        public void execute(int responseCode, InputStream responseError) {
            L.error("request error; response={}", (Object)responseCode);
            ResolutionException ex = ResolutionsProxy.printErrorDetails(this.endpoint, responseCode, responseError);
            throw ex;
        }

        public void treatException(Exception e) {
            L.trace("exception running {}", (Object)this.endpoint, (Object)e);
            String msg = Messages.getString(ResolutionsProxy.class, "request.running.exception", new String[]{this.endpoint});
            throw new ResolutionException(msg, e);
        }
    }
}

