/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.analysis.api.view;

import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IFinishedListener;
import com.ez.analysisbrowser.views.BrowserManager;
import com.ez.internal.utils.ServiceUtils;
import com.ibm.ez.analysis.api.internal.Messages;
import com.ibm.ez.analysis.api.model.ApiInterface;
import com.ibm.ez.analysis.api.model.IAPIFillerService;
import com.ibm.ez.analysis.api.view.ApiDescriptor;
import com.ibm.ez.analysis.api.view.State;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshAPIAction
extends Action
implements IAction {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(RefreshAPIAction.class);
    private ApiDescriptor descriptor;
    private IActionContext icontext = null;
    private BrowserManager bm;

    public RefreshAPIAction(String text, ImageDescriptor imageDescriptor, BrowserManager bm) {
        super(text, imageDescriptor);
        this.bm = bm;
        this.descriptor = (ApiDescriptor)bm.getCurrent();
    }

    public RefreshAPIAction(ApiDescriptor apiDescriptor) {
        this.descriptor = apiDescriptor;
    }

    public boolean canHandle(IActionContext context) {
        return false;
    }

    public void setInputContext(IActionContext context) {
        this.icontext = context;
    }

    public IActionContext getOutputContext() {
        return this.descriptor.getState();
    }

    public void run() {
        if (this.bm != null) {
            this.bm.runInPlace((IAction)this, new IFinishedListener(){

                public void finished(boolean canceled, Throwable t) {
                    RefreshAPIAction.this.bm.updateTools();
                }
            });
        }
    }

    public void execute(IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor);
        monitor.beginTask(Messages.getString(RefreshAPIAction.class, "refreshAPI.taskName"), 100);
        boolean createState = true;
        boolean refresh = false;
        if (this.icontext != null) {
            Map data = this.icontext.getData();
            if (data != null) {
                Boolean doRefresh = (Boolean)data.get("REFRESH");
                if (doRefresh != null && !doRefresh.booleanValue() && this.icontext instanceof State) {
                    this.descriptor.setState((State)this.icontext);
                    createState = false;
                }
                if (doRefresh != null) {
                    refresh = doRefresh;
                }
            } else {
                refresh = true;
            }
        } else {
            refresh = true;
        }
        if (createState && !monitor.isCanceled()) {
            this.createState(refresh, (IProgressMonitor)monitor.newChild(100));
        }
        monitor.done();
    }

    private void createState(boolean doRefresh, IProgressMonitor pmonitor) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        IAPIFillerService service = (IAPIFillerService)ServiceUtils.getService(IAPIFillerService.class);
        if (doRefresh) {
            service.refresh((IProgressMonitor)monitor.newChild(90));
        }
        Set<ApiInterface> apis = service.getAPIs();
        if (!monitor.isCanceled()) {
            State state = new State();
            state.setAPIs(new ArrayList<ApiInterface>(apis));
            this.descriptor.setState(state);
        }
        monitor.setWorkRemaining(0);
    }
}

