/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.analysis.api.view;

import com.ez.analysisbrowser.actions.AbstractActionContext;
import com.ez.analysisbrowser.actions.IAction;
import com.ez.analysisbrowser.actions.IActionContext;
import com.ez.analysisbrowser.actions.IActionManager;
import com.ez.analysisbrowser.actions.IFinishedListener;
import com.ez.analysisbrowser.actions.IResultViewer;
import com.ez.analysisbrowser.views.BrowserManager;
import com.ez.internal.analysis.config.inputs.CatalogAPIInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ibm.ez.analysis.api.internal.Activator;
import com.ibm.ez.analysis.api.internal.Messages;
import com.ibm.ez.analysis.api.model.APIRelatedNode;
import com.ibm.ez.analysis.api.model.ApiInterface;
import com.ibm.ez.analysis.api.model.CatalogAPISg;
import com.ibm.ez.analysis.api.model.Node;
import com.ibm.ez.analysis.api.view.ApiContentProvider;
import com.ibm.ez.analysis.api.view.ApiDescriptor;
import com.ibm.ez.analysis.api.view.ApiLabelProvider;
import com.ibm.ez.analysis.api.view.State;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.progress.WorkbenchJob;

public class ApiViewer
implements IResultViewer {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String REFRESH_CONTEXT_KEY = "REFRESH";
    private ApiDescriptor descriptor;
    private TreeViewer viewer;
    private Text itemsNr;
    private FilterJob filterJob;
    private ImageRegistry ir;
    private Map<ApiInterface.Type, ImageDescriptor> imgDescriptors = new HashMap<ApiInterface.Type, ImageDescriptor>(){
        {
            this.put(ApiInterface.Type.API, Activator.getImageDescriptor("icons/api16x16.png"));
            this.put(ApiInterface.Type.SERVICE, Activator.getImageDescriptor("icons/ServicesSmall.png"));
        }
    };

    public ApiViewer(ApiDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Composite create(Composite parent, IAction action, IActionManager manager) {
        this.filterJob = new FilterJob();
        this.ir = new ImageRegistry(parent.getDisplay());
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        this.itemsNr = new Text(c, 8);
        this.itemsNr.setText("");
        this.itemsNr.setToolTipText(Messages.getString(ApiViewer.class, "numberOfItems.tooltip"));
        GridData gdt = new GridData();
        gdt.minimumWidth = 100;
        this.itemsNr.setLayoutData((Object)gdt);
        Text txt = this.createFilter(c);
        gdt = new GridData(768);
        txt.setLayoutData((Object)gdt);
        this.viewer = new TreeViewer(c, 66306);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setMenu(this.createContextMenu(tree, action, manager));
        gdt = new GridData(1808);
        gdt.grabExcessHorizontalSpace = true;
        gdt.grabExcessVerticalSpace = true;
        gdt.horizontalSpan = 2;
        tree.setLayoutData((Object)gdt);
        this.createColumns(c, tree);
        this.viewer.setContentProvider((IContentProvider)new ApiContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ApiLabelProvider(this.imgDescriptors, this.ir));
        ApiComparator comparator = new ApiComparator();
        this.viewer.setComparator((ViewerComparator)comparator);
        int dir = comparator.getDirection();
        tree.setSortDirection(dir);
        tree.setSortColumn(tree.getColumn(0));
        this.handleTableSelection(manager);
        this.fillTree();
        c.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ApiViewer.this.imgDescriptors.clear();
                ApiViewer.this.ir.dispose();
                ApiViewer.this.ir = null;
                ApiViewer.this.filterJob = null;
            }
        });
        return c;
    }

    private Menu createContextMenu(Tree tree, final IAction action, final IActionManager manager) {
        Menu menu = new Menu((Control)tree);
        MenuItem refreshItem = new MenuItem(menu, 8);
        refreshItem.setText(Messages.getString(ApiViewer.class, "reload.menuItem"));
        refreshItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ApiViewer.this.viewer.getTree().getSelection().length > 0) {
                    ApiViewer.this.viewer.getTree().deselectAll();
                    ((BrowserManager)manager).setCurrentContext(null);
                }
                action.setInputContext((IActionContext)new AbstractActionContext(){

                    public Map<String, Object> getData() {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put(ApiViewer.REFRESH_CONTEXT_KEY, true);
                        return data;
                    }

                    public String getId() {
                        return "com.ez.analysis.base.explore.api.descriptor";
                    }
                });
                manager.runInPlace(action, new IFinishedListener(){

                    public void finished(boolean canceled, Throwable t) {
                        ((BrowserManager)manager).updateTools();
                    }
                });
            }
        });
        return menu;
    }

    private void handleTableSelection(final IActionManager manager) {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss = (StructuredSelection)event.getSelection();
                final List apiInfos = ss.toList();
                final HashSet<EZEntityID> entities = new HashSet<EZEntityID>();
                final ArrayList<CatalogAPIInputType> inptTypes = new ArrayList<CatalogAPIInputType>();
                for (ApiInterface api : apiInfos) {
                    CatalogAPIInputType apiInpt = new CatalogAPIInputType();
                    EZEntityID apiID = new EZEntityID();
                    apiID.addSegment((EZSegment)new CatalogAPISg(api));
                    entities.add(apiID);
                    apiInpt.setEntID(apiID);
                    inptTypes.add(apiInpt);
                }
                if (!inptTypes.isEmpty()) {
                    AbstractActionContext context = new AbstractActionContext(){

                        public Map<String, Object> getData() {
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            data.put("ANALYSIS_TYPE_INPUTS", inptTypes);
                            data.put("SCOPE", entities);
                            data.put("NOT_COMPUTE_USAGE_RESULTS", Boolean.TRUE);
                            if (apiInfos.size() == 1) {
                                EZEntityID api = (EZEntityID)entities.iterator().next();
                                ISelection sel = ApiViewer.this.getSelection4PropertiesView(api);
                                if (sel != null) {
                                    data.put("selection", sel);
                                }
                            }
                            return data;
                        }

                        public String getId() {
                            return "com.ez.analysis.base.explore.api.descriptor";
                        }
                    };
                    ApiViewer.this.descriptor.getState().getData().putAll(context.getData());
                    manager.setCurrentContext((IActionContext)context);
                }
            }
        });
    }

    private ISelection getSelection4PropertiesView(EZEntityID apiID) {
        CatalogAPISg sg = (CatalogAPISg)apiID.getSegment(CatalogAPISg.class);
        ApiInterface n = sg.getNode();
        APIRelatedNode apiNode = new APIRelatedNode(n);
        return new StructuredSelection((Object)apiNode);
    }

    private Text createFilter(Composite parent) {
        final Text txt = new Text(parent, 388);
        txt.setMessage(Messages.getString(ApiViewer.class, "api.filter.message"));
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ApiViewer.this.filterJob.cancel();
                ApiViewer.this.filterJob.setFilter(txt.getText());
                ApiViewer.this.filterJob.schedule(100L);
            }
        });
        txt.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ApiViewer.this.filterJob.cancel();
                ApiViewer.this.filterJob.setFilter(txt.getText());
                ApiViewer.this.filterJob.schedule(100L);
            }
        });
        return txt;
    }

    private void createColumns(Composite parent, Tree viewer) {
        String[] titles = new String[]{Messages.getString(ApiViewer.class, "column1.header"), Messages.getString(ApiViewer.class, "column2.header"), Messages.getString(ApiViewer.class, "column3.header")};
        int i = 0;
        while (i < titles.length) {
            TreeColumn tc = new TreeColumn(viewer, 16384);
            tc.setText(titles[i]);
            switch (i) {
                case 0: {
                    tc.setWidth(160);
                    break;
                }
                default: {
                    tc.setWidth(120);
                }
            }
            tc.setResizable(true);
            tc.setMoveable(false);
            tc.addSelectionListener((SelectionListener)this.getSelectionAdapter(tc, i));
            ++i;
        }
    }

    private SelectionAdapter getSelectionAdapter(final TreeColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiComparator comparator = (ApiComparator)ApiViewer.this.viewer.getComparator();
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                ApiViewer.this.viewer.getTree().setSortDirection(dir);
                ApiViewer.this.viewer.getTree().setSortColumn(column);
                ApiViewer.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public void update() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ApiViewer.this.viewer != null) {
                    ApiViewer.this.fillTree();
                    ApiViewer.this.filterJob.cancel();
                    ApiViewer.this.filterJob.schedule(100L);
                }
            }
        });
    }

    private void fillTree() {
        State state = (State)this.descriptor.getState();
        ArrayList lst = state != null ? state.getAPIs() : new ArrayList();
        this.viewer.setInput(lst);
        int no = lst != null ? lst.size() : 0;
        this.changeItemsNo(no);
    }

    private void changeItemsNo(int no) {
        if (no > -1) {
            this.itemsNr.setText(Messages.getString(ApiViewer.class, "numberOfItems.text", new Object[]{no}));
        } else {
            this.itemsNr.setText("");
        }
    }

    private class ApiComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int DESCENDING = 1;
        private int direction = 0;

        private ApiComparator() {
        }

        public int category(Object element) {
            return super.category(element);
        }

        public void setColumn(int index) {
            if (index == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = index;
                this.direction = 0;
            }
        }

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Node n1 = (Node)e1;
            Node n2 = (Node)e2;
            int ret = 0;
            switch (this.propertyIndex) {
                case 0: {
                    ret = n1.compareTo(n2);
                    break;
                }
                case 1: {
                    ret = n1.getType().compareTo(n2.getType());
                    break;
                }
                case 2: {
                    Date date1 = new Date((Long)n1.getInfo().get("timestamp"));
                    Date date2 = new Date((Long)n2.getInfo().get("timestamp"));
                    ret = date1.compareTo(date2);
                }
            }
            if (this.direction == 1) {
                ret = -ret;
            }
            return ret;
        }

        public boolean isSorterProperty(Object element, String property) {
            return super.isSorterProperty(element, property);
        }

        public void sort(Viewer viewer, Object[] elements) {
            super.sort(viewer, elements);
        }
    }

    private class FilterJob
    extends WorkbenchJob {
        private String filter;

        public FilterJob() {
            super(Messages.getString(ApiViewer.class, "filter.job.name"));
            this.filter = null;
            this.setSystem(true);
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            MyViewerFilter vf = new MyViewerFilter();
            ApiViewer.this.viewer.setFilters(new ViewerFilter[]{vf});
            ApiViewer.this.changeItemsNo(ApiViewer.this.viewer.getTree().getItemCount());
            return Status.OK_STATUS;
        }

        class MyViewerFilter
        extends ViewerFilter {
            int no = 0;

            MyViewerFilter() {
            }

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                Node n = (Node)element;
                if (FilterJob.this.filter != null && !FilterJob.this.filter.isEmpty()) {
                    boolean ret = this.checkNode(n);
                    if (!ret && n.getType().equals((Object)ApiInterface.Type.API)) {
                        for (Node c : n.getChildren()) {
                            ret = this.checkNode(c);
                            if (!ret) continue;
                            ((TreeViewer)viewer).expandToLevel((Object)new TreePath((Object[])new Node[]{n}), 1);
                            System.out.println(c.getName());
                            ++this.no;
                            break;
                        }
                    }
                    return ret;
                }
                return true;
            }

            private boolean checkNode(Node n) {
                boolean ret = n.getName() == null || n.getName().toLowerCase().indexOf(FilterJob.this.filter.toLowerCase()) != -1;
                return ret;
            }
        }
    }
}

