/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ez.analysis.api.view;

import com.ibm.ez.analysis.api.model.ApiInterface;
import com.ibm.ez.analysis.api.model.Node;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ApiLabelProvider
implements ITableLabelProvider {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2017.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    Map<ApiInterface.Type, ImageDescriptor> imgDescriptors;
    ImageRegistry ir;

    public ApiLabelProvider(Map<ApiInterface.Type, ImageDescriptor> imgDescriptors, ImageRegistry ir) {
        this.imgDescriptors = imgDescriptors;
        this.ir = ir;
    }

    public String getColumnText(Object element, int columnIndex) {
        String txt = null;
        Node n = (Node)element;
        if (n != null) {
            switch (columnIndex) {
                case 0: {
                    txt = n.getName();
                    break;
                }
                case 1: {
                    txt = n.getType().getName();
                    break;
                }
                case 2: {
                    long d1 = -1L;
                    if (n.getInfo() != null) {
                        Object o = n.getInfo().get("timestamp");
                        long l = d1 = o != null ? (Long)o : d1;
                    }
                    if (d1 != -1L) {
                        Date date = new Date((Long)n.getInfo().get("timestamp"));
                        txt = DateFormat.getDateTimeInstance(1, 1).format(date);
                        break;
                    }
                    txt = "";
                    break;
                }
            }
        }
        return txt;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Node n;
        Image img = null;
        if (columnIndex == 0 && element != null && element instanceof Node && (img = this.ir.get((n = (Node)element).getType().toString())) == null) {
            this.ir.put(n.getType().toString(), this.imgDescriptors.get((Object)n.getType()).createImage());
            img = this.ir.get(n.getType().toString());
        }
        return img;
    }
}

